/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_gear.enchantments.melee_ranged;

import com.infamous.dungeons_gear.DungeonsGear;
import com.infamous.dungeons_gear.enchantments.ModEnchantmentTypes;
import com.infamous.dungeons_gear.enchantments.lists.MeleeRangedEnchantmentList;
import com.infamous.dungeons_gear.enchantments.types.HealingEnchantment;
import com.infamous.dungeons_gear.init.ParticleInit;
import com.infamous.dungeons_gear.utilties.EnchantUtils;
import java.lang.reflect.Method;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

@Mod.EventBusSubscriber(modid="dungeons_gear")
public class AnimaConduitEnchantment
extends HealingEnchantment {
    public AnimaConduitEnchantment() {
        super(Enchantment.Rarity.RARE, ModEnchantmentTypes.MELEE_RANGED, new EquipmentSlotType[]{EquipmentSlotType.MAINHAND});
    }

    public int func_77325_b() {
        return 3;
    }

    public boolean func_77326_a(Enchantment enchantment) {
        return !(enchantment instanceof HealingEnchantment);
    }

    @SubscribeEvent
    public static void onAnimaConduitKill(LivingDeathEvent event) {
        if (event.getSource() instanceof IndirectEntityDamageSource) {
            IndirectEntityDamageSource indirectEntityDamageSource = (IndirectEntityDamageSource)event.getSource();
            if (indirectEntityDamageSource.func_76364_f() instanceof AbstractArrowEntity) {
                LivingEntity victim;
                AbstractArrowEntity arrowEntity = (AbstractArrowEntity)indirectEntityDamageSource.func_76364_f();
                int animaConduitLevel = EnchantUtils.enchantmentTagToLevel(arrowEntity, MeleeRangedEnchantmentList.ANIMA_CONDUIT);
                if (animaConduitLevel > 0 && (victim = event.getEntityLiving()) instanceof MobEntity) {
                    LivingEntity attacker;
                    MobEntity mobEntity = (MobEntity)victim;
                    if (indirectEntityDamageSource.func_76346_g() instanceof LivingEntity && (attacker = (LivingEntity)indirectEntityDamageSource.func_76346_g()) instanceof PlayerEntity) {
                        PlayerEntity playerEntity = (PlayerEntity)attacker;
                        int experiencePoints = AnimaConduitEnchantment.getDroppedExperience(mobEntity, playerEntity);
                        double soulsToHealth = (double)experiencePoints * (0.01 * (double)animaConduitLevel);
                        DungeonsGear.PROXY.spawnParticles((Entity)playerEntity, (BasicParticleType)ParticleInit.SOUL.get());
                        playerEntity.func_70691_i((float)soulsToHealth);
                    }
                }
            } else if (event.getSource().func_76346_g() instanceof LivingEntity) {
                LivingEntity attacker = (LivingEntity)event.getSource().func_76346_g();
                LivingEntity victim = event.getEntityLiving();
                ItemStack mainhand = attacker.func_184614_ca();
                if (victim instanceof MobEntity) {
                    MobEntity mobEntity = (MobEntity)victim;
                    if (EnchantUtils.hasEnchantment(mainhand, MeleeRangedEnchantmentList.ANIMA_CONDUIT)) {
                        int animaConduitLevel = EnchantmentHelper.func_77506_a((Enchantment)MeleeRangedEnchantmentList.ANIMA_CONDUIT, (ItemStack)mainhand);
                        if (attacker instanceof PlayerEntity) {
                            PlayerEntity playerEntity = (PlayerEntity)attacker;
                            int experiencePoints = AnimaConduitEnchantment.getDroppedExperience(mobEntity, playerEntity);
                            double soulsToHealth = (double)experiencePoints * (0.01 * (double)animaConduitLevel);
                            DungeonsGear.PROXY.spawnParticles((Entity)playerEntity, (BasicParticleType)ParticleInit.SOUL.get());
                            playerEntity.func_70691_i((float)soulsToHealth);
                        }
                    }
                }
            }
        }
    }

    private static int getDroppedExperience(MobEntity mobEntity, PlayerEntity player) {
        try {
            Method m = ObfuscationReflectionHelper.findMethod(MobEntity.class, (String)"func_70693_a", (Class[])new Class[]{PlayerEntity.class});
            return (Integer)m.invoke((Object)mobEntity, player);
        }
        catch (Exception e) {
            DungeonsGear.LOGGER.error("Reflection error ", (Throwable)e);
            return 0;
        }
    }
}

