/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_gear.enchantments.melee_ranged;

import com.infamous.dungeons_gear.DungeonsGear;
import com.infamous.dungeons_gear.enchantments.ModEnchantmentTypes;
import com.infamous.dungeons_gear.enchantments.lists.MeleeRangedEnchantmentList;
import com.infamous.dungeons_gear.enchantments.types.DamageBoostEnchantment;
import com.infamous.dungeons_gear.init.ParticleInit;
import com.infamous.dungeons_gear.items.WeaponList;
import com.infamous.dungeons_gear.utilties.EnchantUtils;
import net.minecraft.enchantment.DamageEnchantment;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.BasicParticleType;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="dungeons_gear")
public class EnigmaResonatorEnchantment
extends DamageBoostEnchantment {
    public EnigmaResonatorEnchantment() {
        super(Enchantment.Rarity.RARE, ModEnchantmentTypes.MELEE_RANGED, new EquipmentSlotType[]{EquipmentSlotType.MAINHAND});
    }

    public int func_77325_b() {
        return 3;
    }

    public boolean func_77326_a(Enchantment enchantment) {
        return !(enchantment instanceof DamageEnchantment) && !(enchantment instanceof DamageBoostEnchantment);
    }

    @SubscribeEvent
    public static void onVanillaNonCriticalHit(CriticalHitEvent event) {
        if (event.getPlayer() == null) {
            return;
        }
        PlayerEntity attacker = event.getPlayer();
        LivingEntity victim = event.getEntityLiving();
        ItemStack mainhand = attacker.func_184614_ca();
        boolean uniqueWeaponFlag = mainhand.func_77973_b() == WeaponList.SOUL_FIST || mainhand.func_77973_b() == WeaponList.MOON_DAGGER;
        int numSouls = Math.min(attacker.field_71067_cb, 50);
        if (!event.isVanillaCritical()) {
            float soulsCriticalBoostRand;
            if (EnchantUtils.hasEnchantment(mainhand, MeleeRangedEnchantmentList.ENIGMA_RESONATOR)) {
                float soulsCriticalBoostRand2;
                int enigmaResonatorLevel = EnchantmentHelper.func_77506_a((Enchantment)MeleeRangedEnchantmentList.ENIGMA_RESONATOR, (ItemStack)mainhand);
                float soulsCriticalBoostChanceCap = 0.0f;
                if (enigmaResonatorLevel == 1) {
                    soulsCriticalBoostChanceCap = 0.15f;
                }
                if (enigmaResonatorLevel == 2) {
                    soulsCriticalBoostChanceCap = 0.2f;
                }
                if (enigmaResonatorLevel == 3) {
                    soulsCriticalBoostChanceCap = 0.25f;
                }
                if ((double)(soulsCriticalBoostRand2 = attacker.func_70681_au().nextFloat()) <= Math.min((double)numSouls / 50.0, (double)soulsCriticalBoostChanceCap)) {
                    event.setResult(Event.Result.ALLOW);
                    float newDamageModifier = event.getDamageModifier() == event.getOldDamageModifier() ? event.getDamageModifier() + 1.5f : event.getDamageModifier() * 3.0f;
                    event.setDamageModifier(newDamageModifier);
                    DungeonsGear.PROXY.spawnParticles((Entity)attacker, (BasicParticleType)ParticleInit.SOUL.get());
                }
            }
            if (uniqueWeaponFlag && (double)(soulsCriticalBoostRand = attacker.func_70681_au().nextFloat()) <= Math.min((double)numSouls / 50.0, (double)0.15f)) {
                event.setResult(Event.Result.ALLOW);
                float newDamageModifier = event.getDamageModifier() == event.getOldDamageModifier() ? event.getDamageModifier() + 1.5f : event.getDamageModifier() * 3.0f;
                event.setDamageModifier(newDamageModifier);
                DungeonsGear.PROXY.spawnParticles((Entity)attacker, (BasicParticleType)ParticleInit.SOUL.get());
            }
        }
    }
}

