/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_gear.enchantments.melee_ranged;

import com.infamous.dungeons_gear.damagesources.OffhandAttackDamageSource;
import com.infamous.dungeons_gear.enchantments.ModEnchantmentTypes;
import com.infamous.dungeons_gear.enchantments.lists.MeleeRangedEnchantmentList;
import com.infamous.dungeons_gear.items.RangedWeaponList;
import com.infamous.dungeons_gear.items.WeaponList;
import com.infamous.dungeons_gear.utilties.AbilityUtils;
import com.infamous.dungeons_gear.utilties.EnchantUtils;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="dungeons_gear")
public class GravityEnchantment
extends Enchantment {
    public GravityEnchantment() {
        super(Enchantment.Rarity.RARE, ModEnchantmentTypes.MELEE_RANGED, new EquipmentSlotType[]{EquipmentSlotType.MAINHAND});
    }

    public int func_77325_b() {
        return 3;
    }

    public void func_151368_a(LivingEntity user, Entity target, int level) {
        boolean uniqueWeaponFlag;
        if (!(target instanceof LivingEntity)) {
            return;
        }
        ItemStack mainhand = user.func_184614_ca();
        boolean bl = uniqueWeaponFlag = mainhand.func_77973_b() == WeaponList.HAMMER_OF_GRAVITY || mainhand.func_77973_b() == RangedWeaponList.VOIDCALLER || mainhand.func_77973_b() == RangedWeaponList.IMPLODING_CROSSBOW;
        if (uniqueWeaponFlag) {
            ++level;
        }
        AbilityUtils.pullInNearbyEntities(user, (LivingEntity)target, level * 3);
    }

    @SubscribeEvent
    public static void onHammerOfGravityAttack(LivingAttackEvent event) {
        if (event.getSource().func_76364_f() instanceof AbstractArrowEntity) {
            return;
        }
        if (event.getSource() instanceof OffhandAttackDamageSource) {
            return;
        }
        if (!(event.getSource().func_76346_g() instanceof LivingEntity)) {
            return;
        }
        LivingEntity attacker = (LivingEntity)event.getSource().func_76346_g();
        LivingEntity victim = event.getEntityLiving();
        ItemStack mainhand = attacker.func_184614_ca();
        if (mainhand.func_77973_b() == WeaponList.HAMMER_OF_GRAVITY && !EnchantUtils.hasEnchantment(mainhand, MeleeRangedEnchantmentList.GRAVITY)) {
            AbilityUtils.pullInNearbyEntities(attacker, victim, 3.0f);
        }
    }

    @SubscribeEvent
    public static void onGravityCrossbowImpact(ProjectileImpactEvent.Arrow event) {
        boolean uniqueWeaponFlag;
        RayTraceResult rayTraceResult = event.getRayTraceResult();
        AbstractArrowEntity arrow = event.getArrow();
        if (!EnchantUtils.shooterIsLiving(arrow)) {
            return;
        }
        LivingEntity shooter = (LivingEntity)arrow.func_212360_k();
        int gravityLevel = EnchantUtils.enchantmentTagToLevel(arrow, MeleeRangedEnchantmentList.GRAVITY);
        boolean bl = uniqueWeaponFlag = arrow.func_184216_O().contains("Voidcaller") || arrow.func_184216_O().contains("ImplodingCrossbow");
        if (uniqueWeaponFlag && gravityLevel <= 0) {
            EntityRayTraceResult entityRayTraceResult;
            if (rayTraceResult instanceof EntityRayTraceResult && (entityRayTraceResult = (EntityRayTraceResult)rayTraceResult).func_216348_a() instanceof LivingEntity) {
                LivingEntity victim = (LivingEntity)((EntityRayTraceResult)rayTraceResult).func_216348_a();
                AbilityUtils.pullInNearbyEntities(shooter, victim, 3.0f);
            }
            if (rayTraceResult instanceof BlockRayTraceResult) {
                BlockRayTraceResult blockRayTraceResult = (BlockRayTraceResult)rayTraceResult;
                BlockPos blockPos = blockRayTraceResult.func_216350_a();
                AbilityUtils.pullInNearbyEntitiesAtPos(shooter, blockPos, 3);
            }
        } else if (gravityLevel > 0) {
            if (uniqueWeaponFlag) {
                ++gravityLevel;
            }
            if (rayTraceResult instanceof BlockRayTraceResult) {
                BlockRayTraceResult blockRayTraceResult = (BlockRayTraceResult)rayTraceResult;
                BlockPos blockPos = blockRayTraceResult.func_216350_a();
                AbilityUtils.pullInNearbyEntitiesAtPos(shooter, blockPos, 3 * gravityLevel);
            }
        }
    }
}

