/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_gear.enchantments.ranged;

import com.infamous.dungeons_gear.enchantments.ModEnchantmentTypes;
import com.infamous.dungeons_gear.enchantments.lists.RangedEnchantmentList;
import com.infamous.dungeons_gear.utilties.EnchantUtils;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="dungeons_gear")
public class GrowingEnchantment
extends Enchantment {
    public GrowingEnchantment() {
        super(Enchantment.Rarity.RARE, ModEnchantmentTypes.RANGED, new EquipmentSlotType[]{EquipmentSlotType.MAINHAND});
    }

    public int func_77325_b() {
        return 3;
    }

    public boolean func_77326_a(Enchantment enchantment) {
        return enchantment != Enchantments.field_185309_u;
    }

    @SubscribeEvent
    public static void onGrowingImpact(ProjectileImpactEvent.Arrow event) {
        boolean uniqueWeaponFlag;
        RayTraceResult rayTraceResult = event.getRayTraceResult();
        if (!EnchantUtils.arrowHitLivingEntity(rayTraceResult)) {
            return;
        }
        AbstractArrowEntity arrow = event.getArrow();
        if (!EnchantUtils.shooterIsLiving(arrow)) {
            return;
        }
        LivingEntity shooter = (LivingEntity)arrow.func_212360_k();
        LivingEntity victim = (LivingEntity)((EntityRayTraceResult)rayTraceResult).func_216348_a();
        int growingLevel = EnchantUtils.enchantmentTagToLevel(arrow, RangedEnchantmentList.GROWING);
        boolean bl = uniqueWeaponFlag = arrow.func_184216_O().contains("Bonebow") || arrow.func_184216_O().contains("BabyCrossbow");
        if (growingLevel > 0 || uniqueWeaponFlag) {
            double originalDamage = arrow.func_70242_d();
            double damageModifierCap = 0.0;
            if (growingLevel == 1) {
                damageModifierCap = 1.25;
            }
            if (growingLevel == 2) {
                damageModifierCap = 1.5;
            }
            if (growingLevel == 3) {
                damageModifierCap = 1.75;
            }
            if (uniqueWeaponFlag) {
                damageModifierCap += 1.25;
            }
            double squareDistanceTo = shooter.func_70068_e((Entity)victim);
            double distance = Math.sqrt(squareDistanceTo);
            double distanceTraveledModifier = distance * 0.1;
            arrow.func_70239_b(originalDamage * Math.min(distanceTraveledModifier, damageModifierCap));
        }
    }
}

