/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_gear.enchantments.ranged;

import com.infamous.dungeons_gear.enchantments.ModEnchantmentTypes;
import com.infamous.dungeons_gear.enchantments.lists.RangedEnchantmentList;
import com.infamous.dungeons_gear.utilties.AbilityUtils;
import com.infamous.dungeons_gear.utilties.EnchantUtils;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="dungeons_gear")
public class RadianceShotEnchantment
extends Enchantment {
    public RadianceShotEnchantment() {
        super(Enchantment.Rarity.RARE, ModEnchantmentTypes.RANGED, new EquipmentSlotType[]{EquipmentSlotType.MAINHAND});
    }

    public int func_77325_b() {
        return 3;
    }

    @SubscribeEvent
    public static void onSabrewingImpact(ProjectileImpactEvent.Arrow event) {
        BlockPos blockPos;
        float radianceShotRand;
        RayTraceResult rayTraceResult = event.getRayTraceResult();
        AbstractArrowEntity arrow = event.getArrow();
        if (!EnchantUtils.shooterIsLiving(arrow)) {
            return;
        }
        LivingEntity shooter = (LivingEntity)arrow.func_212360_k();
        int radianceShotLevel = EnchantUtils.enchantmentTagToLevel(arrow, RangedEnchantmentList.RADIANCE_SHOT);
        boolean uniqueWeaponFlag = arrow.func_184216_O().contains("Sabrewing");
        if (radianceShotLevel > 0 && (radianceShotRand = shooter.func_70681_au().nextFloat()) <= 0.2f) {
            if (uniqueWeaponFlag) {
                ++radianceShotLevel;
            }
            if (rayTraceResult instanceof BlockRayTraceResult) {
                blockPos = ((BlockRayTraceResult)rayTraceResult).func_216350_a();
                AbilityUtils.spawnRegenCloudAtPos(shooter, true, blockPos, radianceShotLevel - 1);
            }
        }
        if (uniqueWeaponFlag && (radianceShotRand = shooter.func_70681_au().nextFloat()) <= 0.2f && rayTraceResult instanceof BlockRayTraceResult) {
            blockPos = ((BlockRayTraceResult)rayTraceResult).func_216350_a();
            AbilityUtils.spawnRegenCloudAtPos(shooter, true, blockPos, 0);
        }
    }
}

