/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_gear.enchantments.ranged;

import com.infamous.dungeons_gear.enchantments.ModEnchantmentTypes;
import com.infamous.dungeons_gear.enchantments.lists.RangedEnchantmentList;
import com.infamous.dungeons_gear.utilties.EnchantUtils;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ReplenishEnchantment
extends Enchantment {
    public ReplenishEnchantment() {
        super(Enchantment.Rarity.RARE, ModEnchantmentTypes.RANGED, new EquipmentSlotType[]{EquipmentSlotType.MAINHAND});
    }

    public int func_77325_b() {
        return 3;
    }

    public boolean func_77326_a(Enchantment enchantment) {
        return enchantment != Enchantments.field_185312_x;
    }

    @SubscribeEvent
    public static void onReplenishImpact(ProjectileImpactEvent.Arrow event) {
        RayTraceResult rayTraceResult = event.getRayTraceResult();
        if (!EnchantUtils.arrowHitLivingEntity(rayTraceResult)) {
            return;
        }
        AbstractArrowEntity arrow = event.getArrow();
        if (!EnchantUtils.shooterIsLiving(arrow)) {
            return;
        }
        LivingEntity shooter = (LivingEntity)arrow.func_212360_k();
        if (shooter instanceof PlayerEntity) {
            float replenishRand;
            PlayerEntity player = (PlayerEntity)shooter;
            int replenishLevel = EnchantUtils.enchantmentTagToLevel(arrow, RangedEnchantmentList.REPLENISH);
            LivingEntity victim = (LivingEntity)((EntityRayTraceResult)rayTraceResult).func_216348_a();
            if (replenishLevel > 0) {
                replenishRand = shooter.func_70681_au().nextFloat();
                float replenishChance = 0.0f;
                if (replenishLevel == 1) {
                    replenishChance = 0.1f;
                }
                if (replenishLevel == 2) {
                    replenishChance = 0.17f;
                }
                if (replenishLevel == 3) {
                    replenishChance = 0.24f;
                }
                if (replenishRand <= replenishChance) {
                    ItemEntity arrowDrop = new ItemEntity(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), new ItemStack((IItemProvider)Items.field_151032_g));
                    shooter.field_70170_p.func_217376_c((Entity)arrowDrop);
                }
            }
            if (arrow.func_184216_O().contains("HuntersPromise") && (replenishRand = shooter.func_70681_au().nextFloat()) <= 0.1f) {
                ItemEntity arrowDrop = new ItemEntity(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), new ItemStack((IItemProvider)Items.field_151032_g));
                shooter.field_70170_p.func_217376_c((Entity)arrowDrop);
            }
        }
    }
}

