/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_gear.enchantments.ranged;

import com.infamous.dungeons_gear.enchantments.ModEnchantmentTypes;
import com.infamous.dungeons_gear.enchantments.lists.RangedEnchantmentList;
import com.infamous.dungeons_gear.utilties.EnchantUtils;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="dungeons_gear")
public class SuperchargeEnchantment
extends Enchantment {
    public SuperchargeEnchantment() {
        super(Enchantment.Rarity.RARE, ModEnchantmentTypes.RANGED, new EquipmentSlotType[]{EquipmentSlotType.MAINHAND});
    }

    public int func_77325_b() {
        return 3;
    }

    public boolean func_77326_a(Enchantment enchantment) {
        return enchantment != Enchantments.field_185310_v || enchantment != Enchantments.field_185309_u;
    }

    @SubscribeEvent
    public static void onSuperchargeImpact(ProjectileImpactEvent.Arrow event) {
        if (!EnchantUtils.arrowHitLivingEntity(event.getRayTraceResult())) {
            return;
        }
        AbstractArrowEntity arrow = event.getArrow();
        if (!EnchantUtils.shooterIsLiving(arrow)) {
            return;
        }
        int superchargeLevel = EnchantUtils.enchantmentTagToLevel(arrow, RangedEnchantmentList.SUPERCHARGE);
        boolean uniqueWeaponFlag = arrow.func_184216_O().contains("GuardianBow");
        if (superchargeLevel > 0 || uniqueWeaponFlag) {
            double originalDamage = arrow.func_70242_d();
            int originalKnockback = EnchantUtils.enchantmentTagToLevel(arrow, Enchantments.field_185310_v);
            double damageModifier = 0.0;
            if (superchargeLevel == 1) {
                damageModifier = 1.2;
            }
            if (superchargeLevel == 2) {
                damageModifier = 1.4;
            }
            if (superchargeLevel == 3) {
                damageModifier = 1.6;
            }
            if (uniqueWeaponFlag) {
                damageModifier += 1.2;
            }
            arrow.func_70239_b(originalDamage * damageModifier);
            arrow.func_70240_a(originalKnockback + 1);
        }
    }
}

