/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_gear.enchantments.ranged;

import com.infamous.dungeons_gear.enchantments.ModEnchantmentTypes;
import com.infamous.dungeons_gear.enchantments.lists.RangedEnchantmentList;
import com.infamous.dungeons_gear.utilties.AbilityUtils;
import com.infamous.dungeons_gear.utilties.EnchantUtils;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="dungeons_gear")
public class TempoTheftEnchantment
extends Enchantment {
    public TempoTheftEnchantment() {
        super(Enchantment.Rarity.RARE, ModEnchantmentTypes.RANGED, new EquipmentSlotType[]{EquipmentSlotType.MAINHAND});
    }

    public int func_77325_b() {
        return 3;
    }

    @SubscribeEvent
    public static void onNocturnalBowImpact(ProjectileImpactEvent.Arrow event) {
        RayTraceResult rayTraceResult = event.getRayTraceResult();
        if (!EnchantUtils.arrowHitLivingEntity(rayTraceResult)) {
            return;
        }
        AbstractArrowEntity arrow = event.getArrow();
        if (!EnchantUtils.shooterIsLiving(arrow)) {
            return;
        }
        LivingEntity shooter = (LivingEntity)arrow.func_212360_k();
        LivingEntity victim = (LivingEntity)((EntityRayTraceResult)rayTraceResult).func_216348_a();
        int tempoTheftLevel = EnchantUtils.enchantmentTagToLevel(arrow, RangedEnchantmentList.TEMPO_THEFT);
        boolean uniqueWeaponFlag = arrow.func_184216_O().contains("NocturnalBow");
        if (tempoTheftLevel > 0 || uniqueWeaponFlag) {
            if (uniqueWeaponFlag) {
                ++tempoTheftLevel;
            }
            AbilityUtils.stealSpeedFromTarget(shooter, victim, tempoTheftLevel);
        }
    }
}

