/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_gear.goals;

import com.infamous.dungeons_gear.goals.GoalUtils;
import java.util.EnumSet;
import net.minecraft.block.BlockState;
import net.minecraft.block.LeavesBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.WalkNodeProcessor;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;

public class IronGolemFollowOwnerGoal
extends Goal {
    private final IronGolemEntity ironGolemEntity;
    private LivingEntity owner;
    private final IWorldReader world;
    private final double followSpeed;
    private final PathNavigator navigator;
    private int timeToRecalcPath;
    private final float maxDist;
    private final float minDist;
    private float oldWaterCost;
    private final boolean passesThroughLeaves;

    public IronGolemFollowOwnerGoal(IronGolemEntity ironGolemEntity, double followSpeed, float minDist, float maxDist, boolean passesThroughLeaves) {
        this.ironGolemEntity = ironGolemEntity;
        this.world = ironGolemEntity.field_70170_p;
        this.followSpeed = followSpeed;
        this.navigator = ironGolemEntity.func_70661_as();
        this.minDist = minDist;
        this.maxDist = maxDist;
        this.passesThroughLeaves = passesThroughLeaves;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        if (!(ironGolemEntity.func_70661_as() instanceof GroundPathNavigator) && !(ironGolemEntity.func_70661_as() instanceof FlyingPathNavigator)) {
            throw new IllegalArgumentException("Unsupported mob type for FollowOwnerGoal");
        }
    }

    public boolean func_75250_a() {
        LivingEntity livingentity = GoalUtils.getOwner(this.ironGolemEntity);
        if (livingentity == null) {
            return false;
        }
        if (livingentity.func_175149_v()) {
            return false;
        }
        if (this.ironGolemEntity.func_110167_bD()) {
            return false;
        }
        if (this.ironGolemEntity.func_70068_e((Entity)livingentity) < (double)(this.minDist * this.minDist)) {
            return false;
        }
        this.owner = livingentity;
        return true;
    }

    public boolean func_75253_b() {
        if (this.navigator.func_75500_f()) {
            return false;
        }
        if (this.ironGolemEntity.func_110167_bD()) {
            return false;
        }
        return !(this.ironGolemEntity.func_70068_e((Entity)this.owner) <= (double)(this.maxDist * this.maxDist));
    }

    public void func_75249_e() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.ironGolemEntity.func_184643_a(PathNodeType.WATER);
        this.ironGolemEntity.func_184644_a(PathNodeType.WATER, 0.0f);
    }

    public void func_75251_c() {
        this.owner = null;
        this.navigator.func_75499_g();
        this.ironGolemEntity.func_184644_a(PathNodeType.WATER, this.oldWaterCost);
    }

    public void func_75246_d() {
        this.ironGolemEntity.func_70671_ap().func_75651_a((Entity)this.owner, 10.0f, (float)this.ironGolemEntity.func_70646_bf());
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = 10;
            if (!this.ironGolemEntity.func_110167_bD() && !this.ironGolemEntity.func_184218_aH()) {
                if (this.ironGolemEntity.func_70068_e((Entity)this.owner) >= 144.0) {
                    this.func_226330_g_();
                } else {
                    this.navigator.func_75497_a((Entity)this.owner, this.followSpeed);
                }
            }
        }
    }

    private void func_226330_g_() {
        BlockPos blockpos = this.owner.func_180425_c();
        for (int i = 0; i < 10; ++i) {
            int j = this.func_226327_a_(-3, 3);
            int k = this.func_226327_a_(-1, 1);
            int l = this.func_226327_a_(-3, 3);
            boolean flag = this.func_226328_a_(blockpos.func_177958_n() + j, blockpos.func_177956_o() + k, blockpos.func_177952_p() + l);
            if (!flag) continue;
            return;
        }
    }

    private boolean func_226328_a_(int p_226328_1_, int p_226328_2_, int p_226328_3_) {
        if (Math.abs((double)p_226328_1_ - this.owner.func_226277_ct_()) < 2.0 && Math.abs((double)p_226328_3_ - this.owner.func_226281_cx_()) < 2.0) {
            return false;
        }
        if (!this.func_226329_a_(new BlockPos(p_226328_1_, p_226328_2_, p_226328_3_))) {
            return false;
        }
        this.ironGolemEntity.func_70012_b((double)p_226328_1_ + 0.5, (double)p_226328_2_, (double)p_226328_3_ + 0.5, this.ironGolemEntity.field_70177_z, this.ironGolemEntity.field_70125_A);
        this.navigator.func_75499_g();
        return true;
    }

    private boolean func_226329_a_(BlockPos blockPos) {
        PathNodeType pathnodetype = WalkNodeProcessor.func_227480_b_((IBlockReader)this.world, (int)blockPos.func_177958_n(), (int)blockPos.func_177956_o(), (int)blockPos.func_177952_p());
        if (pathnodetype != PathNodeType.WALKABLE) {
            return false;
        }
        BlockState blockstate = this.world.func_180495_p(blockPos.func_177977_b());
        if (!this.passesThroughLeaves && blockstate.func_177230_c() instanceof LeavesBlock) {
            return false;
        }
        BlockPos blockpos = blockPos.func_177973_b((Vec3i)this.ironGolemEntity.func_180425_c());
        return this.world.func_226665_a__((Entity)this.ironGolemEntity, this.ironGolemEntity.func_174813_aQ().func_186670_a(blockpos));
    }

    private int func_226327_a_(int p_226327_1_, int p_226327_2_) {
        return this.ironGolemEntity.func_70681_au().nextInt(p_226327_2_ - p_226327_1_ + 1) + p_226327_1_;
    }
}

