/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_gear.loot;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.infamous.dungeons_gear.DungeonsGear;
import com.infamous.dungeons_gear.config.DungeonsGearConfig;
import com.infamous.dungeons_gear.items.ArmorList;
import com.infamous.dungeons_gear.items.ArtifactList;
import com.infamous.dungeons_gear.items.RangedWeaponList;
import com.infamous.dungeons_gear.items.WeaponList;
import com.infamous.dungeons_gear.loot.LootUtils;
import com.infamous.dungeons_gear.loot.TradeUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.merchant.IReputationType;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.entity.merchant.villager.WanderingTraderEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.common.BasicTrade;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="dungeons_gear")
public class LootHandler {
    @SubscribeEvent
    public static void onWandererTrades(WandererTradesEvent event) {
        if (!((Boolean)DungeonsGearConfig.COMMON.ENABLE_VILLAGER_TRADES.get()).booleanValue()) {
            return;
        }
        List genericTrades = event.getGenericTrades();
        List rareTrades = event.getRareTrades();
        LootHandler.moveTradesToDifferentGroup(rareTrades, genericTrades);
        for (Item item : ArtifactList.artifactMap.keySet()) {
            ResourceLocation resourceLocation = ArtifactList.artifactMap.get(item);
            Item artifact = (Item)ForgeRegistries.ITEMS.getValue(resourceLocation);
            ItemStack artifactStack = new ItemStack((IItemProvider)artifact);
            BasicTrade trade = new BasicTrade(((Integer)DungeonsGearConfig.COMMON.ARTIFACT_VALUE.get()).intValue(), artifactStack, 3, 30);
            rareTrades.add(trade);
        }
    }

    @SubscribeEvent
    public static void onVillagerTrades(VillagerTradesEvent event) {
        if (!((Boolean)DungeonsGearConfig.COMMON.ENABLE_VILLAGER_TRADES.get()).booleanValue()) {
            return;
        }
        if (event.getType() == VillagerProfession.field_221165_o) {
            Int2ObjectMap weaponsmithTrades = event.getTrades();
            VillagerTrades.ITrade diamondForEmeraldTrade = (VillagerTrades.ITrade)((List)weaponsmithTrades.get(4)).get(0);
            ((List)weaponsmithTrades.get(3)).add(diamondForEmeraldTrade);
            ((List)weaponsmithTrades.get(4)).remove(0);
            LootHandler.addCommonAndUniqueTrades((Int2ObjectMap<List<VillagerTrades.ITrade>>)weaponsmithTrades, WeaponList.commonWeaponMap, WeaponList.uniqueWeaponMap);
        }
        if (event.getType() == VillagerProfession.field_221158_h) {
            Int2ObjectMap fletcherTrades = event.getTrades();
            VillagerTrades.ITrade emeraldForFeatherTrade = (VillagerTrades.ITrade)((List)fletcherTrades.get(4)).get(0);
            VillagerTrades.ITrade emeraldForTripwireHookTrade = (VillagerTrades.ITrade)((List)fletcherTrades.get(5)).get(0);
            VillagerTrades.ITrade emeraldAndArrowForTippedArrowTrade = (VillagerTrades.ITrade)((List)fletcherTrades.get(5)).get(2);
            ((List)fletcherTrades.get(2)).add(emeraldForFeatherTrade);
            ((List)fletcherTrades.get(3)).add(emeraldForTripwireHookTrade);
            ((List)fletcherTrades.get(3)).add(emeraldAndArrowForTippedArrowTrade);
            ((List)fletcherTrades.get(4)).remove(0);
            ((List)fletcherTrades.get(5)).remove(0);
            ((List)fletcherTrades.get(5)).remove(1);
            LootHandler.addCommonAndUniqueTrades((Int2ObjectMap<List<VillagerTrades.ITrade>>)fletcherTrades, RangedWeaponList.commonRangedWeaponMap, RangedWeaponList.uniqueRangedWeaponMap);
        }
        if (event.getType() == VillagerProfession.field_221152_b) {
            Int2ObjectMap armorerTrades = event.getTrades();
            LootHandler.addCommonAndUniqueTrades((Int2ObjectMap<List<VillagerTrades.ITrade>>)armorerTrades, ArmorList.commonMetalArmorMap, ArmorList.uniqueMetalArmorMap);
        }
        if (event.getType() == VillagerProfession.field_221159_i) {
            Int2ObjectMap leatherworkerTrades = event.getTrades();
            LootHandler.moveTradesToDifferentGroup((List)leatherworkerTrades.get(4), (List)leatherworkerTrades.get(2));
            LootHandler.moveTradesToDifferentGroup((List)leatherworkerTrades.get(5), (List)leatherworkerTrades.get(3));
            LootHandler.addCommonAndUniqueTrades((Int2ObjectMap<List<VillagerTrades.ITrade>>)leatherworkerTrades, ArmorList.commonLeatherArmorMap, ArmorList.uniqueLeatherArmorMap);
        }
    }

    private static void addCommonAndUniqueTrades(Int2ObjectMap<List<VillagerTrades.ITrade>> villagerTrades, Map<Item, ResourceLocation> commonMap, Map<Item, ResourceLocation> uniqueMap) {
        TradeUtils.EnchantedItemForEmeraldsTrade trade;
        ItemStack weaponStack;
        Item weapon;
        ResourceLocation resourceLocation;
        for (Item item : commonMap.keySet()) {
            resourceLocation = commonMap.get(item);
            weapon = (Item)ForgeRegistries.ITEMS.getValue(resourceLocation);
            weaponStack = new ItemStack((IItemProvider)weapon);
            trade = new TradeUtils.EnchantedItemForEmeraldsTrade(weapon, (Integer)DungeonsGearConfig.COMMON.COMMON_ITEM_VALUE.get(), 3, 15, 0.2f);
            ((List)villagerTrades.get(4)).add(trade);
        }
        for (Item item : uniqueMap.keySet()) {
            resourceLocation = uniqueMap.get(item);
            weapon = (Item)ForgeRegistries.ITEMS.getValue(resourceLocation);
            weaponStack = new ItemStack((IItemProvider)weapon);
            trade = new TradeUtils.EnchantedItemForEmeraldsTrade(weapon, (Integer)DungeonsGearConfig.COMMON.UNIQUE_ITEM_VALUE.get(), 3, 30, 0.2f);
            ((List)villagerTrades.get(5)).add(trade);
        }
    }

    private static void moveTradesToDifferentGroup(List<VillagerTrades.ITrade> oldTradesGroup, List<VillagerTrades.ITrade> newTradesGroup) {
        Iterator<VillagerTrades.ITrade> it = oldTradesGroup.iterator();
        while (it.hasNext()) {
            VillagerTrades.ITrade currentTrade = it.next();
            if (currentTrade == null) continue;
            newTradesGroup.add(currentTrade);
            it.remove();
        }
    }

    @SubscribeEvent
    public static void onLootTableLoad(LootTableLoadEvent event) {
        LootTable table;
        if (!((Boolean)DungeonsGearConfig.COMMON.ENABLE_DUNGEONS_GEAR_LOOT.get()).booleanValue()) {
            return;
        }
        String eventPath = event.getName().toString();
        ((List)DungeonsGearConfig.Common.SUPER_RARE_LOOT_TABLES.get()).forEach(path -> {
            if (eventPath.contains((CharSequence)path)) {
                if (!((List)DungeonsGearConfig.Common.SUPER_RARE_LOOT_TABLES_BLACKLIST.get()).contains(path)) {
                    LootTable table = event.getTable();
                    LootHandler.addLootTable(table, "SUPER RARE");
                }
            }
        });
        ((List)DungeonsGearConfig.Common.RARE_LOOT_TABLES.get()).forEach(path -> {
            if (eventPath.contains((CharSequence)path)) {
                if (!((List)DungeonsGearConfig.Common.RARE_LOOT_TABLES_BLACKLIST.get()).contains(path)) {
                    LootTable table = event.getTable();
                    LootHandler.addLootTable(table, "RARE");
                }
            }
        });
        ((List)DungeonsGearConfig.Common.UNCOMMON_LOOT_TABLES.get()).forEach(path -> {
            if (eventPath.contains((CharSequence)path)) {
                if (!((List)DungeonsGearConfig.Common.UNCOMMON_LOOT_TABLES_BLACKLIST.get()).contains(path)) {
                    LootTable table = event.getTable();
                    LootHandler.addLootTable(table, "UNCOMMON");
                }
            }
        });
        ((List)DungeonsGearConfig.Common.COMMON_LOOT_TABLES.get()).forEach(path -> {
            if (eventPath.contains((CharSequence)path)) {
                if (!((List)DungeonsGearConfig.Common.COMMON_LOOT_TABLES_BLACKLIST.get()).contains(path)) {
                    LootTable table = event.getTable();
                    LootHandler.addLootTable(table, "COMMON");
                }
            }
        });
        if (event.getName().toString().contains("minecraft:chests/village/village_weaponsmith")) {
            table = event.getTable();
            LootHandler.addCommonMeleeWeaponLootTable(table);
        }
        if (event.getName().toString().contains("minecraft:chests/village/village_fletcher")) {
            table = event.getTable();
            LootHandler.addCommonRangedWeaponLootTable(table);
        }
        if (event.getName().toString().contains("minecraft:chests/village/village_armorer")) {
            table = event.getTable();
            LootHandler.addCommonMetalArmorLootTable(table);
        }
        if (event.getName().toString().contains("minecraft:chests/village/village_leatherworker")) {
            table = event.getTable();
            LootHandler.addCommonLeatherArmorLootTable(table);
        }
        if (event.getName().toString().contains("minecraft:gameplay/hero_of_the_village/weaponsmith_gift")) {
            table = event.getTable();
            LootHandler.addCommonMeleeWeaponLootTable(table);
        }
        if (event.getName().toString().contains("minecraft:gameplay/hero_of_the_village/fletcher_gift")) {
            table = event.getTable();
            LootHandler.addCommonRangedWeaponLootTable(table);
        }
        if (event.getName().toString().contains("minecraft:gameplay/hero_of_the_village/armorer_gift")) {
            table = event.getTable();
            LootHandler.addCommonMetalArmorLootTable(table);
        }
        if (event.getName().toString().contains("minecraft:gameplay/hero_of_the_village/leatherworker_gift")) {
            table = event.getTable();
            LootHandler.addCommonLeatherArmorLootTable(table);
        }
    }

    private static void addCommonMeleeWeaponLootTable(LootTable table) {
        Collection<ResourceLocation> commonWeapons = WeaponList.commonWeaponMap.values();
        Collection<ResourceLocation> uniqueWeapons = WeaponList.uniqueWeaponMap.values();
        LootUtils.myAddItemsToTable(table, commonWeapons, 1.0f, ((Double)DungeonsGearConfig.COMMON.COMMON_WEAPON_COMMON_LOOT.get()).floatValue(), "common_weapons");
        LootUtils.myAddItemsToTable(table, uniqueWeapons, 1.0f, ((Double)DungeonsGearConfig.COMMON.UNIQUE_WEAPON_COMMON_LOOT.get()).floatValue(), "unique_weapons");
    }

    private static void addCommonRangedWeaponLootTable(LootTable table) {
        Collection<ResourceLocation> commonRangedWeapons = RangedWeaponList.commonRangedWeaponMap.values();
        Collection<ResourceLocation> uniqueRangedWeapons = RangedWeaponList.uniqueRangedWeaponMap.values();
        LootUtils.myAddItemsToTable(table, commonRangedWeapons, 1.0f, ((Double)DungeonsGearConfig.COMMON.COMMON_WEAPON_COMMON_LOOT.get()).floatValue(), "common_ranged_weapons");
        LootUtils.myAddItemsToTable(table, uniqueRangedWeapons, 1.0f, ((Double)DungeonsGearConfig.COMMON.UNIQUE_WEAPON_COMMON_LOOT.get()).floatValue(), "unique_ranged_weapons");
    }

    private static void addCommonMetalArmorLootTable(LootTable table) {
        Collection<ResourceLocation> commonWeapons = ArmorList.commonMetalArmorMap.values();
        Collection<ResourceLocation> uniqueWeapons = ArmorList.uniqueMetalArmorMap.values();
        LootUtils.myAddItemsToTable(table, commonWeapons, 1.0f, ((Double)DungeonsGearConfig.COMMON.COMMON_ARMOR_COMMON_LOOT.get()).floatValue(), "common_metal_armor");
        LootUtils.myAddItemsToTable(table, uniqueWeapons, 1.0f, ((Double)DungeonsGearConfig.COMMON.UNIQUE_ARMOR_COMMON_LOOT.get()).floatValue(), "unique_metal_armor");
    }

    private static void addCommonLeatherArmorLootTable(LootTable table) {
        Collection<ResourceLocation> commonRangedWeapons = ArmorList.commonLeatherArmorMap.values();
        Collection<ResourceLocation> uniqueRangedWeapons = ArmorList.uniqueLeatherArmorMap.values();
        LootUtils.myAddItemsToTable(table, commonRangedWeapons, 1.0f, ((Double)DungeonsGearConfig.COMMON.COMMON_ARMOR_COMMON_LOOT.get()).floatValue(), "common_leather_armor");
        LootUtils.myAddItemsToTable(table, uniqueRangedWeapons, 1.0f, ((Double)DungeonsGearConfig.COMMON.UNIQUE_ARMOR_COMMON_LOOT.get()).floatValue(), "unique_leather_armor");
    }

    private static void addLootTable(LootTable table, String rarity) {
        float artifactChance;
        float uniqueArmorChance;
        float commonArmorChance;
        float uniqueWeaponChance;
        float commonWeaponChance;
        Collection<ResourceLocation> commonWeaponCollectionCombined = LootHandler.getCommonWeaponCollection();
        Collection<ResourceLocation> uniqueWeaponCollectionCombined = LootHandler.getUniqueWeaponCollection();
        Collection<ResourceLocation> commonArmorCollectionCombined = LootHandler.getCommonArmorCollection();
        Collection<ResourceLocation> uniqueArmorCollectionCombined = LootHandler.getUniqueArmorCollection();
        Collection<ResourceLocation> artifacts = ArtifactList.artifactMap.values();
        switch (rarity.toUpperCase()) {
            case "COMMON": {
                commonWeaponChance = ((Double)DungeonsGearConfig.COMMON.COMMON_WEAPON_COMMON_LOOT.get()).floatValue();
                uniqueWeaponChance = ((Double)DungeonsGearConfig.COMMON.UNIQUE_WEAPON_COMMON_LOOT.get()).floatValue();
                commonArmorChance = ((Double)DungeonsGearConfig.COMMON.COMMON_ARMOR_COMMON_LOOT.get()).floatValue();
                uniqueArmorChance = ((Double)DungeonsGearConfig.COMMON.UNIQUE_ARMOR_COMMON_LOOT.get()).floatValue();
                artifactChance = ((Double)DungeonsGearConfig.COMMON.ARTIFACT_COMMON_LOOT.get()).floatValue();
                break;
            }
            case "UNCOMMON": {
                commonWeaponChance = ((Double)DungeonsGearConfig.COMMON.COMMON_WEAPON_UNCOMMON_LOOT.get()).floatValue();
                uniqueWeaponChance = ((Double)DungeonsGearConfig.COMMON.UNIQUE_WEAPON_UNCOMMON_LOOT.get()).floatValue();
                commonArmorChance = ((Double)DungeonsGearConfig.COMMON.COMMON_ARMOR_UNCOMMON_LOOT.get()).floatValue();
                uniqueArmorChance = ((Double)DungeonsGearConfig.COMMON.UNIQUE_ARMOR_UNCOMMON_LOOT.get()).floatValue();
                artifactChance = ((Double)DungeonsGearConfig.COMMON.ARTIFACT_UNCOMMON_LOOT.get()).floatValue();
                break;
            }
            case "RARE": {
                commonWeaponChance = ((Double)DungeonsGearConfig.COMMON.COMMON_WEAPON_RARE_LOOT.get()).floatValue();
                uniqueWeaponChance = ((Double)DungeonsGearConfig.COMMON.UNIQUE_WEAPON_RARE_LOOT.get()).floatValue();
                commonArmorChance = ((Double)DungeonsGearConfig.COMMON.COMMON_ARMOR_RARE_LOOT.get()).floatValue();
                uniqueArmorChance = ((Double)DungeonsGearConfig.COMMON.UNIQUE_ARMOR_RARE_LOOT.get()).floatValue();
                artifactChance = ((Double)DungeonsGearConfig.COMMON.ARTIFACT_RARE_LOOT.get()).floatValue();
                break;
            }
            case "SUPER RARE": {
                commonWeaponChance = ((Double)DungeonsGearConfig.COMMON.COMMON_WEAPON_SUPER_RARE_LOOT.get()).floatValue();
                uniqueWeaponChance = ((Double)DungeonsGearConfig.COMMON.UNIQUE_WEAPON_SUPER_RARE_LOOT.get()).floatValue();
                commonArmorChance = ((Double)DungeonsGearConfig.COMMON.COMMON_ARMOR_SUPER_RARE_LOOT.get()).floatValue();
                uniqueArmorChance = ((Double)DungeonsGearConfig.COMMON.UNIQUE_ARMOR_SUPER_RARE_LOOT.get()).floatValue();
                artifactChance = ((Double)DungeonsGearConfig.COMMON.ARTIFACT_SUPER_RARE_LOOT.get()).floatValue();
                break;
            }
            default: {
                commonWeaponChance = ((Double)DungeonsGearConfig.COMMON.COMMON_WEAPON_COMMON_LOOT.get()).floatValue();
                uniqueWeaponChance = ((Double)DungeonsGearConfig.COMMON.UNIQUE_WEAPON_COMMON_LOOT.get()).floatValue();
                commonArmorChance = ((Double)DungeonsGearConfig.COMMON.COMMON_ARMOR_COMMON_LOOT.get()).floatValue();
                uniqueArmorChance = ((Double)DungeonsGearConfig.COMMON.UNIQUE_ARMOR_COMMON_LOOT.get()).floatValue();
                artifactChance = ((Double)DungeonsGearConfig.COMMON.ARTIFACT_COMMON_LOOT.get()).floatValue();
            }
        }
        LootUtils.myAddItemsToTable(table, commonWeaponCollectionCombined, 1.0f, commonWeaponChance, "common_weapons");
        LootUtils.myAddItemsToTable(table, uniqueWeaponCollectionCombined, 1.0f, uniqueWeaponChance, "unique_weapons");
        LootUtils.myAddItemsToTable(table, commonArmorCollectionCombined, 1.0f, commonArmorChance, "common_armor");
        LootUtils.myAddItemsToTable(table, uniqueArmorCollectionCombined, 1.0f, uniqueArmorChance, "unique_armor");
        LootUtils.myAddItemsToTable(table, artifacts, 1.0f, artifactChance, "artifacts");
    }

    private static Collection<ResourceLocation> getUniqueArmorCollection() {
        Collection<ResourceLocation> uniqueLeatherArmor = ArmorList.uniqueLeatherArmorMap.values();
        Collection<ResourceLocation> uniqueMetalArmor = ArmorList.uniqueMetalArmorMap.values();
        Iterable combinedUniqueArmor = Iterables.unmodifiableIterable((Iterable)Iterables.concat(uniqueMetalArmor, uniqueLeatherArmor));
        return Lists.newArrayList((Iterable)combinedUniqueArmor);
    }

    private static Collection<ResourceLocation> getCommonArmorCollection() {
        Collection<ResourceLocation> commonLeatherArmor = ArmorList.commonLeatherArmorMap.values();
        Collection<ResourceLocation> commonMetalArmor = ArmorList.commonMetalArmorMap.values();
        Iterable combinedCommonArmor = Iterables.unmodifiableIterable((Iterable)Iterables.concat(commonMetalArmor, commonLeatherArmor));
        return Lists.newArrayList((Iterable)combinedCommonArmor);
    }

    private static Collection<ResourceLocation> getUniqueWeaponCollection() {
        Collection<ResourceLocation> uniqueWeapons = WeaponList.uniqueWeaponMap.values();
        Collection<ResourceLocation> uniqueRangedWeapons = RangedWeaponList.uniqueRangedWeaponMap.values();
        Iterable combinedUniqueWeapons = Iterables.unmodifiableIterable((Iterable)Iterables.concat(uniqueWeapons, uniqueRangedWeapons));
        return Lists.newArrayList((Iterable)combinedUniqueWeapons);
    }

    private static Collection<ResourceLocation> getCommonWeaponCollection() {
        Collection<ResourceLocation> commonWeapons = WeaponList.commonWeaponMap.values();
        Collection<ResourceLocation> commonRangedWeapons = RangedWeaponList.commonRangedWeaponMap.values();
        Iterable combinedCommonWeapons = Iterables.unmodifiableIterable((Iterable)Iterables.concat(commonWeapons, commonRangedWeapons));
        return Lists.newArrayList((Iterable)combinedCommonWeapons);
    }

    @SubscribeEvent
    public static void onSalvageItem(PlayerInteractEvent.EntityInteract event) {
        ItemStack interactStack;
        if (!((Boolean)DungeonsGearConfig.COMMON.ENABLE_SALVAGING.get()).booleanValue()) {
            return;
        }
        Entity entity = event.getTarget();
        PlayerEntity playerEntity = event.getPlayer();
        if (entity instanceof VillagerEntity) {
            VillagerEntity villagerEntity = (VillagerEntity)entity;
            if (villagerEntity.func_213700_eh().func_221130_b() == VillagerProfession.field_221165_o && playerEntity.func_225608_bj_()) {
                interactStack = playerEntity.func_184586_b(event.getHand());
                if (WeaponList.commonWeaponMap.containsKey(interactStack.func_77973_b())) {
                    LootHandler.handleSalvageTrade(playerEntity, (AbstractVillagerEntity)villagerEntity, interactStack, "COMMON");
                } else if (WeaponList.uniqueWeaponMap.containsKey(interactStack.func_77973_b())) {
                    LootHandler.handleSalvageTrade(playerEntity, (AbstractVillagerEntity)villagerEntity, interactStack, "UNIQUE");
                }
            }
            if (villagerEntity.func_213700_eh().func_221130_b() == VillagerProfession.field_221158_h && playerEntity.func_225608_bj_()) {
                interactStack = playerEntity.func_184586_b(event.getHand());
                if (RangedWeaponList.commonRangedWeaponMap.containsKey(interactStack.func_77973_b())) {
                    LootHandler.handleSalvageTrade(playerEntity, (AbstractVillagerEntity)villagerEntity, interactStack, "COMMON");
                } else if (RangedWeaponList.uniqueRangedWeaponMap.containsKey(interactStack.func_77973_b())) {
                    LootHandler.handleSalvageTrade(playerEntity, (AbstractVillagerEntity)villagerEntity, interactStack, "UNIQUE");
                }
            }
            if (villagerEntity.func_213700_eh().func_221130_b() == VillagerProfession.field_221152_b && playerEntity.func_225608_bj_()) {
                interactStack = playerEntity.func_184586_b(event.getHand());
                if (ArmorList.commonMetalArmorMap.containsKey(interactStack.func_77973_b())) {
                    LootHandler.handleSalvageTrade(playerEntity, (AbstractVillagerEntity)villagerEntity, interactStack, "COMMON");
                } else if (ArmorList.uniqueMetalArmorMap.containsKey(interactStack.func_77973_b())) {
                    LootHandler.handleSalvageTrade(playerEntity, (AbstractVillagerEntity)villagerEntity, interactStack, "UNIQUE");
                }
            }
            if (villagerEntity.func_213700_eh().func_221130_b() == VillagerProfession.field_221159_i && playerEntity.func_225608_bj_()) {
                interactStack = playerEntity.func_184586_b(event.getHand());
                if (ArmorList.commonLeatherArmorMap.containsKey(interactStack.func_77973_b())) {
                    LootHandler.handleSalvageTrade(playerEntity, (AbstractVillagerEntity)villagerEntity, interactStack, "COMMON");
                } else if (ArmorList.uniqueLeatherArmorMap.containsKey(interactStack.func_77973_b())) {
                    LootHandler.handleSalvageTrade(playerEntity, (AbstractVillagerEntity)villagerEntity, interactStack, "UNIQUE");
                }
            }
        }
        if (entity instanceof WanderingTraderEntity) {
            WanderingTraderEntity wanderingTraderEntity = (WanderingTraderEntity)entity;
            if (playerEntity.func_225608_bj_() && ArtifactList.artifactMap.containsKey((interactStack = playerEntity.func_184586_b(event.getHand())).func_77973_b())) {
                LootHandler.handleSalvageTrade(playerEntity, (AbstractVillagerEntity)wanderingTraderEntity, interactStack, "ARTIFACT");
            }
        }
    }

    private static void handleSalvageTrade(PlayerEntity playerEntity, AbstractVillagerEntity abstractVillagerEntity, ItemStack interactStack, String itemType) {
        int itemValue;
        float maxDamage = interactStack.func_77958_k();
        DungeonsGear.LOGGER.info("Max damage: " + maxDamage);
        float currentDamage = maxDamage - (float)interactStack.func_77952_i();
        DungeonsGear.LOGGER.info("Current damage: " + currentDamage);
        switch (itemType.toUpperCase()) {
            case "COMMON": {
                itemValue = (Integer)DungeonsGearConfig.COMMON.COMMON_ITEM_VALUE.get();
                break;
            }
            case "UNIQUE": {
                itemValue = (Integer)DungeonsGearConfig.COMMON.UNIQUE_ITEM_VALUE.get();
                break;
            }
            case "ARTIFACT": {
                itemValue = (Integer)DungeonsGearConfig.COMMON.ARTIFACT_VALUE.get();
                break;
            }
            default: {
                itemValue = (Integer)DungeonsGearConfig.COMMON.COMMON_ITEM_VALUE.get();
            }
        }
        int emeraldReward = Math.round((float)itemValue * 0.375f);
        float durabilityModifier = currentDamage / maxDamage;
        emeraldReward = Math.round((float)emeraldReward * durabilityModifier);
        if (emeraldReward > 0) {
            interactStack.func_190918_g(1);
            if (abstractVillagerEntity instanceof VillagerEntity) {
                VillagerEntity villagerEntity = (VillagerEntity)abstractVillagerEntity;
                villagerEntity.field_70170_p.func_184148_a((PlayerEntity)null, abstractVillagerEntity.func_226277_ct_(), abstractVillagerEntity.func_226278_cu_(), abstractVillagerEntity.func_226281_cx_(), SoundEvents.field_187915_go, SoundCategory.PLAYERS, 64.0f, 1.0f);
                villagerEntity.func_213739_a(IReputationType.field_221033_e, (Entity)playerEntity);
            } else if (abstractVillagerEntity instanceof WanderingTraderEntity) {
                WanderingTraderEntity wanderingTraderEntity = (WanderingTraderEntity)abstractVillagerEntity;
                wanderingTraderEntity.field_70170_p.func_184148_a((PlayerEntity)null, wanderingTraderEntity.func_226277_ct_(), wanderingTraderEntity.func_226278_cu_(), wanderingTraderEntity.func_226281_cx_(), SoundEvents.field_219724_nc, SoundCategory.PLAYERS, 64.0f, 1.0f);
            }
            ItemStack emeraldStack = new ItemStack((IItemProvider)Items.field_151166_bC, emeraldReward);
            if (!playerEntity.func_191521_c(emeraldStack)) {
                World world = playerEntity.func_130014_f_();
                ItemEntity emeraldStackEntity = new ItemEntity(world, playerEntity.func_226277_ct_(), playerEntity.func_226278_cu_(), playerEntity.func_226281_cx_(), emeraldStack);
                world.func_217376_c((Entity)emeraldStackEntity);
            }
            playerEntity.func_195068_e(emeraldReward);
        }
    }
}

