/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_gear.loot;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.item.Item;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.ConstantRange;
import net.minecraft.world.storage.loot.IRandomRange;
import net.minecraft.world.storage.loot.ItemLootEntry;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootFunction;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.StandaloneLootEntry;
import net.minecraft.world.storage.loot.conditions.ILootCondition;
import net.minecraft.world.storage.loot.conditions.RandomChance;
import net.minecraft.world.storage.loot.functions.ILootFunction;
import net.minecraft.world.storage.loot.functions.SetCount;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class LootUtils {
    private static Field tablePools = ObfuscationReflectionHelper.findField(LootTable.class, (String)"field_186466_c");
    private static Field poolEntries;
    private static Field entryItem;

    public static boolean removeLootFromTable(LootTable table, Item toRemove) {
        try {
            List pools = (List)tablePools.get(table);
            for (LootPool pool : pools) {
                List entries = (List)poolEntries.get(pool);
                Iterator iterator = entries.iterator();
                while (iterator.hasNext()) {
                    ItemLootEntry itemLootEntry;
                    Item item;
                    LootEntry entry = (LootEntry)iterator.next();
                    if (!(entry instanceof ItemLootEntry) || (item = (Item)entryItem.get(itemLootEntry = (ItemLootEntry)entry)) != toRemove) continue;
                    iterator.remove();
                    return true;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return false;
    }

    public static LootPool createLootPool(String name, RandomValueRange numRolls, RandomValueRange bonusRolls, LootEntry.Builder entryBuilder, ILootCondition.IBuilder conditionBuilder, ILootFunction.IBuilder functionBuilder) {
        LootPool.Builder builder = LootPool.func_216096_a();
        builder.name(name);
        builder.func_216046_a((IRandomRange)numRolls);
        builder.bonusRolls(bonusRolls.func_186509_a(), bonusRolls.func_186512_b());
        builder.func_216045_a(entryBuilder);
        builder.func_212840_b_(conditionBuilder);
        builder.func_212841_b_(functionBuilder);
        return builder.func_216044_b();
    }

    public static LootPool myCreateLootPool(String name, RandomValueRange numRolls, RandomValueRange bonusRolls, Set<StandaloneLootEntry.Builder> entryBuilderSet, ILootCondition.IBuilder conditionBuilder, ILootFunction.IBuilder functionBuilder) {
        LootPool.Builder builder = LootPool.func_216096_a();
        builder.name(name);
        builder.func_216046_a((IRandomRange)numRolls);
        builder.bonusRolls(bonusRolls.func_186509_a(), bonusRolls.func_186512_b());
        for (LootEntry.Builder builder2 : entryBuilderSet) {
            builder.func_216045_a(builder2);
        }
        builder.func_212840_b_(conditionBuilder);
        builder.func_212841_b_(functionBuilder);
        return builder.func_216044_b();
    }

    public static void addItemToTable(LootTable table, LootPool pool) {
        table.addPool(pool);
    }

    public static void addItemToTable(LootTable table, Item item, int weight, float probability, int minQuantity, int maxQuantity, String name) {
        LootUtils.addItemToTable(table, item, weight, 1.0f, probability, minQuantity, maxQuantity, name);
    }

    public static void addItemToTable(LootTable table, Item item, int weight, float probability, int quantity, String name) {
        LootUtils.addItemToTable(table, item, weight, 1.0f, probability, quantity, quantity, name);
    }

    public static void addItemToTable(LootTable table, Item item, int weight, float numRolls, float probability, int minQuantity, int maxQuantity, String name) {
        ILootCondition.IBuilder conditionBuilder = RandomChance.func_216004_a((float)probability);
        LootFunction.Builder functionBuilder = SetCount.func_215932_a((IRandomRange)new RandomValueRange((float)minQuantity, (float)maxQuantity));
        StandaloneLootEntry.Builder entryBuilder = ItemLootEntry.func_216168_a((IItemProvider)item);
        entryBuilder.func_216086_a(weight);
        entryBuilder.func_216085_b(1);
        entryBuilder.func_212840_b_(conditionBuilder);
        entryBuilder.func_212841_b_((ILootFunction.IBuilder)functionBuilder);
        LootPool newPool = LootUtils.createLootPool(name, new RandomValueRange(numRolls), new RandomValueRange(0.0f), (LootEntry.Builder)entryBuilder, conditionBuilder, (ILootFunction.IBuilder)functionBuilder);
        LootUtils.addItemToTable(table, newPool);
    }

    public static void myAddItemsToTable(LootTable table, Collection<ResourceLocation> resourceLocationCollection, float numRolls, float probability, String name) {
        ILootCondition.IBuilder conditionBuilder = RandomChance.func_216004_a((float)probability);
        LootFunction.Builder functionBuilder = SetCount.func_215932_a((IRandomRange)new ConstantRange(1));
        HashSet<StandaloneLootEntry.Builder> entryBuilderSet = new HashSet<StandaloneLootEntry.Builder>();
        for (ResourceLocation resourceLocation : resourceLocationCollection) {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(resourceLocation);
            StandaloneLootEntry.Builder entryBuilder = ItemLootEntry.func_216168_a((IItemProvider)item);
            entryBuilder.func_216085_b(1);
            entryBuilder.func_212840_b_(conditionBuilder);
            entryBuilder.func_212841_b_((ILootFunction.IBuilder)functionBuilder);
            entryBuilderSet.add(entryBuilder);
        }
        LootPool newPool = LootUtils.myCreateLootPool(name, new RandomValueRange(numRolls), new RandomValueRange(0.0f), entryBuilderSet, conditionBuilder, (ILootFunction.IBuilder)functionBuilder);
        LootUtils.addItemToTable(table, newPool);
    }

    static {
        tablePools.setAccessible(true);
        poolEntries = ObfuscationReflectionHelper.findField(LootPool.class, (String)"field_186453_a");
        poolEntries.setAccessible(true);
        entryItem = ObfuscationReflectionHelper.findField(ItemLootEntry.class, (String)"field_186368_a");
        entryItem.setAccessible(true);
    }
}

