/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_gear.melee;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.infamous.dungeons_gear.combat.CombatEventHandler;
import com.infamous.dungeons_gear.interfaces.IMeleeWeapon;
import com.infamous.dungeons_gear.interfaces.IOffhandAttack;
import com.infamous.dungeons_gear.interfaces.ISoulGatherer;
import com.infamous.dungeons_gear.items.WeaponList;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.item.SwordItem;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class DaggerItem
extends SwordItem
implements IOffhandAttack,
IMeleeWeapon,
ISoulGatherer {
    private final Multimap<String, AttributeModifier> field_234674_d_;
    private final float attackSpeed;

    public DaggerItem(IItemTier tier, int attackDamageIn, float attackSpeedIn, Item.Properties builder) {
        super(tier, attackDamageIn, attackSpeedIn, builder);
        this.attackSpeed = attackSpeedIn;
        ImmutableMultimap.Builder builder1 = ImmutableMultimap.builder();
        builder1.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Tool modifier", (double)this.func_200894_d(), AttributeModifier.Operation.ADDITION));
        builder1.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Tool modifier", (double)this.attackSpeed, AttributeModifier.Operation.ADDITION));
        this.field_234674_d_ = builder1.build();
    }

    public Multimap<String, AttributeModifier> func_111205_h(EquipmentSlotType equipmentSlot) {
        return equipmentSlot == EquipmentSlotType.MAINHAND || equipmentSlot == EquipmentSlotType.OFFHAND ? this.field_234674_d_ : super.func_111205_h(equipmentSlot);
    }

    public Rarity func_77613_e(ItemStack itemStack) {
        if (itemStack.func_77973_b() == WeaponList.FANG_OF_FROST) {
            return Rarity.RARE;
        }
        return Rarity.UNCOMMON;
    }

    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> list, ITooltipFlag flag) {
        super.func_77624_a(stack, world, list, flag);
        if (stack.func_77973_b() == WeaponList.FANG_OF_FROST) {
            list.add((ITextComponent)new StringTextComponent(TextFormatting.WHITE + "" + TextFormatting.ITALIC + "This lauded dagger of the northern mountains is known to freeze its foes to solid ice."));
            list.add((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Slows Mobs (Freezing I)"));
        }
        if (stack.func_77973_b() == WeaponList.MOON_DAGGER) {
            list.add((ITextComponent)new StringTextComponent(TextFormatting.WHITE + "" + TextFormatting.ITALIC + "This curved blade shines like the crescent moon on a dark night."));
            list.add((ITextComponent)new StringTextComponent(TextFormatting.LIGHT_PURPLE + "Souls Critical Boost (Enigma Resonator I)"));
        }
        if (stack.func_77973_b() == WeaponList.DAGGER) {
            list.add((ITextComponent)new StringTextComponent(TextFormatting.WHITE + "" + TextFormatting.ITALIC + "Daggers are the weapon of cravens - or so folks say."));
        }
        list.add((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Dual Wield"));
    }

    @Override
    public float getOffhandAttackReach() {
        return 3.0f;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        if (handIn == Hand.OFF_HAND) {
            CombatEventHandler.checkForOffhandAttack();
            ItemStack offhand = playerIn.func_184586_b(handIn);
            return new ActionResult(ActionResultType.SUCCESS, (Object)offhand);
        }
        return new ActionResult(ActionResultType.PASS, (Object)playerIn.func_184586_b(handIn));
    }

    @Override
    public int getGatherAmount(ItemStack stack) {
        if (stack.func_77973_b() == WeaponList.MOON_DAGGER) {
            return 1;
        }
        return 0;
    }
}

