/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_gear.melee;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.infamous.dungeons_gear.combat.CombatEventHandler;
import com.infamous.dungeons_gear.interfaces.IMeleeWeapon;
import com.infamous.dungeons_gear.interfaces.IOffhandAttack;
import com.infamous.dungeons_gear.items.WeaponList;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.HoeItem;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.Rarity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class SickleItem
extends HoeItem
implements IOffhandAttack,
IMeleeWeapon {
    private final Multimap<String, AttributeModifier> field_234674_d_;
    private final float attackDamage;
    protected final float attackSpeed;

    public SickleItem(IItemTier tier, int attackDamageIn, float attackSpeedIn, Item.Properties builder) {
        super(tier, attackSpeedIn, builder);
        this.attackDamage = (float)attackDamageIn + tier.func_200929_c();
        this.attackSpeed = attackSpeedIn;
        ImmutableMultimap.Builder builder1 = ImmutableMultimap.builder();
        builder1.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Tool modifier", (double)this.attackDamage, AttributeModifier.Operation.ADDITION));
        builder1.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Tool modifier", (double)this.attackSpeed, AttributeModifier.Operation.ADDITION));
        this.field_234674_d_ = builder1.build();
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.func_222118_a(1, attacker, p_220039_0_ -> p_220039_0_.func_213361_c(EquipmentSlotType.MAINHAND));
        return true;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment.field_77351_y.func_77557_a(Items.field_151040_l) && enchantment != Enchantments.field_191530_r;
    }

    public Multimap<String, AttributeModifier> func_111205_h(EquipmentSlotType equipmentSlot) {
        return equipmentSlot == EquipmentSlotType.MAINHAND || equipmentSlot == EquipmentSlotType.OFFHAND ? this.field_234674_d_ : super.func_111205_h(equipmentSlot);
    }

    public Rarity func_77613_e(ItemStack itemStack) {
        if (itemStack.func_77973_b() == WeaponList.NIGHTMARES_BITE || itemStack.func_77973_b() == WeaponList.THE_LAST_LAUGH) {
            return Rarity.RARE;
        }
        return Rarity.UNCOMMON;
    }

    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> list, ITooltipFlag flag) {
        super.func_77624_a(stack, world, list, flag);
        if (stack.func_77973_b() == WeaponList.NIGHTMARES_BITE) {
            list.add((ITextComponent)new StringTextComponent(TextFormatting.WHITE + "" + TextFormatting.ITALIC + "The blade of Nightmare's Bite drips with deadly venom, still potent after all these years."));
            list.add((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Spawns Poison Clouds (Poison Cloud I)"));
        }
        if (stack.func_77973_b() == WeaponList.THE_LAST_LAUGH) {
            list.add((ITextComponent)new StringTextComponent(TextFormatting.WHITE + "" + TextFormatting.ITALIC + "Strange, distorted laughter seems to whisper from this menacing looking sickle."));
            list.add((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Mobs Drop More Valuables (Prospector I)"));
        }
        if (stack.func_77973_b() == WeaponList.SICKLE) {
            list.add((ITextComponent)new StringTextComponent(TextFormatting.WHITE + "" + TextFormatting.ITALIC + "A ceremonial weapon that hails from the same region as the Desert Temple."));
        }
        list.add((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Dual Wield"));
    }

    @Override
    public float getOffhandAttackReach() {
        return 3.0f;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        if (handIn == Hand.OFF_HAND) {
            CombatEventHandler.checkForOffhandAttack();
            ItemStack offhand = playerIn.func_184586_b(handIn);
            return new ActionResult(ActionResultType.SUCCESS, (Object)offhand);
        }
        return new ActionResult(ActionResultType.PASS, (Object)playerIn.func_184586_b(handIn));
    }
}

