/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_gear.melee;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.infamous.dungeons_gear.interfaces.IExtendedAttackReach;
import com.infamous.dungeons_gear.interfaces.IMeleeWeapon;
import com.infamous.dungeons_gear.items.WeaponList;
import com.infamous.dungeons_gear.utilties.BlockUtils;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.Rarity;
import net.minecraft.item.TieredItem;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class SpearItem
extends TieredItem
implements IExtendedAttackReach,
IMeleeWeapon {
    private final float attackDamage;
    private final Multimap<String, AttributeModifier> attributeModifierMultimap;

    public SpearItem(IItemTier tier, int attackDamageIn, float attackSpeedIn, Item.Properties properties) {
        super(tier, properties);
        this.attackDamage = (float)attackDamageIn + tier.func_200929_c();
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.attackDamage, AttributeModifier.Operation.ADDITION));
        builder.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", (double)attackSpeedIn, AttributeModifier.Operation.ADDITION));
        this.attributeModifierMultimap = builder.build();
    }

    public float getAttackDamage() {
        return this.attackDamage;
    }

    public boolean func_195938_a(BlockState blockState, World world, BlockPos blockPos, PlayerEntity playerEntity) {
        return !playerEntity.func_184812_l_();
    }

    public float func_150893_a(ItemStack p_150893_1_, BlockState blockState) {
        if (BlockUtils.isIn(blockState, Blocks.field_196553_aF)) {
            return 15.0f;
        }
        Material lvt_3_1_ = blockState.func_185904_a();
        return lvt_3_1_ != Material.field_151585_k && lvt_3_1_ != Material.field_151582_l && lvt_3_1_ != Material.field_151589_v && !blockState.func_203425_a(BlockTags.field_206952_E) && lvt_3_1_ != Material.field_151572_C ? 1.0f : 1.5f;
    }

    public boolean func_77644_a(ItemStack p_77644_1_, LivingEntity p_77644_2_, LivingEntity p_77644_3_) {
        p_77644_1_.func_222118_a(1, p_77644_3_, p_220045_0_ -> p_220045_0_.func_213361_c(EquipmentSlotType.MAINHAND));
        return true;
    }

    public boolean func_179218_a(ItemStack p_179218_1_, World p_179218_2_, BlockState p_179218_3_, BlockPos p_179218_4_, LivingEntity p_179218_5_) {
        if (p_179218_3_.func_185887_b((IBlockReader)p_179218_2_, p_179218_4_) != 0.0f) {
            p_179218_1_.func_222118_a(2, p_179218_5_, p_220044_0_ -> p_220044_0_.func_213361_c(EquipmentSlotType.MAINHAND));
        }
        return true;
    }

    public boolean func_150897_b(BlockState state) {
        return BlockUtils.isIn(state, Blocks.field_196553_aF);
    }

    public Multimap<String, AttributeModifier> func_111205_h(EquipmentSlotType p_111205_1_) {
        return p_111205_1_ == EquipmentSlotType.MAINHAND ? this.attributeModifierMultimap : super.func_111205_h(p_111205_1_);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment.field_77351_y.func_77557_a(Items.field_151040_l) && enchantment != Enchantments.field_191530_r;
    }

    public Rarity func_77613_e(ItemStack itemStack) {
        if (itemStack.func_77973_b() == WeaponList.FORTUNE_SPEAR || itemStack.func_77973_b() == WeaponList.WHISPERING_SPEAR) {
            return Rarity.RARE;
        }
        return Rarity.UNCOMMON;
    }

    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> list, ITooltipFlag flag) {
        super.func_77624_a(stack, world, list, flag);
        if (stack.func_77973_b() == WeaponList.FORTUNE_SPEAR) {
            list.add((ITextComponent)new StringTextComponent(TextFormatting.WHITE + "" + TextFormatting.ITALIC + "A spear that is watched over by lucky souls, bringing luck to any who wield it."));
            list.add((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Mobs Drop More Loot (Fortune I)"));
        }
        if (stack.func_77973_b() == WeaponList.WHISPERING_SPEAR) {
            list.add((ITextComponent)new StringTextComponent(TextFormatting.WHITE + "" + TextFormatting.ITALIC + "Legend says that this cursed spear is plagued by a soul that controls the mind of any who wield it."));
            list.add((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Sometimes Strikes Twice (Echo I)"));
        }
        if (stack.func_77973_b() == WeaponList.SPEAR) {
            list.add((ITextComponent)new StringTextComponent(TextFormatting.WHITE + "" + TextFormatting.ITALIC + "The spear, with its long reach and powerful range, is a solid choice of weapon."));
        }
        list.add((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Long Melee Reach"));
    }

    @Override
    public float getAttackReach() {
        return 5.0f;
    }
}

