/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_gear.ranged.bows;

import com.infamous.dungeons_gear.DungeonsGear;
import com.infamous.dungeons_gear.capabilities.weapon.IWeapon;
import com.infamous.dungeons_gear.capabilities.weapon.WeaponProvider;
import com.infamous.dungeons_gear.enchantments.lists.RangedEnchantmentList;
import com.infamous.dungeons_gear.items.RangedWeaponList;
import com.infamous.dungeons_gear.ranged.bows.AbstractDungeonsBowItem;
import com.infamous.dungeons_gear.utilties.AbilityUtils;
import com.infamous.dungeons_gear.utilties.RangedUtils;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.BowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="dungeons_gear")
public class BowEvents {
    @SubscribeEvent
    public static void onAccelerateBowFired(ArrowLooseEvent event) {
        LivingEntity livingEntity = event.getEntityLiving();
        World world = livingEntity.func_130014_f_();
        long worldTime = world.func_82737_E();
        int charge = event.getCharge();
        ItemStack stack = event.getBow();
        if (stack.func_77973_b() instanceof BowItem) {
            IWeapon weaponCap = (IWeapon)stack.getCapability(WeaponProvider.WEAPON_CAPABILITY).orElseThrow(IllegalStateException::new);
            long lastFiredTime = weaponCap.getLastFiredTime();
            float bowChargeTime = weaponCap.getBowChargeTime();
            int accelerateLevel = EnchantmentHelper.func_77506_a((Enchantment)RangedEnchantmentList.ACCELERATE, (ItemStack)stack);
            if (stack.func_77973_b() == RangedWeaponList.MECHANICAL_SHORTBOW) {
                ++accelerateLevel;
            }
            float defaultChargeTime = 20.0f;
            float arrowVelocity = RangedUtils.getVanillaArrowVelocity(stack, charge);
            if (stack.func_77973_b() instanceof AbstractDungeonsBowItem) {
                defaultChargeTime = ((AbstractDungeonsBowItem)stack.func_77973_b()).getDefaultChargeTime();
                arrowVelocity = ((AbstractDungeonsBowItem)stack.func_77973_b()).getBowArrowVelocity(stack, charge);
            }
            if (accelerateLevel > 0) {
                if ((float)lastFiredTime < (float)worldTime - (Math.max(bowChargeTime, 0.0f) + 20.0f) && bowChargeTime < defaultChargeTime || arrowVelocity < 1.0f) {
                    weaponCap.setBowChargeTime(defaultChargeTime);
                } else if (arrowVelocity == 1.0f) {
                    float fireRateReduction = (int)((double)defaultChargeTime * (0.04 + 0.04 * (double)accelerateLevel));
                    weaponCap.setBowChargeTime(bowChargeTime - fireRateReduction);
                }
                weaponCap.setLastFiredTime(worldTime);
            }
        }
    }

    @SubscribeEvent
    public static void onSpecialArrowImpact(ProjectileImpactEvent.Arrow event) {
        AbstractArrowEntity arrowEntity;
        RayTraceResult rayTraceResult = event.getRayTraceResult();
        if (rayTraceResult instanceof EntityRayTraceResult && ((EntityRayTraceResult)rayTraceResult).func_216348_a() instanceof LivingEntity && (arrowEntity = event.getArrow()).func_212360_k() instanceof LivingEntity) {
            boolean trickbowFlag;
            LivingEntity shooter = (LivingEntity)arrowEntity.func_212360_k();
            LivingEntity victim = (LivingEntity)((EntityRayTraceResult)rayTraceResult).func_216348_a();
            boolean huntingBowFlag = arrowEntity.func_184216_O().contains("HuntingBow") || arrowEntity.func_184216_O().contains("HuntersPromise") || arrowEntity.func_184216_O().contains("MastersBow");
            boolean snowBowFlag = arrowEntity.func_184216_O().contains("SnowBow") || arrowEntity.func_184216_O().contains("WintersTouch");
            boolean bl = trickbowFlag = arrowEntity.func_184216_O().contains("Trickbow") || arrowEntity.func_184216_O().contains("TheGreenMenace") || arrowEntity.func_184216_O().contains("ThePinkScoundrel");
            if (huntingBowFlag) {
                AbilityUtils.makePetsAttackTarget(victim, shooter);
            } else if (snowBowFlag) {
                EffectInstance freezing = new EffectInstance(Effects.field_76421_d, 60, 0);
                victim.func_195064_c(freezing);
                DungeonsGear.PROXY.spawnParticles((Entity)victim, ParticleTypes.field_197593_D);
            } else if (trickbowFlag) {
                AbilityUtils.ricochetArrowTowardsOtherEntity(shooter, victim, arrowEntity, 10);
            }
        }
    }
}

