/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_gear.ranged.crossbows;

import com.google.common.collect.Lists;
import com.infamous.dungeons_gear.capabilities.weapon.IWeapon;
import com.infamous.dungeons_gear.capabilities.weapon.WeaponProvider;
import com.infamous.dungeons_gear.enchantments.lists.RangedEnchantmentList;
import com.infamous.dungeons_gear.interfaces.IRangedWeapon;
import com.infamous.dungeons_gear.utilties.RangedUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ICrossbowUser;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.FireworkRocketEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public abstract class AbstractDungeonsCrossbowItem
extends CrossbowItem
implements IRangedWeapon {
    private int defaultChargeTime;
    private boolean isUnique;
    public boolean field_220034_c = false;
    public boolean field_220035_d = false;

    public AbstractDungeonsCrossbowItem(Item.Properties builder, int defaultChargeTimeIn, boolean isUniqueIn) {
        super(builder);
        this.defaultChargeTime = defaultChargeTimeIn;
        this.isUnique = isUniqueIn;
    }

    public int getDefaultChargeTime() {
        return this.defaultChargeTime;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        if (AbstractDungeonsCrossbowItem.func_220012_d((ItemStack)itemstack)) {
            this.fireCrossbowProjectiles(worldIn, (LivingEntity)playerIn, handIn, itemstack, this.getProjectileVelocity(itemstack), 1.0f);
            CrossbowItem.func_220011_a((ItemStack)itemstack, (boolean)false);
            return ActionResult.func_226249_b_((Object)itemstack);
        }
        if (!playerIn.func_213356_f(itemstack).func_190926_b()) {
            if (!AbstractDungeonsCrossbowItem.func_220012_d((ItemStack)itemstack)) {
                this.field_220034_c = false;
                this.field_220035_d = false;
                playerIn.func_184598_c(handIn);
            }
            return ActionResult.func_226249_b_((Object)itemstack);
        }
        return ActionResult.func_226251_d_((Object)itemstack);
    }

    public void func_219972_a(World world, LivingEntity livingEntity, ItemStack stack, int timeLeft) {
        if (!world.field_72995_K) {
            int quickChargeLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_222193_H, (ItemStack)stack);
            SoundEvent quickChargeSoundEvent = this.getCrossbowSoundEvent(quickChargeLevel);
            SoundEvent loadingMiddleSoundEvent = quickChargeLevel == 0 ? SoundEvents.field_219611_bC : null;
            float chargeTime = (float)(stack.func_77988_m() - timeLeft) / (float)this.getCrossbowChargeTime(stack);
            if (chargeTime < 0.2f) {
                this.field_220034_c = false;
                this.field_220035_d = false;
            }
            if (chargeTime >= 0.2f && !this.field_220034_c && chargeTime < 1.0f) {
                this.field_220034_c = true;
                world.func_184148_a((PlayerEntity)null, livingEntity.func_226277_ct_(), livingEntity.func_226278_cu_(), livingEntity.func_226281_cx_(), quickChargeSoundEvent, SoundCategory.PLAYERS, 0.5f, 1.0f);
            }
            if (chargeTime >= 0.5f && loadingMiddleSoundEvent != null && !this.field_220035_d && chargeTime < 1.0f) {
                this.field_220035_d = true;
                world.func_184148_a((PlayerEntity)null, livingEntity.func_226277_ct_(), livingEntity.func_226278_cu_(), livingEntity.func_226281_cx_(), loadingMiddleSoundEvent, SoundCategory.PLAYERS, 0.5f, 1.0f);
            }
        }
    }

    public void func_77615_a(ItemStack stack, World worldIn, LivingEntity entityLiving, int timeLeft) {
        int i = this.func_77626_a(stack) - timeLeft;
        float f = this.getCrossbowCharge(i, stack);
        if (f >= 1.0f && !AbstractDungeonsCrossbowItem.func_220012_d((ItemStack)stack) && this.func_220021_a(entityLiving, stack)) {
            AbstractDungeonsCrossbowItem.func_220011_a((ItemStack)stack, (boolean)true);
            SoundCategory soundcategory = entityLiving instanceof PlayerEntity ? SoundCategory.PLAYERS : SoundCategory.HOSTILE;
            worldIn.func_184148_a((PlayerEntity)null, entityLiving.func_226277_ct_(), entityLiving.func_226278_cu_(), entityLiving.func_226281_cx_(), SoundEvents.field_219610_bB, soundcategory, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.5f + 1.0f) + 0.2f);
        }
    }

    public float getCrossbowCharge(int useTime, ItemStack stack) {
        float f = (float)useTime / (float)this.getCrossbowChargeTime(stack);
        if (f > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public int getCrossbowChargeTime(ItemStack stack) {
        int quickChargeLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_222193_H, (ItemStack)stack);
        if (this.hasQuickChargeBuiltIn(stack)) {
            ++quickChargeLevel;
        }
        int accelerateLevel = EnchantmentHelper.func_77506_a((Enchantment)RangedEnchantmentList.ACCELERATE, (ItemStack)stack);
        if (this.hasAccelerateBuiltIn(stack)) {
            ++accelerateLevel;
        }
        IWeapon weaponCap = (IWeapon)stack.getCapability(WeaponProvider.WEAPON_CAPABILITY).orElseThrow(IllegalStateException::new);
        int crossbowChargeTime = weaponCap.getCrossbowChargeTime();
        long lastFiredTime = weaponCap.getLastFiredTime();
        if (accelerateLevel > 0 && lastFiredTime > 0L) {
            return Math.max(crossbowChargeTime - 5 * quickChargeLevel, 0);
        }
        return Math.max(this.getDefaultChargeTime() - 5 * quickChargeLevel, 0);
    }

    public SoundEvent getCrossbowSoundEvent(int i) {
        switch (i) {
            case 1: {
                return SoundEvents.field_219613_bE;
            }
            case 2: {
                return SoundEvents.field_219614_bF;
            }
            case 3: {
                return SoundEvents.field_219615_bG;
            }
        }
        return SoundEvents.field_219612_bD;
    }

    private void fireCrossbowProjectiles(World world, LivingEntity livingEntity, Hand hand, ItemStack stack, float velocityIn, float inaccuracyIn) {
        List<ItemStack> list = AbstractDungeonsCrossbowItem.getChargedProjectiles(stack);
        float[] randomSoundPitches = AbstractDungeonsCrossbowItem.getRandomSoundPitches(livingEntity.func_70681_au());
        for (int i = 0; i < list.size(); ++i) {
            boolean playerInCreativeMode;
            ItemStack currentProjectile = list.get(i);
            boolean bl = playerInCreativeMode = livingEntity instanceof PlayerEntity && ((PlayerEntity)livingEntity).field_71075_bZ.field_75098_d;
            if (currentProjectile.func_190926_b()) continue;
            if (i == 0) {
                this.fireProjectile(world, livingEntity, hand, stack, currentProjectile, randomSoundPitches[i], playerInCreativeMode, velocityIn, inaccuracyIn, 0.0f);
                continue;
            }
            if (i == 1) {
                this.fireProjectile(world, livingEntity, hand, stack, currentProjectile, randomSoundPitches[i], playerInCreativeMode, velocityIn, inaccuracyIn, -10.0f);
                continue;
            }
            if (i == 2) {
                this.fireProjectile(world, livingEntity, hand, stack, currentProjectile, randomSoundPitches[i], playerInCreativeMode, velocityIn, inaccuracyIn, 10.0f);
                continue;
            }
            if (i == 3) {
                this.fireProjectile(world, livingEntity, hand, stack, currentProjectile, randomSoundPitches[i - 2], playerInCreativeMode, velocityIn, inaccuracyIn, -20.0f);
                continue;
            }
            if (i == 4) {
                this.fireProjectile(world, livingEntity, hand, stack, currentProjectile, randomSoundPitches[i - 2], playerInCreativeMode, velocityIn, inaccuracyIn, 20.0f);
                continue;
            }
            if (i == 5) {
                this.fireProjectile(world, livingEntity, hand, stack, currentProjectile, randomSoundPitches[i - 4], playerInCreativeMode, velocityIn, inaccuracyIn, -30.0f);
                continue;
            }
            if (i != 6) continue;
            this.fireProjectile(world, livingEntity, hand, stack, currentProjectile, randomSoundPitches[i - 4], playerInCreativeMode, velocityIn, inaccuracyIn, 30.0f);
        }
        AbstractDungeonsCrossbowItem.fireProjectilesAfter(world, livingEntity, stack);
    }

    private AbstractArrowEntity createCrossbowArrow(World world, LivingEntity livingEntity, ItemStack stack, ItemStack stack1) {
        ArrowItem arrowItem = (ArrowItem)(stack1.func_77973_b() instanceof ArrowItem ? stack1.func_77973_b() : Items.field_151032_g);
        AbstractArrowEntity abstractArrowEntity = arrowItem.func_200887_a(world, stack1, livingEntity);
        if (livingEntity instanceof PlayerEntity) {
            abstractArrowEntity.func_70243_d(true);
        }
        abstractArrowEntity.func_213869_a(SoundEvents.field_219609_bA);
        abstractArrowEntity.func_213865_o(true);
        int piercingLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_222194_I, (ItemStack)stack);
        if (this.hasPiercingBuiltIn(stack)) {
            ++piercingLevel;
        }
        if (piercingLevel > 0) {
            abstractArrowEntity.func_213872_b((byte)piercingLevel);
        }
        int powerLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)stack);
        if (this.shootsHeavyArrows(stack)) {
            ++powerLevel;
        }
        if (powerLevel > 0) {
            abstractArrowEntity.func_70239_b(abstractArrowEntity.func_70242_d() + (double)powerLevel * 0.5 + 0.5);
        }
        int punchLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)stack);
        if (this.shootsHeavyArrows(stack)) {
            ++punchLevel;
        }
        if (punchLevel > 0) {
            abstractArrowEntity.func_70240_a(punchLevel);
        }
        RangedUtils.addWeaponTags(abstractArrowEntity, stack);
        return abstractArrowEntity;
    }

    public float getProjectileVelocity(ItemStack stack) {
        boolean fastProjectiles = this.shootsFasterArrows(stack);
        if (RangedUtils.hasChargedProjectile(stack, Items.field_196152_dE)) {
            if (fastProjectiles) {
                return 3.2f;
            }
            return 1.6f;
        }
        if (fastProjectiles) {
            return 4.8f;
        }
        return 3.2f;
    }

    public int func_77626_a(ItemStack stack) {
        return this.getCrossbowChargeTime(stack) + 3;
    }

    public Rarity func_77613_e(ItemStack itemStack) {
        if (this.isUnique) {
            return Rarity.RARE;
        }
        return Rarity.UNCOMMON;
    }

    public boolean func_219970_i(ItemStack stack) {
        return true;
    }

    private void fireProjectile(World worldIn, LivingEntity shooter, Hand handIn, ItemStack crossbow, ItemStack projectile, float soundPitch, boolean isCreativeMode, float velocity, float inaccuracy, float projectileAngle) {
        if (!worldIn.field_72995_K) {
            AbstractArrowEntity iprojectile;
            boolean flag;
            boolean bl = flag = projectile.func_77973_b() == Items.field_196152_dE;
            if (flag) {
                iprojectile = new FireworkRocketEntity(worldIn, projectile, shooter.func_226277_ct_(), shooter.func_226280_cw_() - (double)0.15f, shooter.func_226281_cx_(), true);
            } else {
                iprojectile = this.createCrossbowArrow(worldIn, shooter, crossbow, projectile);
                if (isCreativeMode || projectileAngle != 0.0f) {
                    iprojectile.field_70251_a = AbstractArrowEntity.PickupStatus.CREATIVE_ONLY;
                }
            }
            if (shooter instanceof ICrossbowUser) {
                ICrossbowUser icrossbowuser = (ICrossbowUser)shooter;
                icrossbowuser.func_213670_a(icrossbowuser.func_70638_az(), crossbow, (IProjectile)iprojectile, projectileAngle);
            } else {
                Vec3d vec3d1 = shooter.func_213286_i(1.0f);
                Quaternion quaternion = new Quaternion(new Vector3f(vec3d1), projectileAngle, true);
                Vec3d vec3d = shooter.func_70676_i(1.0f);
                Vector3f vector3f = new Vector3f(vec3d);
                vector3f.func_214905_a(quaternion);
                iprojectile.func_70186_c((double)vector3f.func_195899_a(), (double)vector3f.func_195900_b(), (double)vector3f.func_195902_c(), velocity, inaccuracy);
            }
            crossbow.func_222118_a(flag ? 3 : 1, shooter, p_220017_1_ -> p_220017_1_.func_213334_d(handIn));
            worldIn.func_217376_c((Entity)iprojectile);
            worldIn.func_184148_a((PlayerEntity)null, shooter.func_226277_ct_(), shooter.func_226278_cu_(), shooter.func_226281_cx_(), SoundEvents.field_219616_bH, SoundCategory.PLAYERS, 1.0f, soundPitch);
        }
    }

    private static void fireProjectilesAfter(World worldIn, LivingEntity shooter, ItemStack stack) {
        if (shooter instanceof ServerPlayerEntity) {
            ServerPlayerEntity serverplayerentity = (ServerPlayerEntity)shooter;
            if (!worldIn.field_72995_K) {
                CriteriaTriggers.field_215099_F.func_215111_a(serverplayerentity, stack);
            }
            serverplayerentity.func_71029_a(Stats.field_75929_E.func_199076_b((Object)stack.func_77973_b()));
        }
        AbstractDungeonsCrossbowItem.clearProjectiles(stack);
    }

    private static void clearProjectiles(ItemStack stack) {
        CompoundNBT compoundnbt = stack.func_77978_p();
        if (compoundnbt != null) {
            ListNBT listnbt = compoundnbt.func_150295_c("ChargedProjectiles", 9);
            listnbt.clear();
            compoundnbt.func_218657_a("ChargedProjectiles", (INBT)listnbt);
        }
    }

    private static List<ItemStack> getChargedProjectiles(ItemStack stack) {
        ArrayList list = Lists.newArrayList();
        CompoundNBT compoundnbt = stack.func_77978_p();
        if (compoundnbt != null && compoundnbt.func_150297_b("ChargedProjectiles", 9)) {
            ListNBT listnbt = compoundnbt.func_150295_c("ChargedProjectiles", 10);
            for (int i = 0; i < listnbt.size(); ++i) {
                CompoundNBT compoundnbt1 = listnbt.func_150305_b(i);
                list.add(ItemStack.func_199557_a((CompoundNBT)compoundnbt1));
            }
        }
        return list;
    }

    public static float[] getRandomSoundPitches(Random rand) {
        boolean flag = rand.nextBoolean();
        return new float[]{1.0f, AbstractDungeonsCrossbowItem.getRandomSoundPitch(flag), AbstractDungeonsCrossbowItem.getRandomSoundPitch(!flag)};
    }

    private static float getRandomSoundPitch(boolean flagIn) {
        float f = flagIn ? 0.63f : 0.43f;
        return 1.0f / (field_77697_d.nextFloat() * 0.5f + 1.8f) + f;
    }

    public boolean func_220021_a(LivingEntity entityIn, ItemStack stack) {
        int multishotLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_222192_G, (ItemStack)stack);
        if (this.hasMultishotBuiltIn(stack)) {
            ++multishotLevel;
        }
        if (this.hasExtraMultishot(stack)) {
            ++multishotLevel;
        }
        int arrowsToFire = multishotLevel == 0 ? 1 : 1 + multishotLevel * 2;
        boolean flag = entityIn instanceof PlayerEntity && ((PlayerEntity)entityIn).field_71075_bZ.field_75098_d;
        ItemStack itemstack = entityIn.func_213356_f(stack);
        ItemStack itemstack1 = itemstack.func_77946_l();
        for (int i = 0; i < arrowsToFire; ++i) {
            if (i > 0) {
                itemstack = itemstack1.func_77946_l();
            }
            if (itemstack.func_190926_b() && flag) {
                itemstack = new ItemStack((IItemProvider)Items.field_151032_g);
                itemstack1 = itemstack.func_77946_l();
            }
            if (AbstractDungeonsCrossbowItem.canAddChargedProjectile(entityIn, stack, itemstack, i > 0, flag)) continue;
            return false;
        }
        return true;
    }

    private static boolean canAddChargedProjectile(LivingEntity livingEntity, ItemStack stack, ItemStack stack1, boolean b, boolean b1) {
        ItemStack itemstack;
        boolean flag;
        if (stack1.func_190926_b()) {
            return false;
        }
        boolean bl = flag = b1 && stack1.func_77973_b() instanceof ArrowItem;
        if (!(flag || b1 || b)) {
            itemstack = stack1.func_77979_a(1);
            if (stack1.func_190926_b() && livingEntity instanceof PlayerEntity) {
                ((PlayerEntity)livingEntity).field_71071_by.func_184437_d(stack1);
            }
        } else {
            itemstack = stack1.func_77946_l();
        }
        AbstractDungeonsCrossbowItem.addChargedProjectile(stack, itemstack);
        return true;
    }

    private static void addChargedProjectile(ItemStack crossbow, ItemStack projectile) {
        CompoundNBT compoundnbt = crossbow.func_196082_o();
        ListNBT listnbt = compoundnbt.func_150297_b("ChargedProjectiles", 9) ? compoundnbt.func_150295_c("ChargedProjectiles", 10) : new ListNBT();
        CompoundNBT compoundnbt1 = new CompoundNBT();
        projectile.func_77955_b(compoundnbt1);
        listnbt.add((Object)compoundnbt1);
        compoundnbt.func_218657_a("ChargedProjectiles", (INBT)listnbt);
    }
}

