/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_gear.utilties;

import com.infamous.dungeons_gear.DungeonsGear;
import com.infamous.dungeons_gear.capabilities.summoning.ISummonable;
import com.infamous.dungeons_gear.capabilities.summoning.ISummoner;
import com.infamous.dungeons_gear.capabilities.summoning.SummonableProvider;
import com.infamous.dungeons_gear.capabilities.summoning.SummonerProvider;
import com.infamous.dungeons_gear.damagesources.ElectricShockDamageSource;
import com.infamous.dungeons_gear.effects.CustomEffects;
import com.infamous.dungeons_gear.enchantments.lists.MeleeRangedEnchantmentList;
import com.infamous.dungeons_gear.goals.BatFollowOwnerGoal;
import com.infamous.dungeons_gear.goals.BatMeleeAttackGoal;
import com.infamous.dungeons_gear.goals.BatOwnerHurtByTargetGoal;
import com.infamous.dungeons_gear.goals.BatOwnerHurtTargetGoal;
import com.infamous.dungeons_gear.goals.GoalUtils;
import com.infamous.dungeons_gear.goals.WildRageAttackGoal;
import com.infamous.dungeons_gear.init.ParticleInit;
import com.infamous.dungeons_gear.items.RangedWeaponList;
import com.infamous.dungeons_gear.ranged.crossbows.AbstractDungeonsCrossbowItem;
import com.infamous.dungeons_gear.utilties.EnchantUtils;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.AreaEffectCloudEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.BatEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.passive.horse.LlamaEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.SnowballEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class AbilityUtils {
    public static void summonOrTeleportBat(PlayerEntity playerEntity, World world) {
        ISummoner summonerCap = (ISummoner)playerEntity.getCapability(SummonerProvider.SUMMONER_CAPABILITY).orElseThrow(IllegalStateException::new);
        if (summonerCap.getSummonedBat() == null) {
            BatEntity batEntity = (BatEntity)EntityType.field_200791_e.func_200721_a(world);
            if (batEntity != null) {
                batEntity.func_70012_b(playerEntity.func_226277_ct_() + (double)playerEntity.func_70047_e(), playerEntity.func_226278_cu_() + (double)playerEntity.func_70047_e(), playerEntity.func_226281_cx_() + (double)playerEntity.func_70047_e(), 0.0f, 0.0f);
                batEntity.field_70714_bg.func_75776_a(1, (Goal)new BatFollowOwnerGoal(batEntity, 2.1, 10.0f, 2.0f, false));
                batEntity.field_70714_bg.func_75776_a(2, (Goal)new BatMeleeAttackGoal(batEntity, 1.0, true));
                batEntity.field_70715_bh.func_75776_a(1, (Goal)new BatOwnerHurtByTargetGoal(batEntity));
                batEntity.field_70715_bh.func_75776_a(2, (Goal)new BatOwnerHurtTargetGoal(batEntity));
                batEntity.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)batEntity, LivingEntity.class, 5, false, false, entityIterator -> entityIterator instanceof IMob && !(entityIterator instanceof CreeperEntity)));
                world.func_184148_a((PlayerEntity)null, playerEntity.func_226277_ct_(), playerEntity.func_226278_cu_(), playerEntity.func_226281_cx_(), SoundEvents.field_187740_w, SoundCategory.AMBIENT, 64.0f, 1.0f);
                world.func_217376_c((Entity)batEntity);
                ISummonable summonable = (ISummonable)batEntity.getCapability(SummonableProvider.SUMMONABLE_CAPABILITY).orElseThrow(IllegalStateException::new);
                summonable.setSummoner(playerEntity.func_110124_au());
                summonerCap.setSummonedBat(batEntity.func_110124_au());
            }
        } else {
            Entity entity = ((ServerWorld)world).func_217461_a(summonerCap.getSummonedBat());
            if (entity instanceof BatEntity) {
                BatEntity batEntity = (BatEntity)entity;
                batEntity.func_223102_j(playerEntity.func_226277_ct_() + (double)playerEntity.func_70047_e(), playerEntity.func_226278_cu_() + (double)playerEntity.func_70047_e(), playerEntity.func_226281_cx_() + (double)playerEntity.func_70047_e());
            }
        }
    }

    public static void teleportOnHit(LivingEntity livingEntity) {
        World world = livingEntity.func_130014_f_();
        if (!world.field_72995_K) {
            double lvt_5_1_ = livingEntity.func_226277_ct_();
            double lvt_7_1_ = livingEntity.func_226278_cu_();
            double lvt_9_1_ = livingEntity.func_226281_cx_();
            for (int i = 0; i < 16; ++i) {
                double teleportX = livingEntity.func_226277_ct_() + (livingEntity.func_70681_au().nextDouble() - 0.5) * 16.0;
                double teleportY = MathHelper.func_151237_a((double)(livingEntity.func_226278_cu_() + (double)(livingEntity.func_70681_au().nextInt(16) - 8)), (double)0.0, (double)255.0);
                double teleportZ = livingEntity.func_226281_cx_() + (livingEntity.func_70681_au().nextDouble() - 0.5) * 16.0;
                if (livingEntity.func_184218_aH()) {
                    livingEntity.func_184210_p();
                }
                if (!livingEntity.func_213373_a(teleportX, teleportY, teleportZ, true)) continue;
                SoundEvent lvt_18_1_ = SoundEvents.field_187544_ad;
                world.func_184148_a((PlayerEntity)null, lvt_5_1_, lvt_7_1_, lvt_9_1_, lvt_18_1_, SoundCategory.PLAYERS, 1.0f, 1.0f);
                livingEntity.func_184185_a(lvt_18_1_, 1.0f, 1.0f);
                break;
            }
        }
    }

    public static void stealSpeedFromTarget(LivingEntity attacker, LivingEntity target, int amplifer) {
        EffectInstance speed = new EffectInstance(Effects.field_76424_c, 80, amplifer);
        EffectInstance slowness = new EffectInstance(Effects.field_76421_d, 80, amplifer);
        attacker.func_195064_c(speed);
        target.func_195064_c(slowness);
    }

    public static void makePetsAttackTarget(LivingEntity target, LivingEntity owner) {
        List nearbyEntities = owner.func_130014_f_().func_225316_b(LivingEntity.class, new AxisAlignedBB(owner.func_226277_ct_() - 12.0, owner.func_226278_cu_() - 12.0, owner.func_226281_cx_() - 12.0, owner.func_226277_ct_() + 12.0, owner.func_226278_cu_() + 12.0, owner.func_226281_cx_() + 12.0), nearbyEntity -> nearbyEntity != owner && AbilityUtils.isPetOfAttacker(owner, nearbyEntity) && nearbyEntity.func_70089_S());
        for (LivingEntity nearbyEntity2 : nearbyEntities) {
            if (nearbyEntity2 instanceof TameableEntity) {
                TameableEntity tameableEntity = (TameableEntity)nearbyEntity2;
                tameableEntity.func_70624_b(target);
            }
            if (nearbyEntity2 instanceof LlamaEntity) {
                LlamaEntity llamaEntity = (LlamaEntity)nearbyEntity2;
                llamaEntity.func_70624_b(target);
            }
            if (!(nearbyEntity2 instanceof IronGolemEntity)) continue;
            IronGolemEntity ironGolemEntity = (IronGolemEntity)nearbyEntity2;
            ironGolemEntity.func_70624_b(target);
        }
    }

    public static boolean isPetOfAttacker(LivingEntity possibleOwner, LivingEntity possiblePet) {
        if (possiblePet instanceof TameableEntity) {
            TameableEntity pet = (TameableEntity)possiblePet;
            return pet.func_70902_q() == possibleOwner;
        }
        if (possiblePet instanceof AbstractHorseEntity) {
            AbstractHorseEntity abstractHorse = (AbstractHorseEntity)possiblePet;
            return GoalUtils.getOwner(abstractHorse) == possibleOwner;
        }
        if (possiblePet instanceof IronGolemEntity) {
            IronGolemEntity ironGolem = (IronGolemEntity)possiblePet;
            return GoalUtils.getOwner(ironGolem) == possibleOwner;
        }
        return false;
    }

    public static void pullInNearbyEntities(LivingEntity attacker, LivingEntity target, float distance) {
        World world = target.func_130014_f_();
        List nearbyEntities = world.func_225316_b(LivingEntity.class, new AxisAlignedBB(target.func_226277_ct_() - (double)distance, target.func_226278_cu_() - (double)distance, target.func_226281_cx_() - (double)distance, target.func_226277_ct_() + (double)distance, target.func_226278_cu_() + (double)distance, target.func_226281_cx_() + (double)distance), nearbyEntity -> nearbyEntity != target && nearbyEntity != attacker && !AbilityUtils.isPetOfAttacker(attacker, nearbyEntity) && nearbyEntity.func_70089_S() && !(nearbyEntity instanceof AbstractVillagerEntity));
        DungeonsGear.PROXY.spawnParticles((Entity)target, ParticleTypes.field_197599_J);
        for (LivingEntity nearbyEntity2 : nearbyEntities) {
            double motionX = target.func_226277_ct_() - nearbyEntity2.func_226277_ct_();
            double motionY = target.func_226278_cu_() - nearbyEntity2.func_226278_cu_();
            double motionZ = target.func_226281_cx_() - nearbyEntity2.func_226281_cx_();
            Vec3d vector3d = new Vec3d(motionX, motionY, motionZ);
            nearbyEntity2.func_213317_d(vector3d);
            DungeonsGear.PROXY.spawnParticles((Entity)nearbyEntity2, ParticleTypes.field_197599_J);
        }
    }

    public static void healNearbyAllies(LivingEntity healer, EffectInstance potionEffect, float distance) {
        World world = healer.func_130014_f_();
        PlayerEntity playerentity = healer instanceof PlayerEntity ? (PlayerEntity)healer : null;
        List nearbyEntities = world.func_225316_b(LivingEntity.class, new AxisAlignedBB(healer.func_226277_ct_() - (double)distance, healer.func_226278_cu_() - (double)distance, healer.func_226281_cx_() - (double)distance, healer.func_226277_ct_() + (double)distance, healer.func_226278_cu_() + (double)distance, healer.func_226281_cx_() + (double)distance), nearbyEntity -> nearbyEntity != healer && (AbilityUtils.isPetOfAttacker(healer, nearbyEntity) || nearbyEntity instanceof AbstractVillagerEntity || healer.func_184191_r((Entity)nearbyEntity)) && nearbyEntity.func_70089_S());
        for (LivingEntity nearbyEntity2 : nearbyEntities) {
            if (!(nearbyEntity2.func_110143_aJ() < nearbyEntity2.func_110138_aP())) continue;
            if (potionEffect.func_188419_a().func_76403_b()) {
                potionEffect.func_188419_a().func_180793_a((Entity)playerentity, (Entity)playerentity, nearbyEntity2, potionEffect.func_76458_c(), 1.0);
            } else {
                nearbyEntity2.func_195064_c(new EffectInstance(potionEffect));
            }
            DungeonsGear.PROXY.spawnParticles((Entity)nearbyEntity2, ParticleTypes.field_197633_z);
        }
    }

    public static void healNearbyAllies(LivingEntity healer, float amount, float distance) {
        World world = healer.func_130014_f_();
        PlayerEntity playerentity = healer instanceof PlayerEntity ? (PlayerEntity)healer : null;
        List nearbyEntities = world.func_225316_b(LivingEntity.class, new AxisAlignedBB(healer.func_226277_ct_() - (double)distance, healer.func_226278_cu_() - (double)distance, healer.func_226281_cx_() - (double)distance, healer.func_226277_ct_() + (double)distance, healer.func_226278_cu_() + (double)distance, healer.func_226281_cx_() + (double)distance), nearbyEntity -> nearbyEntity != healer && (AbilityUtils.isPetOfAttacker(healer, nearbyEntity) || nearbyEntity instanceof AbstractVillagerEntity || healer.func_184191_r((Entity)nearbyEntity)) && nearbyEntity.func_70089_S());
        for (LivingEntity nearbyEntity2 : nearbyEntities) {
            if (!(nearbyEntity2.func_110143_aJ() < nearbyEntity2.func_110138_aP())) continue;
            nearbyEntity2.func_70691_i(amount);
            DungeonsGear.PROXY.spawnParticles((Entity)nearbyEntity2, ParticleTypes.field_197633_z);
        }
    }

    public static void pullInNearbyEntitiesAtPos(LivingEntity attacker, BlockPos blockPos, int distance) {
        World world = attacker.func_130014_f_();
        List nearbyEntities = world.func_225316_b(LivingEntity.class, new AxisAlignedBB((double)(blockPos.func_177958_n() - distance), (double)(blockPos.func_177956_o() - distance), (double)(blockPos.func_177952_p() - distance), (double)(blockPos.func_177958_n() + distance), (double)(blockPos.func_177956_o() + distance), (double)(blockPos.func_177952_p() + distance)), nearbyEntity -> nearbyEntity != attacker && !AbilityUtils.isPetOfAttacker(attacker, nearbyEntity) && nearbyEntity.func_70089_S() && !(nearbyEntity instanceof AbstractVillagerEntity));
        for (LivingEntity nearbyEntity2 : nearbyEntities) {
            double motionX = (double)blockPos.func_177958_n() - nearbyEntity2.func_226277_ct_();
            double motionY = (double)blockPos.func_177956_o() - nearbyEntity2.func_226278_cu_();
            double motionZ = (double)blockPos.func_177952_p() - nearbyEntity2.func_226281_cx_();
            Vec3d vector3d = new Vec3d(motionX, motionY, motionZ);
            nearbyEntity2.func_213317_d(vector3d);
            DungeonsGear.PROXY.spawnParticles((Entity)nearbyEntity2, ParticleTypes.field_197599_J);
        }
    }

    public static void chainNearbyEntities(LivingEntity attacker, LivingEntity target, float distance, int timeMultiplier) {
        World world = target.func_130014_f_();
        List nearbyEntities = world.func_225316_b(LivingEntity.class, new AxisAlignedBB(target.func_226277_ct_() - (double)distance, target.func_226278_cu_() - (double)distance, target.func_226281_cx_() - (double)distance, target.func_226277_ct_() + (double)distance, target.func_226278_cu_() + (double)distance, target.func_226281_cx_() + (double)distance), nearbyEntity -> nearbyEntity != target && nearbyEntity != attacker && !AbilityUtils.isPetOfAttacker(attacker, nearbyEntity) && nearbyEntity.func_70089_S() && !(nearbyEntity instanceof AbstractVillagerEntity));
        DungeonsGear.PROXY.spawnParticles((Entity)target, ParticleTypes.field_197599_J);
        EffectInstance chained = new EffectInstance(Effects.field_76421_d, 20 * timeMultiplier, 5);
        target.func_195064_c(chained);
        for (LivingEntity nearbyEntity2 : nearbyEntities) {
            double motionX = target.func_226277_ct_() - nearbyEntity2.func_226277_ct_();
            double motionY = target.func_226278_cu_() - nearbyEntity2.func_226278_cu_();
            double motionZ = target.func_226281_cx_() - nearbyEntity2.func_226281_cx_();
            Vec3d vector3d = new Vec3d(motionX, motionY, motionZ);
            nearbyEntity2.func_213317_d(vector3d);
            nearbyEntity2.func_195064_c(chained);
            DungeonsGear.PROXY.spawnParticles((Entity)nearbyEntity2, ParticleTypes.field_197599_J);
        }
    }

    public static void weakenNearbyEntities(LivingEntity attacker, LivingEntity target, int distance, int amplifier) {
        World world = target.func_130014_f_();
        List nearbyEntities = world.func_225316_b(LivingEntity.class, new AxisAlignedBB(target.func_226277_ct_() - (double)distance, target.func_226278_cu_() - (double)distance, target.func_226281_cx_() - (double)distance, target.func_226277_ct_() + (double)distance, target.func_226278_cu_() + (double)distance, target.func_226281_cx_() + (double)distance), nearbyEntity -> nearbyEntity != target && nearbyEntity != attacker && !AbilityUtils.isPetOfAttacker(attacker, nearbyEntity) && nearbyEntity.func_70089_S() && !(nearbyEntity instanceof AbstractVillagerEntity));
        for (LivingEntity nearbyEntity2 : nearbyEntities) {
            EffectInstance weakness = new EffectInstance(Effects.field_76437_t, 100, amplifier);
            nearbyEntity2.func_195064_c(weakness);
        }
    }

    public static void setProjectileTowards(ThrowableEntity projectileEntity, double x, double y, double z, float inaccuracy) {
        Random random = new Random();
        Vec3d vector3d = new Vec3d(x, y, z).func_72432_b().func_72441_c(random.nextGaussian() * (double)0.0075f * (double)inaccuracy, random.nextGaussian() * (double)0.0075f * (double)inaccuracy, random.nextGaussian() * (double)0.0075f * (double)inaccuracy);
        projectileEntity.func_213317_d(vector3d);
        float f = MathHelper.func_76133_a((double)Entity.func_213296_b((Vec3d)vector3d));
        projectileEntity.field_70177_z = (float)(MathHelper.func_181159_b((double)vector3d.field_72450_a, (double)vector3d.field_72449_c) * 57.2957763671875);
        projectileEntity.field_70125_A = (float)(MathHelper.func_181159_b((double)vector3d.field_72448_b, (double)f) * 57.2957763671875);
        projectileEntity.field_70126_B = projectileEntity.field_70177_z;
        projectileEntity.field_70127_C = projectileEntity.field_70125_A;
    }

    public static void setProjectileTowards(AbstractArrowEntity projectileEntity, double x, double y, double z, float inaccuracy) {
        Random random = new Random();
        Vec3d vector3d = new Vec3d(x, y, z).func_72432_b().func_72441_c(random.nextGaussian() * (double)0.0075f * (double)inaccuracy, random.nextGaussian() * (double)0.0075f * (double)inaccuracy, random.nextGaussian() * (double)0.0075f * (double)inaccuracy);
        projectileEntity.func_213317_d(vector3d);
        float f = MathHelper.func_76133_a((double)Entity.func_213296_b((Vec3d)vector3d));
        projectileEntity.field_70177_z = (float)(MathHelper.func_181159_b((double)vector3d.field_72450_a, (double)vector3d.field_72449_c) * 57.2957763671875);
        projectileEntity.field_70125_A = (float)(MathHelper.func_181159_b((double)vector3d.field_72448_b, (double)f) * 57.2957763671875);
        projectileEntity.field_70126_B = projectileEntity.field_70177_z;
        projectileEntity.field_70127_C = projectileEntity.field_70125_A;
    }

    public static void ricochetArrowTowardsOtherEntity(LivingEntity attacker, LivingEntity victim, AbstractArrowEntity arrowEntity, int distance) {
        World world = attacker.func_130014_f_();
        List nearbyEntities = world.func_225316_b(LivingEntity.class, new AxisAlignedBB(victim.func_226277_ct_() - (double)distance, victim.func_226278_cu_() - (double)distance, victim.func_226281_cx_() - (double)distance, victim.func_226277_ct_() + (double)distance, victim.func_226278_cu_() + (double)distance, victim.func_226281_cx_() + (double)distance), nearbyEntity -> nearbyEntity != attacker && nearbyEntity != victim && !AbilityUtils.isPetOfAttacker(attacker, nearbyEntity) && nearbyEntity.func_70089_S() && victim.func_70685_l((Entity)nearbyEntity) && !(nearbyEntity instanceof AbstractVillagerEntity));
        if (nearbyEntities.isEmpty()) {
            return;
        }
        nearbyEntities.sort(Comparator.comparingDouble(livingEntity -> livingEntity.func_70068_e((Entity)victim)));
        LivingEntity target = (LivingEntity)nearbyEntities.get(0);
        if (target != null) {
            byte pierceLevel = arrowEntity.func_213874_s();
            pierceLevel = (byte)(pierceLevel + 1);
            arrowEntity.func_213872_b(pierceLevel);
            double towardsX = target.func_226277_ct_() - victim.func_226277_ct_();
            double towardsZ = target.func_226281_cx_() - victim.func_226281_cx_();
            double euclideanDist = MathHelper.func_76133_a((double)(towardsX * towardsX + towardsZ * towardsZ));
            double towardsY = target.func_226283_e_(0.3333333333333333) - arrowEntity.func_226278_cu_() + euclideanDist * (double)0.2f;
            AbilityUtils.setProjectileTowards(arrowEntity, towardsX, towardsY, towardsZ, 0.0f);
        }
    }

    public static void fireBonusShotTowardsOtherEntity(LivingEntity attacker, int distance, double bonusShotDamageMultiplier, float arrowVelocity) {
        World world = attacker.func_130014_f_();
        List nearbyEntities = world.func_225316_b(LivingEntity.class, new AxisAlignedBB(attacker.func_226277_ct_() - (double)distance, attacker.func_226278_cu_() - (double)distance, attacker.func_226281_cx_() - (double)distance, attacker.func_226277_ct_() + (double)distance, attacker.func_226278_cu_() + (double)distance, attacker.func_226281_cx_() + (double)distance), nearbyEntity -> nearbyEntity != attacker && !AbilityUtils.isPetOfAttacker(attacker, nearbyEntity) && nearbyEntity.func_70089_S() && attacker.func_70685_l((Entity)nearbyEntity) && !(nearbyEntity instanceof AbstractVillagerEntity));
        if (nearbyEntities.size() < 2) {
            return;
        }
        nearbyEntities.sort(Comparator.comparingDouble(livingEntity -> livingEntity.func_70068_e((Entity)attacker)));
        LivingEntity target = (LivingEntity)nearbyEntities.get(0);
        if (target != null) {
            ArrowItem arrowItem = (ArrowItem)Items.field_151032_g;
            AbstractArrowEntity arrowEntity = arrowItem.func_200887_a(world, new ItemStack((IItemProvider)Items.field_151032_g), attacker);
            arrowEntity.func_70239_b(arrowEntity.func_70242_d() * bonusShotDamageMultiplier);
            double towardsX = target.func_226277_ct_() - attacker.func_226277_ct_();
            double towardsZ = target.func_226281_cx_() - attacker.func_226281_cx_();
            double euclideanDist = MathHelper.func_76133_a((double)(towardsX * towardsX + towardsZ * towardsZ));
            double towardsY = target.func_226283_e_(0.3333333333333333) - arrowEntity.func_226278_cu_() + euclideanDist * (double)0.2f;
            arrowEntity.func_184547_a((Entity)attacker, attacker.field_70125_A, attacker.field_70177_z, 0.0f, arrowVelocity * 3.0f, 1.0f);
            AbilityUtils.setProjectileTowards(arrowEntity, towardsX, towardsY, towardsZ, 0.0f);
            arrowEntity.field_70251_a = AbstractArrowEntity.PickupStatus.CREATIVE_ONLY;
            arrowEntity.func_184211_a("BonusProjectile");
            attacker.field_70170_p.func_217376_c((Entity)arrowEntity);
        }
    }

    public static void fireSnowballAtNearbyEnemy(LivingEntity attacker, int distance) {
        World world = attacker.func_130014_f_();
        List nearbyEntities = world.func_225316_b(LivingEntity.class, new AxisAlignedBB(attacker.func_226277_ct_() - (double)distance, attacker.func_226278_cu_() - (double)distance, attacker.func_226281_cx_() - (double)distance, attacker.func_226277_ct_() + (double)distance, attacker.func_226278_cu_() + (double)distance, attacker.func_226281_cx_() + (double)distance), nearbyEntity -> nearbyEntity != attacker && !AbilityUtils.isPetOfAttacker(attacker, nearbyEntity) && nearbyEntity.func_70089_S() && attacker.func_70685_l((Entity)nearbyEntity) && !(nearbyEntity instanceof AbstractVillagerEntity));
        if (nearbyEntities.size() < 2) {
            return;
        }
        nearbyEntities.sort(Comparator.comparingDouble(livingEntity -> livingEntity.func_70068_e((Entity)attacker)));
        LivingEntity target = (LivingEntity)nearbyEntities.get(0);
        if (target != null) {
            SnowballEntity snowballEntity = new SnowballEntity(world, attacker);
            double towardsX = target.func_226277_ct_() - attacker.func_226277_ct_();
            double towardsZ = target.func_226281_cx_() - attacker.func_226281_cx_();
            double euclideanDist = MathHelper.func_76133_a((double)(towardsX * towardsX + towardsZ * towardsZ));
            double towardsY = target.func_226283_e_(0.3333333333333333) - snowballEntity.func_226278_cu_() + euclideanDist * (double)0.2f;
            snowballEntity.func_184538_a((Entity)attacker, attacker.field_70125_A, attacker.field_70177_z, 0.0f, 1.5f, 1.0f);
            AbilityUtils.setProjectileTowards((ThrowableEntity)snowballEntity, towardsX, towardsY, towardsZ, 0.0f);
            attacker.field_70170_p.func_217376_c((Entity)snowballEntity);
        }
    }

    public static void causeShockwave(LivingEntity attacker, LivingEntity target, float damageAmount, float distance) {
        World world = target.func_130014_f_();
        DamageSource shockwave = DamageSource.func_188405_b((LivingEntity)attacker);
        List nearbyEntities = world.func_225316_b(LivingEntity.class, new AxisAlignedBB(target.func_226277_ct_() - (double)distance, target.func_226278_cu_() - (double)distance, target.func_226281_cx_() - (double)distance, target.func_226277_ct_() + (double)distance, target.func_226278_cu_() + (double)distance, target.func_226281_cx_() + (double)distance), nearbyEntity -> nearbyEntity != target && nearbyEntity != attacker && !AbilityUtils.isPetOfAttacker(attacker, nearbyEntity) && nearbyEntity.func_70089_S() && !(nearbyEntity instanceof AbstractVillagerEntity));
        if (nearbyEntities.isEmpty()) {
            return;
        }
        for (LivingEntity nearbyEntity2 : nearbyEntities) {
            nearbyEntity2.func_70097_a(shockwave, damageAmount);
        }
    }

    public static void causeExplosionAttack(LivingEntity attacker, LivingEntity target, float damageAmount, float distance) {
        World world = target.func_130014_f_();
        DamageSource explosion = DamageSource.func_188405_b((LivingEntity)attacker);
        List nearbyEntities = world.func_225316_b(LivingEntity.class, new AxisAlignedBB(target.func_226277_ct_() - (double)distance, target.func_226278_cu_() - (double)distance, target.func_226281_cx_() - (double)distance, target.func_226277_ct_() + (double)distance, target.func_226278_cu_() + (double)distance, target.func_226281_cx_() + (double)distance), nearbyEntity -> nearbyEntity != attacker && !AbilityUtils.isPetOfAttacker(attacker, nearbyEntity) && nearbyEntity.func_70089_S() && !(nearbyEntity instanceof AbstractVillagerEntity));
        if (nearbyEntities.isEmpty()) {
            return;
        }
        for (LivingEntity nearbyEntity2 : nearbyEntities) {
            nearbyEntity2.func_70097_a(explosion, damageAmount);
        }
    }

    public static void causeMagicExplosionAttack(LivingEntity attacker, LivingEntity target, float damageAmount, float distance) {
        World world = target.func_130014_f_();
        DamageSource magicExplosion = DamageSource.func_188405_b((LivingEntity)attacker).func_76348_h().func_82726_p();
        List nearbyEntities = world.func_225316_b(LivingEntity.class, new AxisAlignedBB(target.func_226277_ct_() - (double)distance, target.func_226278_cu_() - (double)distance, target.func_226281_cx_() - (double)distance, target.func_226277_ct_() + (double)distance, target.func_226278_cu_() + (double)distance, target.func_226281_cx_() + (double)distance), nearbyEntity -> nearbyEntity != attacker && !AbilityUtils.isPetOfAttacker(attacker, nearbyEntity) && nearbyEntity.func_70089_S() && !(nearbyEntity instanceof AbstractVillagerEntity));
        if (nearbyEntities.isEmpty()) {
            return;
        }
        for (LivingEntity nearbyEntity2 : nearbyEntities) {
            nearbyEntity2.func_70097_a(magicExplosion, damageAmount);
        }
    }

    public static void burnNearbyEnemies(LivingEntity attacker, float damage, float distance) {
        World world = attacker.func_130014_f_();
        List nearbyEntities = world.func_225316_b(LivingEntity.class, new AxisAlignedBB(attacker.func_226277_ct_() - (double)distance, attacker.func_226278_cu_() - (double)distance, attacker.func_226281_cx_() - (double)distance, attacker.func_226277_ct_() + (double)distance, attacker.func_226278_cu_() + (double)distance, attacker.func_226281_cx_() + (double)distance), nearbyEntity -> nearbyEntity != attacker && !AbilityUtils.isPetOfAttacker(attacker, nearbyEntity) && nearbyEntity.func_70089_S() && !(nearbyEntity instanceof AbstractVillagerEntity));
        if (nearbyEntities.isEmpty()) {
            return;
        }
        for (LivingEntity nearbyEntity2 : nearbyEntities) {
            nearbyEntity2.func_70097_a(DamageSource.field_76370_b, damage);
            DungeonsGear.PROXY.spawnParticles((Entity)nearbyEntity2, ParticleTypes.field_197631_x);
        }
    }

    public static void freezeNearbyEnemies(LivingEntity attacker, int amplifier, float distance) {
        World world = attacker.func_130014_f_();
        List nearbyEntities = world.func_225316_b(LivingEntity.class, new AxisAlignedBB(attacker.func_226277_ct_() - (double)distance, attacker.func_226278_cu_() - (double)distance, attacker.func_226281_cx_() - (double)distance, attacker.func_226277_ct_() + (double)distance, attacker.func_226278_cu_() + (double)distance, attacker.func_226281_cx_() + (double)distance), nearbyEntity -> nearbyEntity != attacker && !AbilityUtils.isPetOfAttacker(attacker, nearbyEntity) && nearbyEntity.func_70089_S() && !(nearbyEntity instanceof AbstractVillagerEntity));
        if (nearbyEntities.isEmpty()) {
            return;
        }
        for (LivingEntity nearbyEntity2 : nearbyEntities) {
            EffectInstance slowness = new EffectInstance(Effects.field_76421_d, 20, amplifier);
            EffectInstance fatigue = new EffectInstance(Effects.field_76419_f, 20, amplifier * 2 - 1);
            nearbyEntity2.func_195064_c(slowness);
            nearbyEntity2.func_195064_c(fatigue);
            DungeonsGear.PROXY.spawnParticles((Entity)nearbyEntity2, ParticleTypes.field_197593_D);
        }
    }

    public static void causeExplosionAttackAtPos(LivingEntity attacker, boolean arrow, BlockPos blockPos, float damageAmount, float distance) {
        int inGroundMitigator = arrow ? 1 : 0;
        World world = attacker.func_130014_f_();
        DamageSource explosion = DamageSource.func_188405_b((LivingEntity)attacker);
        List nearbyEntities = world.func_225316_b(LivingEntity.class, new AxisAlignedBB((double)((float)blockPos.func_177958_n() - distance), (double)((float)(blockPos.func_177956_o() + inGroundMitigator) - distance), (double)((float)blockPos.func_177952_p() - distance), (double)((float)blockPos.func_177958_n() + distance), (double)((float)(blockPos.func_177956_o() + inGroundMitigator) + distance), (double)((float)blockPos.func_177952_p() + distance)), nearbyEntity -> nearbyEntity != attacker && !AbilityUtils.isPetOfAttacker(attacker, nearbyEntity) && nearbyEntity.func_70089_S() && !(nearbyEntity instanceof AbstractVillagerEntity));
        if (nearbyEntities.isEmpty()) {
            return;
        }
        for (LivingEntity nearbyEntity2 : nearbyEntities) {
            nearbyEntity2.func_70097_a(explosion, damageAmount);
        }
    }

    public static void causeSwirlingAttack(PlayerEntity attacker, LivingEntity target, float damageAmount, float distance) {
        World world = target.func_130014_f_();
        DamageSource swirling = DamageSource.func_76365_a((PlayerEntity)attacker);
        List nearbyEntities = world.func_225316_b(LivingEntity.class, new AxisAlignedBB(attacker.func_226277_ct_() - (double)distance, attacker.func_226278_cu_() - (double)distance, attacker.func_226281_cx_() - (double)distance, attacker.func_226277_ct_() + (double)distance, attacker.func_226278_cu_() + (double)distance, attacker.func_226281_cx_() + (double)distance), nearbyEntity -> nearbyEntity != target && nearbyEntity != attacker && !AbilityUtils.isPetOfAttacker((LivingEntity)attacker, nearbyEntity) && nearbyEntity.func_70089_S() && !(nearbyEntity instanceof AbstractVillagerEntity));
        if (nearbyEntities.isEmpty()) {
            return;
        }
        for (LivingEntity nearbyEntity2 : nearbyEntities) {
            nearbyEntity2.func_70097_a(swirling, damageAmount);
        }
    }

    public static void causeEchoAttack(LivingEntity attacker, LivingEntity target, float damageAmount, float distance) {
        List nearbyEntities;
        World world = target.func_130014_f_();
        DamageSource echo = DamageSource.func_76358_a((LivingEntity)attacker);
        if (attacker instanceof PlayerEntity) {
            echo = DamageSource.func_76365_a((PlayerEntity)((PlayerEntity)attacker));
        }
        if ((nearbyEntities = world.func_225316_b(LivingEntity.class, new AxisAlignedBB(target.func_226277_ct_() - (double)distance, target.func_226278_cu_() - (double)distance, target.func_226281_cx_() - (double)distance, target.func_226277_ct_() + (double)distance, target.func_226278_cu_() + (double)distance, target.func_226281_cx_() + (double)distance), nearbyEntity -> nearbyEntity != target && nearbyEntity != attacker && !AbilityUtils.isPetOfAttacker(attacker, nearbyEntity) && nearbyEntity.func_70089_S() && !(nearbyEntity instanceof AbstractVillagerEntity))).isEmpty()) {
            return;
        }
        Iterator iterator = nearbyEntities.iterator();
        if (iterator.hasNext()) {
            LivingEntity nearbyEntity2 = (LivingEntity)iterator.next();
            if (nearbyEntity2 == null) {
                return;
            }
            nearbyEntity2.func_70097_a(echo, damageAmount);
            return;
        }
    }

    public static void spawnExplosionCloud(LivingEntity attacker, LivingEntity victim, float radius) {
        AreaEffectCloudEntity areaeffectcloudentity = new AreaEffectCloudEntity(victim.field_70170_p, victim.func_226277_ct_(), victim.func_226278_cu_(), victim.func_226281_cx_());
        areaeffectcloudentity.func_184481_a(attacker);
        areaeffectcloudentity.func_195059_a((IParticleData)ParticleTypes.field_197627_t);
        areaeffectcloudentity.func_184483_a(radius);
        areaeffectcloudentity.func_184486_b(0);
        attacker.field_70170_p.func_217376_c((Entity)areaeffectcloudentity);
    }

    public static void spawnExplosionCloudAtPos(LivingEntity attacker, boolean arrow, BlockPos blockPos, float radius) {
        int inGroundMitigator = arrow ? 1 : 0;
        AreaEffectCloudEntity areaeffectcloudentity = new AreaEffectCloudEntity(attacker.field_70170_p, (double)blockPos.func_177958_n(), (double)(blockPos.func_177956_o() + inGroundMitigator), (double)blockPos.func_177952_p());
        areaeffectcloudentity.func_184481_a(attacker);
        areaeffectcloudentity.func_195059_a((IParticleData)ParticleTypes.field_197627_t);
        areaeffectcloudentity.func_184483_a(radius);
        areaeffectcloudentity.func_184486_b(0);
        attacker.field_70170_p.func_217376_c((Entity)areaeffectcloudentity);
    }

    public static void spawnCritCloud(LivingEntity attacker, LivingEntity victim, float radius) {
        AreaEffectCloudEntity areaeffectcloudentity = new AreaEffectCloudEntity(victim.field_70170_p, victim.func_226277_ct_(), victim.func_226278_cu_(), victim.func_226281_cx_());
        areaeffectcloudentity.func_184481_a(attacker);
        areaeffectcloudentity.func_195059_a((IParticleData)ParticleTypes.field_197614_g);
        areaeffectcloudentity.func_184483_a(radius);
        areaeffectcloudentity.func_184486_b(0);
        attacker.field_70170_p.func_217376_c((Entity)areaeffectcloudentity);
    }

    public static void spawnRegenCloud(LivingEntity attacker, int amplifier) {
        AreaEffectCloudEntity areaeffectcloudentity = new AreaEffectCloudEntity(attacker.field_70170_p, attacker.func_226277_ct_(), attacker.func_226278_cu_(), attacker.func_226281_cx_());
        areaeffectcloudentity.func_184481_a(attacker);
        areaeffectcloudentity.func_184483_a(5.0f);
        areaeffectcloudentity.func_184495_b(-0.5f);
        areaeffectcloudentity.func_184485_d(10);
        areaeffectcloudentity.func_184486_b(100);
        EffectInstance regeneration = new EffectInstance(Effects.field_76428_l, 100, amplifier);
        areaeffectcloudentity.func_184496_a(regeneration);
        attacker.field_70170_p.func_217376_c((Entity)areaeffectcloudentity);
    }

    public static void spawnRegenCloudAtPos(LivingEntity attacker, boolean arrow, BlockPos blockPos, int amplifier) {
        int inGroundMitigator = arrow ? 1 : 0;
        AreaEffectCloudEntity areaeffectcloudentity = new AreaEffectCloudEntity(attacker.field_70170_p, (double)blockPos.func_177958_n(), (double)(blockPos.func_177956_o() + inGroundMitigator), (double)blockPos.func_177952_p());
        areaeffectcloudentity.func_184481_a(attacker);
        areaeffectcloudentity.func_184483_a(5.0f);
        areaeffectcloudentity.func_184495_b(-0.5f);
        areaeffectcloudentity.func_184485_d(10);
        areaeffectcloudentity.func_184486_b(100);
        EffectInstance regeneration = new EffectInstance(Effects.field_76428_l, 100, amplifier);
        areaeffectcloudentity.func_184496_a(regeneration);
        attacker.field_70170_p.func_217376_c((Entity)areaeffectcloudentity);
    }

    public static void ricochetArrowLikeShield(AbstractArrowEntity arrowEntity, LivingEntity entity) {
        arrowEntity.func_213317_d(arrowEntity.func_213322_ci().func_186678_a(-0.1));
        arrowEntity.field_70177_z += 180.0f;
        arrowEntity.field_70126_B += 180.0f;
        if (!arrowEntity.field_70170_p.field_72995_K && arrowEntity.func_213322_ci().func_189985_c() < 1.0E-7) {
            if (arrowEntity.field_70251_a == AbstractArrowEntity.PickupStatus.ALLOWED) {
                arrowEntity.func_70099_a(new ItemStack((IItemProvider)Items.field_151032_g), 0.1f);
            }
            arrowEntity.func_70106_y();
        }
    }

    public static void spawnShieldingCloudAtPos(LivingEntity attacker, BlockPos blockPos, int duration) {
        AreaEffectCloudEntity areaeffectcloudentity = new AreaEffectCloudEntity(attacker.field_70170_p, (double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p());
        areaeffectcloudentity.func_184481_a(attacker);
        areaeffectcloudentity.func_184483_a(5.0f);
        areaeffectcloudentity.func_184495_b(-0.5f);
        areaeffectcloudentity.func_184485_d(10);
        areaeffectcloudentity.func_184486_b(duration);
        EffectInstance shielding = new EffectInstance(CustomEffects.SHIELDING, duration);
        areaeffectcloudentity.func_184496_a(shielding);
        attacker.field_70170_p.func_217376_c((Entity)areaeffectcloudentity);
    }

    public static void spawnSoulProtectionCloudAtPos(LivingEntity attacker, BlockPos blockPos, int duration) {
        AreaEffectCloudEntity areaeffectcloudentity = new AreaEffectCloudEntity(attacker.field_70170_p, (double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p());
        areaeffectcloudentity.func_184481_a(attacker);
        areaeffectcloudentity.func_184483_a(5.0f);
        areaeffectcloudentity.func_184495_b(-0.5f);
        areaeffectcloudentity.func_184485_d(10);
        areaeffectcloudentity.func_184486_b(duration);
        EffectInstance shielding = new EffectInstance(CustomEffects.SOUL_PROTECTION, duration);
        areaeffectcloudentity.func_184496_a(shielding);
        attacker.field_70170_p.func_217376_c((Entity)areaeffectcloudentity);
    }

    public static void spawnPoisonCloud(LivingEntity attacker, LivingEntity victim, int amplifier) {
        AreaEffectCloudEntity areaeffectcloudentity = new AreaEffectCloudEntity(victim.field_70170_p, victim.func_226277_ct_(), victim.func_226278_cu_(), victim.func_226281_cx_());
        areaeffectcloudentity.func_184481_a(attacker);
        areaeffectcloudentity.func_184483_a(5.0f);
        areaeffectcloudentity.func_184495_b(-0.5f);
        areaeffectcloudentity.func_184485_d(10);
        areaeffectcloudentity.func_184486_b(60);
        EffectInstance poison = new EffectInstance(Effects.field_76436_u, 60, amplifier);
        areaeffectcloudentity.func_184496_a(poison);
        victim.field_70170_p.func_217376_c((Entity)areaeffectcloudentity);
    }

    public static void spawnPoisonCloudAtPos(LivingEntity attacker, boolean arrow, BlockPos blockPos, int amplifier) {
        int inGroundMitigator = arrow ? 1 : 0;
        AreaEffectCloudEntity areaeffectcloudentity = new AreaEffectCloudEntity(attacker.field_70170_p, (double)blockPos.func_177958_n(), (double)(blockPos.func_177956_o() + inGroundMitigator), (double)blockPos.func_177952_p());
        areaeffectcloudentity.func_184481_a(attacker);
        areaeffectcloudentity.func_184483_a(5.0f);
        areaeffectcloudentity.func_184495_b(-0.5f);
        areaeffectcloudentity.func_184485_d(10);
        areaeffectcloudentity.func_184486_b(100);
        EffectInstance poison = new EffectInstance(Effects.field_76436_u, 60, amplifier);
        areaeffectcloudentity.func_184496_a(poison);
        attacker.field_70170_p.func_217376_c((Entity)areaeffectcloudentity);
    }

    public static void electrify(LivingEntity attacker, LivingEntity victim, float damageAmount) {
        ElectricShockDamageSource lightning = (ElectricShockDamageSource)new ElectricShockDamageSource((Entity)attacker).func_82726_p().func_76348_h();
        DungeonsGear.PROXY.spawnParticles((Entity)victim, (BasicParticleType)ParticleInit.ELECTRIC_SHOCK.get());
        victim.func_70097_a((DamageSource)lightning, damageAmount);
    }

    public static void electrifyNearbyEnemies(LivingEntity attacker, float distance, float damageAmount, int limit) {
        World world = attacker.func_130014_f_();
        List nearbyEntities = world.func_225316_b(LivingEntity.class, new AxisAlignedBB(attacker.func_226277_ct_() - (double)distance, attacker.func_226278_cu_() - (double)distance, attacker.func_226281_cx_() - (double)distance, attacker.func_226277_ct_() + (double)distance, attacker.func_226278_cu_() + (double)distance, attacker.func_226281_cx_() + (double)distance), nearbyEntity -> nearbyEntity != attacker && !AbilityUtils.isPetOfAttacker(attacker, nearbyEntity) && nearbyEntity.func_70089_S() && !(nearbyEntity instanceof AbstractVillagerEntity));
        if (nearbyEntities.isEmpty()) {
            return;
        }
        if (limit > nearbyEntities.size()) {
            limit = nearbyEntities.size();
        }
        attacker.field_70170_p.func_184148_a((PlayerEntity)null, attacker.func_226277_ct_(), attacker.func_226278_cu_(), attacker.func_226281_cx_(), SoundEvents.field_187754_de, SoundCategory.WEATHER, 64.0f, 1.0f);
        attacker.field_70170_p.func_184148_a((PlayerEntity)null, attacker.func_226277_ct_(), attacker.func_226278_cu_(), attacker.func_226281_cx_(), SoundEvents.field_187752_dd, SoundCategory.WEATHER, 64.0f, 1.0f);
        for (int i = 0; i < limit; ++i) {
            if (nearbyEntities.size() < i + 1) continue;
            LivingEntity nearbyEntity2 = (LivingEntity)nearbyEntities.get(i);
            AbilityUtils.electrify(attacker, nearbyEntity2, damageAmount);
        }
    }

    public static void sendIntoWildRage(MobEntity mobEntity) {
        mobEntity.field_70715_bh.func_75776_a(0, (Goal)new WildRageAttackGoal(mobEntity));
        DungeonsGear.PROXY.spawnParticles((Entity)mobEntity, ParticleTypes.field_197609_b);
    }

    private static AbstractArrowEntity createChainReactionProjectile(World world, LivingEntity attacker, ItemStack ammoStack, AbstractArrowEntity originalArrow) {
        ArrowItem arrowItem = (ArrowItem)(ammoStack.func_77973_b() instanceof ArrowItem ? ammoStack.func_77973_b() : Items.field_151032_g);
        AbstractArrowEntity abstractArrowEntity = arrowItem.func_200887_a(world, ammoStack, attacker);
        if (attacker instanceof PlayerEntity) {
            abstractArrowEntity.func_70243_d(true);
        }
        abstractArrowEntity.func_213869_a(SoundEvents.field_219609_bA);
        abstractArrowEntity.func_213865_o(true);
        abstractArrowEntity.func_184211_a("ChainReactionProjectile");
        Set originalArrowTags = originalArrow.func_184216_O();
        for (String tag : originalArrowTags) {
            abstractArrowEntity.func_184211_a(tag);
        }
        return abstractArrowEntity;
    }

    public static void fireChainReactionProjectiles(World world, LivingEntity attacker, LivingEntity victim, float v, float v1, AbstractArrowEntity originalArrow) {
        float[] randomSoundPitches = AbstractDungeonsCrossbowItem.getRandomSoundPitches(victim.func_70681_au());
        for (int i = 0; i < 4; ++i) {
            ItemStack currentProjectile = new ItemStack((IItemProvider)Items.field_151032_g);
            if (currentProjectile.func_190926_b()) continue;
            if (i == 0) {
                AbilityUtils.fireChainReactionProjectileFromVictim(world, attacker, victim, currentProjectile, randomSoundPitches[1], v, v1, 45.0f, originalArrow);
                continue;
            }
            if (i == 1) {
                AbilityUtils.fireChainReactionProjectileFromVictim(world, attacker, victim, currentProjectile, randomSoundPitches[2], v, v1, -45.0f, originalArrow);
                continue;
            }
            if (i == 2) {
                AbilityUtils.fireChainReactionProjectileFromVictim(world, attacker, victim, currentProjectile, randomSoundPitches[1], v, v1, 135.0f, originalArrow);
                continue;
            }
            if (i != 3) continue;
            AbilityUtils.fireChainReactionProjectileFromVictim(world, attacker, victim, currentProjectile, randomSoundPitches[2], v, v1, -135.0f, originalArrow);
        }
    }

    private static void fireChainReactionProjectileFromVictim(World world, LivingEntity attacker, LivingEntity victim, ItemStack projectileStack, float soundPitch, float v1, float v2, float centerOffset, AbstractArrowEntity originalArrow) {
        if (!world.field_72995_K) {
            AbstractArrowEntity projectile = AbilityUtils.createChainReactionProjectile(world, attacker, projectileStack, originalArrow);
            projectile.field_70251_a = AbstractArrowEntity.PickupStatus.CREATIVE_ONLY;
            Vec3d upVector = victim.func_213286_i(1.0f);
            Quaternion quaternion = new Quaternion(new Vector3f((float)upVector.func_82615_a(), (float)upVector.func_82617_b(), (float)upVector.func_82616_c()), centerOffset, true);
            Vec3d lookVector = victim.func_70676_i(1.0f);
            Vector3f vector3f = new Vector3f((float)lookVector.func_82615_a(), (float)lookVector.func_82617_b(), (float)lookVector.func_82616_c());
            vector3f.func_214905_a(quaternion);
            projectile.func_70186_c((double)vector3f.func_195899_a(), (double)vector3f.func_195900_b(), (double)vector3f.func_195902_c(), v1, v2);
            world.func_217376_c((Entity)projectile);
            world.func_184148_a((PlayerEntity)null, victim.func_226277_ct_(), victim.func_226278_cu_(), victim.func_226281_cx_(), SoundEvents.field_219616_bH, SoundCategory.PLAYERS, 1.0f, soundPitch);
        }
    }

    public static boolean soulsCriticalBoost(PlayerEntity attacker, ItemStack mainhand) {
        boolean uniqueWeaponFlag;
        int numSouls = Math.min(attacker.field_71067_cb, 50);
        boolean bl = uniqueWeaponFlag = mainhand.func_77973_b() == RangedWeaponList.FERAL_SOUL_CROSSBOW;
        if (EnchantUtils.hasEnchantment(mainhand, MeleeRangedEnchantmentList.ENIGMA_RESONATOR)) {
            float soulsCriticalBoostRand;
            int enigmaResonatorLevel = EnchantmentHelper.func_77506_a((Enchantment)MeleeRangedEnchantmentList.ENIGMA_RESONATOR, (ItemStack)mainhand);
            float soulsCriticalBoostChanceCap = 0.0f;
            if (enigmaResonatorLevel == 1) {
                soulsCriticalBoostChanceCap = 0.15f;
            }
            if (enigmaResonatorLevel == 2) {
                soulsCriticalBoostChanceCap = 0.2f;
            }
            if (enigmaResonatorLevel == 3) {
                soulsCriticalBoostChanceCap = 0.25f;
            }
            if ((double)(soulsCriticalBoostRand = attacker.func_70681_au().nextFloat()) <= Math.min((double)numSouls / 50.0, (double)soulsCriticalBoostChanceCap)) {
                return true;
            }
        }
        if (uniqueWeaponFlag) {
            float soulsCriticalBoostRand = attacker.func_70681_au().nextFloat();
            return (double)soulsCriticalBoostRand <= Math.min((double)numSouls / 50.0, (double)0.15f);
        }
        return false;
    }
}

