/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_gear.utilties;

import com.infamous.dungeons_gear.enchantments.lists.RangedEnchantmentList;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;

public class EnchantUtils {
    public static boolean hasEnchantment(ItemStack stack, Enchantment enchantment) {
        return enchantment != null && EnchantmentHelper.func_77506_a((Enchantment)enchantment, (ItemStack)stack) > 0;
    }

    public static boolean hasEnchantment(LivingEntity entity, Enchantment enchantment) {
        return enchantment != null && EnchantmentHelper.func_185284_a((Enchantment)enchantment, (LivingEntity)entity) > 0;
    }

    public static boolean shooterIsLiving(AbstractArrowEntity arrowEntity) {
        return arrowEntity.func_212360_k() != null && arrowEntity.func_212360_k() instanceof LivingEntity;
    }

    public static boolean arrowHitLivingEntity(RayTraceResult rayTraceResult) {
        if (rayTraceResult instanceof EntityRayTraceResult) {
            EntityRayTraceResult entityRayTraceResult = (EntityRayTraceResult)rayTraceResult;
            return entityRayTraceResult.func_216348_a() instanceof LivingEntity;
        }
        return false;
    }

    public static boolean arrowHitMob(RayTraceResult rayTraceResult) {
        if (rayTraceResult instanceof EntityRayTraceResult) {
            EntityRayTraceResult entityRayTraceResult = (EntityRayTraceResult)rayTraceResult;
            return entityRayTraceResult.func_216348_a() instanceof MobEntity;
        }
        return false;
    }

    public static void addEnchantmentTagsToArrow(ItemStack rangedWeapon, AbstractArrowEntity arrowEntity) {
        for (Enchantment enchantment : RangedEnchantmentList.rangedEnchantmentToStringMap.keySet()) {
            if (!EnchantUtils.hasEnchantment(rangedWeapon, enchantment)) continue;
            int enchantmentLevel = EnchantmentHelper.func_77506_a((Enchantment)enchantment, (ItemStack)rangedWeapon);
            String enchantmentTag = RangedEnchantmentList.rangedEnchantmentToStringMap.get(enchantment) + enchantmentLevel;
            arrowEntity.func_184211_a(enchantmentTag);
        }
    }

    public static boolean hasEnchantmentTag(AbstractArrowEntity arrowEntity, Enchantment enchantment) {
        String enchantmentAsString = RangedEnchantmentList.rangedEnchantmentToStringMap.get(enchantment);
        for (int i = 1; i < 4; ++i) {
            String enchantmentTag = enchantmentAsString + i;
            if (!arrowEntity.func_184216_O().contains(enchantmentTag)) continue;
            return true;
        }
        return false;
    }

    public static int enchantmentTagToLevel(AbstractArrowEntity arrowEntity, Enchantment enchantment) {
        String enchantmentAsString = RangedEnchantmentList.rangedEnchantmentToStringMap.get(enchantment);
        for (int i = 1; i < 4; ++i) {
            String enchantmentTag = enchantmentAsString + i;
            if (!arrowEntity.func_184216_O().contains(enchantmentTag)) continue;
            return i;
        }
        return 0;
    }
}

