/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_gear.utilties;

import com.google.common.collect.Lists;
import com.infamous.dungeons_gear.capabilities.weapon.IWeapon;
import com.infamous.dungeons_gear.capabilities.weapon.WeaponProvider;
import com.infamous.dungeons_gear.enchantments.lists.RangedEnchantmentList;
import com.infamous.dungeons_gear.items.RangedWeaponList;
import com.infamous.dungeons_gear.ranged.bows.AbstractDungeonsBowItem;
import com.infamous.dungeons_gear.ranged.crossbows.AbstractDungeonsCrossbowItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraftforge.common.util.LazyOptional;

public class RangedUtils {
    public static int getVanillaCrossbowChargeTime(ItemStack stack) {
        int quickChargeLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_222193_H, (ItemStack)stack);
        int accelerateLevel = EnchantmentHelper.func_77506_a((Enchantment)RangedEnchantmentList.ACCELERATE, (ItemStack)stack);
        IWeapon weaponCap = RangedUtils.getWeaponCapability(stack);
        if (weaponCap == null) {
            return Math.max(25 - 5 * quickChargeLevel, 0);
        }
        int crossbowChargeTime = weaponCap.getCrossbowChargeTime();
        long lastFiredTime = weaponCap.getLastFiredTime();
        if (accelerateLevel > 0 && lastFiredTime > 0L) {
            return Math.max(crossbowChargeTime - 5 * quickChargeLevel, 0);
        }
        return Math.max(25 - 5 * quickChargeLevel, 0);
    }

    public static IWeapon getWeaponCapability(ItemStack stack) {
        LazyOptional lazyCap = stack.getCapability(WeaponProvider.WEAPON_CAPABILITY);
        if (lazyCap.isPresent()) {
            return (IWeapon)lazyCap.orElseThrow(() -> new IllegalStateException("Couldn't get the capability from the ItemStack!"));
        }
        return null;
    }

    public static float getVanillaArrowVelocity(ItemStack stack, int charge) {
        float bowChargeTime = RangedUtils.getVanillaBowChargeTime(stack);
        if (bowChargeTime <= 0.0f) {
            bowChargeTime = 1.0f;
        }
        float arrowVelocity = (float)charge / bowChargeTime;
        if ((arrowVelocity = (arrowVelocity * arrowVelocity + arrowVelocity * 2.0f) / 3.0f) > 1.0f) {
            arrowVelocity = 1.0f;
        }
        return arrowVelocity;
    }

    public static float getVanillaBowChargeTime(ItemStack stack) {
        int quickChargeLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_222193_H, (ItemStack)stack);
        int accelerateLevel = EnchantmentHelper.func_77506_a((Enchantment)RangedEnchantmentList.ACCELERATE, (ItemStack)stack);
        IWeapon weaponCap = (IWeapon)stack.getCapability(WeaponProvider.WEAPON_CAPABILITY).orElseThrow(IllegalStateException::new);
        float bowChargeTime = weaponCap.getBowChargeTime();
        long lastFiredTime = weaponCap.getLastFiredTime();
        if (accelerateLevel > 0 && lastFiredTime > 0L) {
            return Math.max(bowChargeTime - (float)(5 * quickChargeLevel), 0.0f);
        }
        return Math.max(20.0f - (float)(5 * quickChargeLevel), 0.0f);
    }

    public static void addWeaponTags(AbstractArrowEntity arrowEntity, ItemStack stack) {
        if (stack.func_77973_b() == RangedWeaponList.BONEBOW) {
            arrowEntity.func_184211_a("Bonebow");
        }
        if (stack.func_77973_b() == RangedWeaponList.BOW_OF_LOST_SOULS) {
            arrowEntity.func_184211_a("BowOfLostSouls");
        }
        if (stack.func_77973_b() == RangedWeaponList.ELITE_POWER_BOW) {
            arrowEntity.func_184211_a("ElitePowerBow");
        }
        if (stack.func_77973_b() == RangedWeaponList.GUARDIAN_BOW) {
            arrowEntity.func_184211_a("GuardianBow");
        }
        if (stack.func_77973_b() == RangedWeaponList.HUNTERS_PROMISE) {
            arrowEntity.func_184211_a("HuntersPromise");
        }
        if (stack.func_77973_b() == RangedWeaponList.MASTERS_BOW) {
            arrowEntity.func_184211_a("MastersBow");
        }
        if (stack.func_77973_b() == RangedWeaponList.NOCTURNAL_BOW) {
            arrowEntity.func_184211_a("NocturnalBow");
        }
        if (stack.func_77973_b() == RangedWeaponList.RED_SNAKE) {
            arrowEntity.func_184211_a("RedSnake");
        }
        if (stack.func_77973_b() == RangedWeaponList.SABREWING) {
            arrowEntity.func_184211_a("Sabrewing");
        }
        if (stack.func_77973_b() == RangedWeaponList.THE_GREEN_MENACE) {
            arrowEntity.func_184211_a("TheGreenMenace");
        }
        if (stack.func_77973_b() == RangedWeaponList.THE_PINK_SCOUNDREL) {
            arrowEntity.func_184211_a("ThePinkScoundrel");
        }
        if (stack.func_77973_b() == RangedWeaponList.TWIN_BOW) {
            arrowEntity.func_184211_a("TwinBow");
        }
        if (stack.func_77973_b() == RangedWeaponList.HUNTING_BOW) {
            arrowEntity.func_184211_a("HuntingBow");
        }
        if (stack.func_77973_b() == RangedWeaponList.LONGBOW) {
            arrowEntity.func_184211_a("Longbow");
        }
        if (stack.func_77973_b() == RangedWeaponList.SHORTBOW) {
            arrowEntity.func_184211_a("Shortbow");
        }
        if (stack.func_77973_b() == RangedWeaponList.POWER_BOW) {
            arrowEntity.func_184211_a("PowerBow");
        }
        if (stack.func_77973_b() == RangedWeaponList.SOUL_BOW) {
            arrowEntity.func_184211_a("SoulBow");
        }
        if (stack.func_77973_b() == RangedWeaponList.TRICKBOW) {
            arrowEntity.func_184211_a("Trickbow");
        }
        if (stack.func_77973_b() == RangedWeaponList.SNOW_BOW) {
            arrowEntity.func_184211_a("SnowBow");
        }
        if (stack.func_77973_b() == RangedWeaponList.WINTERS_TOUCH) {
            arrowEntity.func_184211_a("WintersTouch");
        }
        if (stack.func_77973_b() == RangedWeaponList.AZURE_SEEKER) {
            arrowEntity.func_184211_a("AzureSeeker");
        }
        if (stack.func_77973_b() == RangedWeaponList.BUTTERFLY_CROSSBOW) {
            arrowEntity.func_184211_a("ButterflyCrossbow");
        }
        if (stack.func_77973_b() == RangedWeaponList.DOOM_CROSSBOW) {
            arrowEntity.func_184211_a("DoomCrossbow");
        }
        if (stack.func_77973_b() == RangedWeaponList.FERAL_SOUL_CROSSBOW) {
            arrowEntity.func_184211_a("FeralSoulCrossbow");
        }
        if (stack.func_77973_b() == RangedWeaponList.FIREBOLT_THROWER) {
            arrowEntity.func_184211_a("FireboltThrower");
        }
        if (stack.func_77973_b() == RangedWeaponList.HARP_CROSSBOW) {
            arrowEntity.func_184211_a("HarpCrossbow");
        }
        if (stack.func_77973_b() == RangedWeaponList.LIGHTNING_HARP_CROSSBOW) {
            arrowEntity.func_184211_a("LightningHarpCrossbow");
        }
        if (stack.func_77973_b() == RangedWeaponList.SLAYER_CROSSBOW) {
            arrowEntity.func_184211_a("SlayerCrossbow");
        }
        if (stack.func_77973_b() == RangedWeaponList.THE_SLICER) {
            arrowEntity.func_184211_a("TheSlicer");
        }
        if (stack.func_77973_b() == RangedWeaponList.VOIDCALLER) {
            arrowEntity.func_184211_a("Voidcaller");
        }
        if (stack.func_77973_b() == RangedWeaponList.DUAL_CROSSBOW) {
            arrowEntity.func_184211_a("DualCrossbow");
        }
        if (stack.func_77973_b() == RangedWeaponList.BABY_CROSSBOW) {
            arrowEntity.func_184211_a("BabyCrossbow");
        }
        if (stack.func_77973_b() == RangedWeaponList.EXPLODING_CROSSBOW) {
            arrowEntity.func_184211_a("ExplodingCrossbow");
        }
        if (stack.func_77973_b() == RangedWeaponList.HEAVY_CROSSBOW) {
            arrowEntity.func_184211_a("HeavyCrossbow");
        }
        if (stack.func_77973_b() == RangedWeaponList.RAPID_CROSSBOW) {
            arrowEntity.func_184211_a("RapidCrossbow");
        }
        if (stack.func_77973_b() == RangedWeaponList.SCATTER_CROSSBOW) {
            arrowEntity.func_184211_a("ScatterCrossbow");
        }
        if (stack.func_77973_b() == RangedWeaponList.SOUL_CROSSBOW) {
            arrowEntity.func_184211_a("SoulCrossbow");
        }
        if (stack.func_77973_b() == RangedWeaponList.IMPLODING_CROSSBOW) {
            arrowEntity.func_184211_a("ImplodingCrossbow");
        }
    }

    public static int getModdedCrossbowChargeTime(ItemStack stack) {
        int chargeTime = stack.func_77973_b() instanceof AbstractDungeonsCrossbowItem ? ((AbstractDungeonsCrossbowItem)stack.func_77973_b()).getCrossbowChargeTime(stack) : 25;
        return chargeTime;
    }

    public static float getModdedBowChargeTime(ItemStack stack) {
        float chargeTime = stack.func_77973_b() instanceof AbstractDungeonsBowItem ? ((AbstractDungeonsBowItem)stack.func_77973_b()).getBowChargeTime(stack) : 20.0f;
        return chargeTime;
    }

    public static float getvVanillaOrModdedCrossbowArrowVelocity(ItemStack stack) {
        float arrowVelocity = stack.func_77973_b() instanceof AbstractDungeonsCrossbowItem ? ((AbstractDungeonsCrossbowItem)stack.func_77973_b()).getProjectileVelocity(stack) : (RangedUtils.hasChargedProjectile(stack, Items.field_196152_dE) ? 1.6f : 3.15f);
        return arrowVelocity;
    }

    public static boolean hasChargedProjectile(ItemStack stack, Item ammoItem) {
        return RangedUtils.getChargedProjectiles(stack).stream().anyMatch(p_220010_1_ -> p_220010_1_.func_77973_b() == ammoItem);
    }

    public static List<ItemStack> getChargedProjectiles(ItemStack stack) {
        ListNBT listnbt;
        ArrayList list = Lists.newArrayList();
        CompoundNBT compoundnbt = stack.func_77978_p();
        if (compoundnbt != null && compoundnbt.func_150297_b("ChargedProjectiles", 9) && (listnbt = compoundnbt.func_150295_c("ChargedProjectiles", 10)) != null) {
            for (int i = 0; i < listnbt.size(); ++i) {
                CompoundNBT compoundnbt1 = listnbt.func_150305_b(i);
                list.add(ItemStack.func_199557_a((CompoundNBT)compoundnbt1));
            }
        }
        return list;
    }

    public static float getVanillaOrModdedBowArrowVelocity(ItemStack stack, int charge) {
        float arrowVelocity = stack.func_77973_b() instanceof AbstractDungeonsBowItem ? ((AbstractDungeonsBowItem)stack.func_77973_b()).getBowArrowVelocity(stack, charge) : RangedUtils.getVanillaArrowVelocity(stack, charge);
        return arrowVelocity;
    }
}

