/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_gear;

import com.infamous.dungeons_gear.artifacts.beacon.AbstractBeaconItem;
import com.infamous.dungeons_gear.artifacts.beacon.BeaconBeamRenderer;
import com.infamous.dungeons_gear.interfaces.IArmor;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="dungeons_gear", value={Dist.CLIENT})
public class ClientEvents {
    @SubscribeEvent
    public static void handleToolTip(ItemTooltipEvent event) {
        List tooltip = event.getToolTip();
        int index = 0;
        Item item = event.getItemStack().func_77973_b();
        if (item instanceof IArmor) {
            IArmor armor = (IArmor)item;
            for (int i = 0; i < tooltip.size(); ++i) {
                ITextComponent component = (ITextComponent)tooltip.get(i);
                if (!(component instanceof TranslationTextComponent) || !((TranslationTextComponent)component).func_150268_i().equals("attribute.modifier.plus.0")) continue;
                index = i;
            }
            if (armor.getArrowsPerBundle() > 0) {
                tooltip.add(index + 1, new TranslationTextComponent("+" + armor.getArrowsPerBundle() + " ").func_230529_a_((ITextComponent)new TranslationTextComponent("attribute.name.arrowsPerBundle")).func_240699_a_(TextFormatting.GREEN));
            }
            if (armor.getArtifactCooldown() > 0.0) {
                tooltip.add(index + 1, new TranslationTextComponent("-" + armor.getArtifactCooldown() + "% ").func_230529_a_((ITextComponent)new TranslationTextComponent("attribute.name.artifactCooldown")).func_240699_a_(TextFormatting.GREEN));
            }
            if (armor.getChanceToNegateHits() > 0.0) {
                tooltip.add(index + 1, new TranslationTextComponent("+" + armor.getChanceToNegateHits() + "% ").func_230529_a_((ITextComponent)new TranslationTextComponent("attribute.name.chanceToNegateHits")).func_240699_a_(TextFormatting.GREEN));
            }
            if (armor.getChanceToTeleportAwayWhenHit() > 0.0) {
                tooltip.add(index + 1, new TranslationTextComponent("+" + armor.getChanceToTeleportAwayWhenHit() + "% ").func_230529_a_((ITextComponent)new TranslationTextComponent("attribute.name.chanceToTeleportAwayWhenHit")).func_240699_a_(TextFormatting.GREEN));
            }
            if (armor.getFreezingResistance() > 0.0) {
                tooltip.add(index + 1, new TranslationTextComponent("+" + armor.getFreezingResistance() + "% ").func_230529_a_((ITextComponent)new TranslationTextComponent("attribute.name.freezingResistance")).func_240699_a_(TextFormatting.GREEN));
            }
            if (armor.getHealthPotionBoost() > 0.0) {
                tooltip.add(index + 1, new TranslationTextComponent("+" + armor.getHealthPotionBoost() + " ").func_230529_a_((ITextComponent)new TranslationTextComponent("attribute.name.healthPotionBoost")).func_240699_a_(TextFormatting.GREEN));
            }
            if (armor.getHigherJumps() > 0.0) {
                tooltip.add(index + 1, new TranslationTextComponent("+" + armor.getHigherJumps() + "% ").func_230529_a_((ITextComponent)new TranslationTextComponent("attribute.name.higherJumps")).func_240699_a_(TextFormatting.GREEN));
            }
            if (armor.getLongerJumpAbilityCooldown() > 0.0) {
                tooltip.add(index + 1, new TranslationTextComponent("+" + armor.getLongerJumpAbilityCooldown() + "% ").func_230529_a_((ITextComponent)new TranslationTextComponent("attribute.name.longerJumpAbilityCooldown")).func_240699_a_(TextFormatting.RED));
            }
            if (armor.getLifeSteal() > 0.0) {
                tooltip.add(index + 1, new TranslationTextComponent("+" + armor.getLifeSteal() + "% ").func_230529_a_((ITextComponent)new TranslationTextComponent("attribute.name.lifeSteal")).func_240699_a_(TextFormatting.GREEN));
            }
            if (armor.getMagicDamage() > 0.0) {
                tooltip.add(index + 1, new TranslationTextComponent("+" + armor.getMagicDamage() + "% ").func_230529_a_((ITextComponent)new TranslationTextComponent("attribute.name.magicDamage")).func_240699_a_(TextFormatting.GREEN));
            }
            if (armor.getRangedDamage() > 0.0) {
                tooltip.add(index + 1, new TranslationTextComponent("+" + armor.getRangedDamage() + "% ").func_230529_a_((ITextComponent)new TranslationTextComponent("attribute.name.rangedDamage")).func_240699_a_(TextFormatting.GREEN));
            }
            if (armor.getSoulsGathered() > 0.0) {
                tooltip.add(index + 1, new TranslationTextComponent("+" + armor.getSoulsGathered() + "% ").func_230529_a_((ITextComponent)new TranslationTextComponent("attribute.name.soulsGathered")).func_240699_a_(TextFormatting.LIGHT_PURPLE));
            }
        }
    }

    @SubscribeEvent
    public static void renderWorldLastEvent(RenderWorldLastEvent event) {
        List players = null;
        if (Minecraft.func_71410_x().field_71441_e != null) {
            players = Minecraft.func_71410_x().field_71441_e.func_217369_A();
            ClientPlayerEntity myplayer = Minecraft.func_71410_x().field_71439_g;
            if (myplayer != null) {
                for (PlayerEntity player : players) {
                    if (player.func_70068_e((Entity)myplayer) > 500.0) continue;
                    ItemStack heldItem = AbstractBeaconItem.getBeacon(player);
                    if (!player.func_184587_cr() || !(heldItem.func_77973_b() instanceof AbstractBeaconItem) || !AbstractBeaconItem.canFire(player)) continue;
                    BeaconBeamRenderer.renderBeam(event, player, Minecraft.func_71410_x().func_184121_ak());
                }
            }
        }
    }
}

