/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_gear;

import com.infamous.dungeons_gear.DungeonsGear;
import com.infamous.dungeons_gear.capabilities.combo.ICombo;
import com.infamous.dungeons_gear.capabilities.weapon.IWeapon;
import com.infamous.dungeons_gear.effects.CustomEffects;
import com.infamous.dungeons_gear.enchantments.lists.RangedEnchantmentList;
import com.infamous.dungeons_gear.init.DeferredItemInit;
import com.infamous.dungeons_gear.init.PotionList;
import com.infamous.dungeons_gear.interfaces.IArmor;
import com.infamous.dungeons_gear.interfaces.ISoulGatherer;
import com.infamous.dungeons_gear.utilties.CapabilityHelper;
import com.infamous.dungeons_gear.utilties.ModEnchantmentHelper;
import com.infamous.dungeons_gear.utilties.ProjectileEffectHelper;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.BowItem;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effects;
import net.minecraft.potion.PotionUtils;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="dungeons_gear")
public class GlobalEvents {
    @SubscribeEvent
    public static void onArrowJoinWorld(EntityJoinWorldEvent event) {
        AbstractArrowEntity arrowEntity;
        Entity shooterEntity;
        if (event.getEntity() instanceof AbstractArrowEntity && (shooterEntity = (arrowEntity = (AbstractArrowEntity)event.getEntity()).func_234616_v_()) instanceof LivingEntity) {
            LivingEntity shooter = (LivingEntity)shooterEntity;
            ItemStack mainhandStack = shooter.func_184614_ca();
            ItemStack offhandStack = shooter.func_184592_cb();
            if (mainhandStack.func_77973_b() instanceof BowItem || mainhandStack.func_77973_b() instanceof CrossbowItem) {
                GlobalEvents.handleRangedEnchantments(arrowEntity, shooter, mainhandStack);
            } else if (offhandStack.func_77973_b() instanceof BowItem || offhandStack.func_77973_b() instanceof CrossbowItem) {
                GlobalEvents.handleRangedEnchantments(arrowEntity, shooter, offhandStack);
            }
        }
    }

    private static void handleRangedEnchantments(AbstractArrowEntity arrowEntity, LivingEntity shooter, ItemStack stack) {
        PlayerEntity playerEntity;
        boolean soulsCriticalBoost;
        ModEnchantmentHelper.addEnchantmentTagsToArrow(stack, arrowEntity);
        int fuseShotLevel = EnchantmentHelper.func_77506_a((Enchantment)RangedEnchantmentList.FUSE_SHOT, (ItemStack)stack);
        if (stack.func_77973_b() == DeferredItemInit.RED_SNAKE.get()) {
            ++fuseShotLevel;
        }
        if (fuseShotLevel > 0) {
            IWeapon weaponCap = CapabilityHelper.getWeaponCapability(stack);
            if (weaponCap == null) {
                return;
            }
            int fuseShotCounter = weaponCap.getFuseShotCounter();
            if (fuseShotCounter == 6 - fuseShotLevel - 1) {
                arrowEntity.func_184211_a("FuseShot");
                weaponCap.setFuseShotCounter(0);
            } else {
                weaponCap.setFuseShotCounter(fuseShotCounter + 1);
            }
        }
        if (shooter instanceof PlayerEntity && (soulsCriticalBoost = ProjectileEffectHelper.soulsCriticalBoost(playerEntity = (PlayerEntity)shooter, stack))) {
            DungeonsGear.PROXY.spawnParticles((Entity)playerEntity, ParticleTypes.field_239812_C_);
            arrowEntity.func_70243_d(true);
            arrowEntity.func_70239_b(arrowEntity.func_70242_d() * 2.0);
        }
    }

    @SubscribeEvent
    public static void onCancelAttackBecauseStunned(LivingAttackEvent event) {
        PlayerEntity attacker;
        if (event.getSource().func_76346_g() instanceof PlayerEntity && (attacker = (PlayerEntity)event.getSource().func_76346_g()).func_70660_b(CustomEffects.STUNNED) != null) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onStunnedMob(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() instanceof MobEntity) {
            MobEntity mobEntity = (MobEntity)event.getEntityLiving();
            if (mobEntity.func_70660_b(CustomEffects.STUNNED) != null && !mobEntity.func_184216_O().contains("Stunned")) {
                if (!mobEntity.func_175446_cd()) {
                    mobEntity.func_94061_f(true);
                    mobEntity.func_184211_a("Stunned");
                }
            } else if (mobEntity.func_175446_cd() && mobEntity.func_184216_O().contains("Stunned")) {
                mobEntity.func_94061_f(false);
                mobEntity.func_184197_b("Stunned");
            }
        }
    }

    @SubscribeEvent
    public static void onCapabilityAttack(LivingDamageEvent event) {
        if (event.getSource().func_76346_g() instanceof PlayerEntity) {
            PlayerEntity playerEntity = (PlayerEntity)event.getSource().func_76346_g();
            ICombo comboCap = CapabilityHelper.getComboCapability((Entity)playerEntity);
            if (comboCap == null) {
                return;
            }
            if (comboCap.getShadowForm()) {
                float originalDamage = event.getAmount();
                event.setAmount(originalDamage * 2.0f);
                comboCap.setShadowForm(false);
                playerEntity.func_195063_d(Effects.field_76441_p);
            }
            if (comboCap.getDynamoMultiplier() > 1.0) {
                double dynamoMultiplier = comboCap.getDynamoMultiplier();
                float originalDamage = event.getAmount();
                event.setAmount((float)((double)originalDamage * dynamoMultiplier));
                comboCap.setDynamoMultiplier(1.0);
            }
        }
    }

    @SubscribeEvent
    public static void onShadowFormAdded(LivingEntityUseItemEvent.Finish event) {
        if (PotionUtils.func_185191_c((ItemStack)event.getItem()) == PotionList.SHADOW_BREW && event.getEntityLiving() instanceof PlayerEntity) {
            PlayerEntity playerEntity = (PlayerEntity)event.getEntityLiving();
            ICombo comboCap = CapabilityHelper.getComboCapability((Entity)playerEntity);
            if (comboCap == null) {
                return;
            }
            comboCap.setShadowForm(true);
        }
    }

    @SubscribeEvent
    public static void onShadowFormRemoved(PotionEvent.PotionRemoveEvent event) {
        if (event.getPotion() == Effects.field_76441_p && event.getEntityLiving() instanceof PlayerEntity) {
            PlayerEntity playerEntity = (PlayerEntity)event.getEntityLiving();
            ICombo comboCap = CapabilityHelper.getComboCapability((Entity)playerEntity);
            if (comboCap == null) {
                return;
            }
            comboCap.setShadowForm(false);
        }
    }

    @SubscribeEvent
    public static void onSoulGatheringItemsXPDrop(LivingExperienceDropEvent event) {
        if (event.getAttackingPlayer() != null) {
            float soulsGathered2;
            PlayerEntity attacker = event.getAttackingPlayer();
            int originalExperience = event.getDroppedExperience();
            int additionalExperienceCounter = 0;
            ItemStack mainhand = attacker.func_184614_ca();
            ItemStack offhand = attacker.func_184592_cb();
            if (mainhand.func_77973_b() instanceof ISoulGatherer) {
                additionalExperienceCounter += ((ISoulGatherer)mainhand.func_77973_b()).getGatherAmount(mainhand);
            }
            if (offhand.func_77973_b() instanceof ISoulGatherer) {
                additionalExperienceCounter += ((ISoulGatherer)offhand.func_77973_b()).getGatherAmount(offhand);
            }
            ItemStack helmet = attacker.func_184582_a(EquipmentSlotType.HEAD);
            ItemStack chestplate = attacker.func_184582_a(EquipmentSlotType.CHEST);
            float soulsGathered = helmet.func_77973_b() instanceof IArmor ? (float)((IArmor)helmet.func_77973_b()).getSoulsGathered() : 0.0f;
            float totalSoulsGathered = soulsGathered * 0.01f + (soulsGathered2 = chestplate.func_77973_b() instanceof IArmor ? (float)((IArmor)chestplate.func_77973_b()).getSoulsGathered() : 0.0f) * 0.01f;
            if (totalSoulsGathered > 0.0f) {
                additionalExperienceCounter = (int)((float)additionalExperienceCounter + (float)originalExperience * totalSoulsGathered);
            }
            event.setDroppedExperience(originalExperience + additionalExperienceCounter);
        }
    }
}

