/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_gear.armor;

import com.infamous.dungeons_gear.armor.GrimArmorItem;
import com.infamous.dungeons_gear.capabilities.combo.ICombo;
import com.infamous.dungeons_gear.capabilities.summoning.ISummonable;
import com.infamous.dungeons_gear.capabilities.summoning.ISummoner;
import com.infamous.dungeons_gear.enchantments.lists.ArmorEnchantmentList;
import com.infamous.dungeons_gear.enchantments.lists.MeleeRangedEnchantmentList;
import com.infamous.dungeons_gear.goals.BeeFollowOwnerGoal;
import com.infamous.dungeons_gear.goals.BeeOwnerHurtByTargetGoal;
import com.infamous.dungeons_gear.goals.BeeOwnerHurtTargetGoal;
import com.infamous.dungeons_gear.init.DeferredItemInit;
import com.infamous.dungeons_gear.interfaces.IArmor;
import com.infamous.dungeons_gear.utilties.AreaOfEffectHelper;
import com.infamous.dungeons_gear.utilties.ArmorEffectHelper;
import com.infamous.dungeons_gear.utilties.CapabilityHelper;
import com.infamous.dungeons_gear.utilties.ModEnchantmentHelper;
import java.util.Collection;
import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

@Mod.EventBusSubscriber(modid="dungeons_gear")
public class ArmorEvents {
    @SubscribeEvent
    public static void onSpelunkerArmorEquipped(LivingEquipmentChangeEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity) {
            PlayerEntity playerEntity = (PlayerEntity)event.getEntityLiving();
            World world = playerEntity.func_130014_f_();
            if (event.getTo().func_77973_b() instanceof IArmor && ((IArmor)event.getTo().func_77973_b()).doGivesYouAPetBat()) {
                ArmorEffectHelper.summonOrTeleportBat(playerEntity, world);
            }
        }
    }

    @SubscribeEvent
    public static void onDamageInvolvingSpecialArmor(LivingDamageEvent event) {
        ItemStack chestplate;
        ItemStack helmet;
        if (event.getSource() instanceof IndirectEntityDamageSource && event.getSource().func_76346_g() instanceof LivingEntity) {
            float originalDamage = event.getAmount();
            LivingEntity attacker = (LivingEntity)event.getSource().func_76346_g();
            ItemStack helmet2 = attacker.func_184582_a(EquipmentSlotType.HEAD);
            ItemStack chestplate2 = attacker.func_184582_a(EquipmentSlotType.CHEST);
            if (event.getSource().func_76364_f() instanceof AbstractArrowEntity) {
                ArmorEvents.increaseEventRangedDamage(event, originalDamage, helmet2, chestplate2);
            } else if (event.getSource().func_82725_o()) {
                ArmorEvents.increaseEventMagicDamage(event, originalDamage, helmet2, chestplate2);
            }
        }
        if (event.getSource().func_76346_g() instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)event.getSource().func_76346_g();
            helmet = attacker.func_184582_a(EquipmentSlotType.HEAD);
            chestplate = attacker.func_184582_a(EquipmentSlotType.CHEST);
            float damageAmount = event.getAmount();
            ArmorEvents.handleLifeSteal(damageAmount, attacker, helmet, chestplate);
        }
        LivingEntity victim = event.getEntityLiving();
        helmet = victim.func_184582_a(EquipmentSlotType.HEAD);
        chestplate = victim.func_184582_a(EquipmentSlotType.CHEST);
        ArmorEvents.handleNegateHit(event, victim, helmet, chestplate);
        ArmorEvents.handleTeleportOnHit(victim, helmet, chestplate);
    }

    private static void handleLifeSteal(float damageAmount, LivingEntity attacker, ItemStack helmet, ItemStack chestplate) {
        float lifeSteal = helmet.func_77973_b() instanceof IArmor ? (float)((IArmor)helmet.func_77973_b()).getChanceToTeleportAwayWhenHit() : 0.0f;
        float lifeSteal2 = chestplate.func_77973_b() instanceof IArmor ? (float)((IArmor)chestplate.func_77973_b()).getChanceToTeleportAwayWhenHit() : 0.0f;
        float totalLifeSteal = lifeSteal * 0.01f + lifeSteal2 * 0.01f;
        attacker.func_70691_i(damageAmount * totalLifeSteal);
    }

    private static void handleTeleportOnHit(LivingEntity victim, ItemStack helmet, ItemStack chestplate) {
        float teleportChance = helmet.func_77973_b() instanceof IArmor ? (float)((IArmor)helmet.func_77973_b()).getChanceToTeleportAwayWhenHit() : 0.0f;
        float teleportChance2 = chestplate.func_77973_b() instanceof IArmor ? (float)((IArmor)chestplate.func_77973_b()).getChanceToTeleportAwayWhenHit() : 0.0f;
        float totalTeleportChance = teleportChance * 0.01f + teleportChance2 * 0.01f;
        float teleportRand = victim.func_70681_au().nextFloat();
        if (teleportRand <= totalTeleportChance) {
            ArmorEffectHelper.teleportOnHit(victim);
        }
    }

    private static void handleNegateHit(LivingDamageEvent event, LivingEntity victim, ItemStack helmet, ItemStack chestplate) {
        float negateHitChance = helmet.func_77973_b() instanceof IArmor ? (float)((IArmor)helmet.func_77973_b()).getChanceToNegateHits() : 0.0f;
        float negateHitChance2 = chestplate.func_77973_b() instanceof IArmor ? (float)((IArmor)chestplate.func_77973_b()).getChanceToNegateHits() : 0.0f;
        float totalNegateHitChance = negateHitChance * 0.01f + negateHitChance2 * 0.01f;
        float negateHitRand = victim.func_70681_au().nextFloat();
        if (negateHitRand <= totalNegateHitChance) {
            event.setCanceled(true);
        }
    }

    private static void increaseEventMagicDamage(LivingDamageEvent event, float originalDamage, ItemStack helmet, ItemStack chestplate) {
        float magicDamage2;
        float magicDamage = helmet.func_77973_b() instanceof IArmor ? (float)((IArmor)helmet.func_77973_b()).getMagicDamage() : 0.0f;
        float damageMultiplier = magicDamage * 0.01f + (magicDamage2 = chestplate.func_77973_b() instanceof IArmor ? (float)((IArmor)chestplate.func_77973_b()).getMagicDamage() : 0.0f) * 0.01f;
        float additionalDamage = originalDamage * damageMultiplier;
        if (additionalDamage > 0.0f) {
            event.setAmount(originalDamage + additionalDamage);
        }
    }

    private static void increaseEventRangedDamage(LivingDamageEvent event, float originalDamage, ItemStack helmet, ItemStack chestplate) {
        float rangedDamage2;
        float rangedDamage = helmet.func_77973_b() instanceof IArmor ? (float)((IArmor)helmet.func_77973_b()).getRangedDamage() : 0.0f;
        float damageMultiplier = rangedDamage * 0.01f + (rangedDamage2 = chestplate.func_77973_b() instanceof IArmor ? (float)((IArmor)chestplate.func_77973_b()).getRangedDamage() : 0.0f) * 0.01f;
        float additionalDamage = originalDamage * damageMultiplier;
        if (additionalDamage > 0.0f) {
            event.setAmount(originalDamage + additionalDamage);
        }
    }

    @SubscribeEvent
    public static void onFreezingApplied(PotionEvent.PotionAddedEvent event) {
        EffectInstance effectInstance = event.getPotionEffect();
        LivingEntity livingEntity = event.getEntityLiving();
        ItemStack helmet = livingEntity.func_184582_a(EquipmentSlotType.HEAD);
        ItemStack chestplate = livingEntity.func_184582_a(EquipmentSlotType.CHEST);
        ArmorEvents.reduceFreezingEffect(event, effectInstance, helmet, chestplate);
    }

    private static void reduceFreezingEffect(PotionEvent.PotionAddedEvent event, EffectInstance effectInstance, ItemStack helmet, ItemStack chestplate) {
        float freezingResistance2;
        float freezingResistance = helmet.func_77973_b() instanceof IArmor ? (float)((IArmor)helmet.func_77973_b()).getFreezingResistance() : 0.0f;
        float freezingMultiplier = freezingResistance * 0.01f + (freezingResistance2 = chestplate.func_77973_b() instanceof IArmor ? (float)((IArmor)chestplate.func_77973_b()).getFreezingResistance() : 0.0f) * 0.01f;
        if (freezingMultiplier > 0.0f && (event.getPotionEffect().func_188419_a() == Effects.field_76421_d || event.getPotionEffect().func_188419_a() == Effects.field_76419_f)) {
            int oldDuration = effectInstance.func_76459_b();
            ObfuscationReflectionHelper.setPrivateValue(EffectInstance.class, (Object)effectInstance, (Object)((int)((float)oldDuration * freezingMultiplier)), (String)"field_76460_b");
        }
    }

    @SubscribeEvent
    public static void onEntityKilled(LivingDeathEvent event) {
        if (event.getSource().func_76346_g() instanceof LivingEntity) {
            boolean lifeStealChestplateFlag;
            LivingEntity attacker = (LivingEntity)event.getSource().func_76346_g();
            ItemStack chestplate = attacker.func_184582_a(EquipmentSlotType.CHEST);
            boolean bl = lifeStealChestplateFlag = chestplate.func_77973_b() == DeferredItemInit.SPIDER_ARMOR.get() || chestplate.func_77973_b() instanceof GrimArmorItem;
            if (lifeStealChestplateFlag) {
                float victimMaxHealth = event.getEntityLiving().func_110138_aP();
                if (attacker.func_110143_aJ() < attacker.func_110138_aP()) {
                    attacker.func_70691_i(victimMaxHealth * 0.03f);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onHealthPotionConsumed(LivingEntityUseItemEvent.Finish event) {
        if (!(event.getEntityLiving() instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)event.getEntityLiving();
        if (player.func_70089_S()) {
            List potionEffects = PotionUtils.func_185189_a((ItemStack)event.getItem());
            if (potionEffects.isEmpty()) {
                return;
            }
            ItemStack helmet = player.func_184582_a(EquipmentSlotType.HEAD);
            ItemStack chestplate = player.func_184582_a(EquipmentSlotType.CHEST);
            if (((EffectInstance)potionEffects.get(0)).func_188419_a() == Effects.field_76432_h) {
                EffectInstance instantHealth = (EffectInstance)potionEffects.get(0);
                ArmorEvents.handleHealthPotionBoost(player, helmet, chestplate);
                ArmorEvents.handleHealNearbyAllies(player, instantHealth, helmet, chestplate);
            }
        }
    }

    private static void handleHealNearbyAllies(PlayerEntity player, EffectInstance instantHealth, ItemStack helmet, ItemStack chestplate) {
        boolean healNearbyAllies;
        boolean doHealthPotionsHealNearbyAllies = helmet.func_77973_b() instanceof IArmor && ((IArmor)helmet.func_77973_b()).doHealthPotionsHealNearbyAllies();
        boolean doHealthPotionsHealNearbyAllies2 = chestplate.func_77973_b() instanceof IArmor && ((IArmor)chestplate.func_77973_b()).doHealthPotionsHealNearbyAllies();
        boolean bl = healNearbyAllies = doHealthPotionsHealNearbyAllies || doHealthPotionsHealNearbyAllies2;
        if (healNearbyAllies) {
            AreaOfEffectHelper.healNearbyAllies((LivingEntity)player, instantHealth, 12.0f);
        }
    }

    private static void handleHealthPotionBoost(PlayerEntity player, ItemStack helmet, ItemStack chestplate) {
        float healthPotionBoost2;
        float healthPotionBoost = helmet.func_77973_b() instanceof IArmor ? (float)((IArmor)helmet.func_77973_b()).getHealthPotionBoost() : 0.0f;
        float totalhealthPotionBoost = healthPotionBoost + (healthPotionBoost2 = chestplate.func_77973_b() instanceof IArmor ? (float)((IArmor)chestplate.func_77973_b()).getHealthPotionBoost() : 0.0f);
        if (totalhealthPotionBoost > 0.0f) {
            player.func_195064_c(new EffectInstance(Effects.field_76432_h, 1, (int)totalhealthPotionBoost - 1));
        }
    }

    @SubscribeEvent
    public static void onArrowDrop(LivingDropsEvent event) {
        if (event.getSource().func_76346_g() instanceof LivingEntity) {
            int arrowDrops2;
            LivingEntity attacker = (LivingEntity)event.getSource().func_76346_g();
            LivingEntity victim = event.getEntityLiving();
            ItemStack helmet = attacker.func_184582_a(EquipmentSlotType.HEAD);
            ItemStack chestplate = attacker.func_184582_a(EquipmentSlotType.CHEST);
            int arrowDrops = helmet.func_77973_b() instanceof IArmor ? ((IArmor)helmet.func_77973_b()).getArrowsPerBundle() : 0;
            int totalarrowDrops = arrowDrops + (arrowDrops2 = chestplate.func_77973_b() instanceof IArmor ? ((IArmor)chestplate.func_77973_b()).getArrowsPerBundle() : 0);
            if (totalarrowDrops > 0) {
                Collection itemEntities = event.getDrops();
                if (victim instanceof IMob && attacker.func_70681_au().nextFloat() <= 0.5f) {
                    ItemEntity arrowDrop = new ItemEntity(victim.field_70170_p, victim.func_226277_ct_(), victim.func_226278_cu_(), victim.func_226281_cx_(), new ItemStack((IItemProvider)Items.field_151032_g, totalarrowDrops));
                    itemEntities.add(arrowDrop);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        PlayerEntity player = event.player;
        if (player == null) {
            return;
        }
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        if (player.func_70089_S()) {
            ICombo comboCap = CapabilityHelper.getComboCapability((Entity)player);
            if (comboCap == null) {
                return;
            }
            int jumpCooldownTimer = comboCap.getJumpCooldownTimer();
            if (jumpCooldownTimer > 0) {
                comboCap.setJumpCooldownTimer(jumpCooldownTimer - 1);
            }
        }
    }

    @SubscribeEvent
    public static void handleJumpAbilities(LivingEvent.LivingJumpEvent event) {
        LivingEntity livingEntity = event.getEntityLiving();
        if (livingEntity instanceof PlayerEntity) {
            PlayerEntity playerEntity = (PlayerEntity)livingEntity;
            ItemStack helmet = playerEntity.func_184582_a(EquipmentSlotType.HEAD);
            ItemStack chestplate = playerEntity.func_184582_a(EquipmentSlotType.CHEST);
            ICombo comboCap = CapabilityHelper.getComboCapability((Entity)playerEntity);
            if (comboCap == null) {
                return;
            }
            int jumpCooldownTimer = comboCap.getJumpCooldownTimer();
            if (jumpCooldownTimer <= 0) {
                ArmorEvents.handleJumpBoost(playerEntity, helmet, chestplate);
                ArmorEvents.handleInvulnerableJump(playerEntity, helmet, chestplate);
                ArmorEvents.handleJumpEnchantments(playerEntity, helmet, chestplate);
            }
            float jumpCooldown = helmet.func_77973_b() instanceof IArmor ? (float)((IArmor)helmet.func_77973_b()).getLongerJumpAbilityCooldown() : 0.0f;
            float jumpCooldown2 = chestplate.func_77973_b() instanceof IArmor ? (float)((IArmor)chestplate.func_77973_b()).getLongerJumpAbilityCooldown() : 0.0f;
            float totalJumpCooldown = jumpCooldown * 0.01f + jumpCooldown2 * 0.01f;
            int jumpCooldownTimerLength = totalJumpCooldown > 0.0f ? 60 + (int)(60.0f * totalJumpCooldown) : 60;
            comboCap.setJumpCooldownTimer(jumpCooldownTimerLength);
        }
    }

    private static void handleJumpEnchantments(PlayerEntity playerEntity, ItemStack helmet, ItemStack chestplate) {
        boolean highlandArmorFlag;
        if (ModEnchantmentHelper.hasEnchantment((LivingEntity)playerEntity, ArmorEnchantmentList.ELECTRIFIED)) {
            AreaOfEffectHelper.electrifyNearbyEnemies((LivingEntity)playerEntity, 5.0f, 5.0f, 3);
        }
        if (ModEnchantmentHelper.hasEnchantment((LivingEntity)playerEntity, ArmorEnchantmentList.FIRE_TRAIL)) {
            int fireTrailLevel = EnchantmentHelper.func_185284_a((Enchantment)ArmorEnchantmentList.FIRE_TRAIL, (LivingEntity)playerEntity);
            AreaOfEffectHelper.burnNearbyEnemies((LivingEntity)playerEntity, 1.0f * (float)fireTrailLevel, 1.5f);
        }
        if (ModEnchantmentHelper.hasEnchantment((LivingEntity)playerEntity, ArmorEnchantmentList.TUMBLEBEE)) {
            int tumblebeeLevel = EnchantmentHelper.func_185284_a((Enchantment)ArmorEnchantmentList.TUMBLEBEE, (LivingEntity)playerEntity);
            float tumblebeeRand = playerEntity.func_70681_au().nextFloat();
            if (tumblebeeRand <= 0.333f * (float)tumblebeeLevel) {
                ArmorEvents.summonTumblebeeBee(playerEntity);
            }
        }
        boolean bl = highlandArmorFlag = chestplate.func_77973_b() == DeferredItemInit.HIGHLAND_ARMOR.get() || helmet.func_77973_b() == DeferredItemInit.HIGHLAND_ARMOR_HELMET.get();
        if (ModEnchantmentHelper.hasEnchantment((LivingEntity)playerEntity, ArmorEnchantmentList.SWIFTFOOTED) || highlandArmorFlag) {
            int swiftfootedLevel = EnchantmentHelper.func_185284_a((Enchantment)ArmorEnchantmentList.SWIFTFOOTED, (LivingEntity)playerEntity);
            if (highlandArmorFlag) {
                ++swiftfootedLevel;
            }
            EffectInstance speedBoost = new EffectInstance(Effects.field_76424_c, 60, swiftfootedLevel - 1);
            playerEntity.func_195064_c(speedBoost);
        }
        ArmorEvents.handleDynamoEnchantment(playerEntity);
    }

    private static void handleDynamoEnchantment(PlayerEntity playerEntity) {
        boolean uniqueWeaponFlag;
        ItemStack mainhand = playerEntity.func_184614_ca();
        boolean bl = uniqueWeaponFlag = mainhand.func_77973_b() == DeferredItemInit.GREAT_AXEBLADE.get() || mainhand.func_77973_b() == DeferredItemInit.ANCIENT_BOW.get() || mainhand.func_77973_b() == DeferredItemInit.CORRUPTED_CROSSBOW.get();
        if (ModEnchantmentHelper.hasEnchantment(mainhand, MeleeRangedEnchantmentList.DYNAMO) || uniqueWeaponFlag) {
            ICombo comboCap;
            int dynamoLevel = EnchantmentHelper.func_77506_a((Enchantment)MeleeRangedEnchantmentList.DYNAMO, (ItemStack)mainhand);
            if (uniqueWeaponFlag) {
                ++dynamoLevel;
            }
            if ((comboCap = CapabilityHelper.getComboCapability((Entity)playerEntity)) == null) {
                return;
            }
            double originalDynamoMultiplier = comboCap.getDynamoMultiplier();
            double dynamoModifier = 1.0 + 0.5 * (double)Math.max(dynamoLevel - 1, 0);
            comboCap.setDynamoMultiplier(originalDynamoMultiplier + dynamoModifier);
        }
    }

    private static void summonTumblebeeBee(PlayerEntity playerEntity) {
        ISummoner summonerCap = CapabilityHelper.getSummonerCapability((Entity)playerEntity);
        if (summonerCap == null) {
            return;
        }
        BeeEntity beeEntity = (BeeEntity)EntityType.field_226289_e_.func_200721_a(playerEntity.field_70170_p);
        if (beeEntity != null) {
            ISummonable summonable = CapabilityHelper.getSummonableCapability((Entity)beeEntity);
            if (summonable != null && summonerCap.addTumblebeeBee(beeEntity.func_110124_au())) {
                summonable.setSummoner(playerEntity.func_110124_au());
                ArmorEvents.createBee(playerEntity, beeEntity);
            } else {
                beeEntity.func_70106_y();
            }
        }
    }

    private static void createBee(PlayerEntity playerEntity, BeeEntity beeEntity) {
        beeEntity.func_70012_b(playerEntity.func_226277_ct_() + 0.5, playerEntity.func_226278_cu_() + 0.05, playerEntity.func_226281_cx_() + 0.5, 0.0f, 0.0f);
        beeEntity.field_70714_bg.func_75776_a(2, (Goal)new BeeFollowOwnerGoal(beeEntity, 2.1, 10.0f, 2.0f, false));
        beeEntity.field_70715_bh.func_75776_a(1, (Goal)new BeeOwnerHurtByTargetGoal(beeEntity));
        beeEntity.field_70715_bh.func_75776_a(2, (Goal)new BeeOwnerHurtTargetGoal(beeEntity));
        beeEntity.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)beeEntity, LivingEntity.class, 5, false, false, entityIterator -> entityIterator instanceof IMob && !(entityIterator instanceof CreeperEntity)));
        playerEntity.field_70170_p.func_184148_a((PlayerEntity)null, playerEntity.func_226277_ct_(), playerEntity.func_226278_cu_(), playerEntity.func_226281_cx_(), SoundEvents.field_226127_ab_, SoundCategory.AMBIENT, 64.0f, 1.0f);
        playerEntity.field_70170_p.func_217376_c((Entity)beeEntity);
    }

    private static void handleInvulnerableJump(PlayerEntity playerEntity, ItemStack helmet, ItemStack chestplate) {
        boolean doInvulnerableJump;
        boolean invulnerableJump = helmet.func_77973_b() instanceof IArmor && ((IArmor)helmet.func_77973_b()).doBriefInvulnerabilityWhenJumping();
        boolean invulnerableJump2 = chestplate.func_77973_b() instanceof IArmor && ((IArmor)chestplate.func_77973_b()).doBriefInvulnerabilityWhenJumping();
        boolean bl = doInvulnerableJump = invulnerableJump || invulnerableJump2;
        if (doInvulnerableJump) {
            EffectInstance resistance = new EffectInstance(Effects.field_76429_m, 20, 4);
            playerEntity.func_195064_c(resistance);
        }
    }

    private static void handleJumpBoost(PlayerEntity playerEntity, ItemStack helmet, ItemStack chestplate) {
        float jumpBoost2;
        float jumpBoost = helmet.func_77973_b() instanceof IArmor ? (float)((IArmor)helmet.func_77973_b()).getHigherJumps() : 0.0f;
        float totalJumpBoost = jumpBoost * 0.002f + (jumpBoost2 = chestplate.func_77973_b() instanceof IArmor ? (float)((IArmor)chestplate.func_77973_b()).getHigherJumps() : 0.0f) * 0.002f;
        if (totalJumpBoost > 0.0f) {
            playerEntity.func_213317_d(playerEntity.func_213322_ci().func_72441_c(0.0, (double)totalJumpBoost, 0.0));
        }
    }
}

