/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_gear.armor;

import com.infamous.dungeons_gear.armor.models.ChampionsArmorModel;
import com.infamous.dungeons_gear.init.DeferredItemInit;
import com.infamous.dungeons_gear.interfaces.IArmor;
import java.util.List;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ChampionsArmorItem
extends ArmorItem
implements IArmor {
    private final boolean unique;

    public ChampionsArmorItem(IArmorMaterial armorMaterial, EquipmentSlotType slotType, Item.Properties properties, boolean unique) {
        super(armorMaterial, slotType, properties);
        this.unique = unique;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlotType slot, String type) {
        if (stack.func_77973_b() == DeferredItemInit.CHAMPIONS_ARMOR.get() || stack.func_77973_b() == DeferredItemInit.CHAMPIONS_ARMOR_HELMET.get()) {
            return "dungeons_gear:textures/models/armor/champions_armor.png";
        }
        if (stack.func_77973_b() == DeferredItemInit.HEROS_ARMOR.get() || stack.func_77973_b() == DeferredItemInit.HEROS_ARMOR_HELMET.get()) {
            return "dungeons_gear:textures/models/armor/heros_armor.png";
        }
        return "";
    }

    @OnlyIn(value=Dist.CLIENT)
    public <A extends BipedModel<?>> A getArmorModel(LivingEntity entityLiving, ItemStack stack, EquipmentSlotType armorSlot, A _default) {
        if (stack.func_77973_b() == DeferredItemInit.CHAMPIONS_ARMOR.get() || stack.func_77973_b() == DeferredItemInit.CHAMPIONS_ARMOR_HELMET.get()) {
            return (A)((Object)new ChampionsArmorModel(1.0f, this.field_77881_a, entityLiving));
        }
        if (stack.func_77973_b() == DeferredItemInit.HEROS_ARMOR.get() || stack.func_77973_b() == DeferredItemInit.HEROS_ARMOR_HELMET.get()) {
            return (A)((Object)new ChampionsArmorModel(1.0f, this.field_77881_a, entityLiving));
        }
        return null;
    }

    public Rarity func_77613_e(ItemStack itemStack) {
        if (this.unique) {
            return Rarity.RARE;
        }
        return Rarity.UNCOMMON;
    }

    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> list, ITooltipFlag flag) {
        super.func_77624_a(stack, world, list, flag);
        if (this.unique) {
            list.add((ITextComponent)new StringTextComponent(TextFormatting.WHITE + "" + TextFormatting.ITALIC + "Given to the champions of the Overworld by the free villagers as a token of their thanks for many years of protection and assistance. The mark of a true hero."));
        } else {
            list.add((ITextComponent)new StringTextComponent(TextFormatting.WHITE + "" + TextFormatting.ITALIC + "Only given to the highest caliber of heroes, the Hero's Armor is a precious gift from the Villagers."));
        }
        list.add((ITextComponent)new TranslationTextComponent("attribute.name.healthPotionsHealNearbyAllies").func_240699_a_(TextFormatting.GREEN));
    }

    @Override
    public boolean doHealthPotionsHealNearbyAllies() {
        return this.unique;
    }

    @Override
    public double getHealthPotionBoost() {
        return 1.0;
    }
}

