/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_gear.armor;

import com.infamous.dungeons_gear.armor.models.FrostArmorModel;
import com.infamous.dungeons_gear.armor.models.SnowArmorModel;
import com.infamous.dungeons_gear.init.DeferredItemInit;
import com.infamous.dungeons_gear.interfaces.IArmor;
import java.util.List;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SnowArmorItem
extends ArmorItem
implements IArmor {
    private final boolean unique;

    public SnowArmorItem(IArmorMaterial armorMaterial, EquipmentSlotType slotType, Item.Properties properties, boolean unique) {
        super(armorMaterial, slotType, properties);
        this.unique = unique;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlotType slot, String type) {
        if (stack.func_77973_b() == DeferredItemInit.SNOW_ARMOR.get() || stack.func_77973_b() == DeferredItemInit.SNOW_ARMOR_HELMET.get()) {
            return "dungeons_gear:textures/models/armor/snow_armor.png";
        }
        if (stack.func_77973_b() == DeferredItemInit.FROST_ARMOR.get() || stack.func_77973_b() == DeferredItemInit.FROST_ARMOR_HELMET.get()) {
            return "dungeons_gear:textures/models/armor/frost_armor.png";
        }
        return "";
    }

    @OnlyIn(value=Dist.CLIENT)
    public <A extends BipedModel<?>> A getArmorModel(LivingEntity entityLiving, ItemStack stack, EquipmentSlotType armorSlot, A _default) {
        if (stack.func_77973_b() == DeferredItemInit.SNOW_ARMOR.get() || stack.func_77973_b() == DeferredItemInit.SNOW_ARMOR_HELMET.get()) {
            return (A)((Object)new SnowArmorModel(1.0f, this.field_77881_a, entityLiving));
        }
        if (stack.func_77973_b() == DeferredItemInit.FROST_ARMOR.get() || stack.func_77973_b() == DeferredItemInit.FROST_ARMOR_HELMET.get()) {
            return (A)((Object)new FrostArmorModel(1.0f, this.field_77881_a, entityLiving));
        }
        return null;
    }

    public Rarity func_77613_e(ItemStack itemStack) {
        if (this.unique) {
            return Rarity.RARE;
        }
        return Rarity.UNCOMMON;
    }

    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> list, ITooltipFlag flag) {
        super.func_77624_a(stack, world, list, flag);
        if (this.unique) {
            list.add((ITextComponent)new StringTextComponent(TextFormatting.WHITE + "" + TextFormatting.ITALIC + "This legendary armor, forged from ice that never melts, makes the wearer feel as if they are one with winter."));
            list.add((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Emits a Chilling Aura"));
        } else {
            list.add((ITextComponent)new StringTextComponent(TextFormatting.WHITE + "" + TextFormatting.ITALIC + "A suit of armor that was tempered in snowmelt, protecting the wearer from the harsh cold of the tundra."));
        }
    }

    @Override
    public double getFreezingResistance() {
        return 25.0;
    }
}

