/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_gear.artifacts;

import com.infamous.dungeons_gear.artifacts.ArtifactItem;
import com.infamous.dungeons_gear.capabilities.combo.ICombo;
import com.infamous.dungeons_gear.capabilities.summoning.ISummonable;
import com.infamous.dungeons_gear.capabilities.summoning.ISummoner;
import com.infamous.dungeons_gear.effects.CustomEffects;
import com.infamous.dungeons_gear.goals.BatFollowOwnerGoal;
import com.infamous.dungeons_gear.goals.BatMeleeAttackGoal;
import com.infamous.dungeons_gear.goals.BatOwnerHurtByTargetGoal;
import com.infamous.dungeons_gear.goals.BatOwnerHurtTargetGoal;
import com.infamous.dungeons_gear.goals.BeeFollowOwnerGoal;
import com.infamous.dungeons_gear.goals.BeeOwnerHurtByTargetGoal;
import com.infamous.dungeons_gear.goals.BeeOwnerHurtTargetGoal;
import com.infamous.dungeons_gear.goals.GolemOwnerHurtByTargetGoal;
import com.infamous.dungeons_gear.goals.GolemOwnerHurtTargetGoal;
import com.infamous.dungeons_gear.goals.IronGolemFollowOwnerGoal;
import com.infamous.dungeons_gear.goals.LlamaFollowOwnerGoal;
import com.infamous.dungeons_gear.goals.LlamaOwnerHurtByTargetGoal;
import com.infamous.dungeons_gear.goals.LlamaOwnerHurtTargetGoal;
import com.infamous.dungeons_gear.goals.SheepFollowOwnerGoal;
import com.infamous.dungeons_gear.goals.SheepMeleeAttackGoal;
import com.infamous.dungeons_gear.goals.SheepOwnerHurtByTargetGoal;
import com.infamous.dungeons_gear.goals.SheepOwnerHurtTargetGoal;
import com.infamous.dungeons_gear.init.DeferredItemInit;
import com.infamous.dungeons_gear.utilties.CapabilityHelper;
import com.infamous.dungeons_gear.utilties.ProjectileEffectHelper;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.BatEntity;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.passive.horse.LlamaEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.Item;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

@Mod.EventBusSubscriber(modid="dungeons_gear")
public class ArtifactEvents {
    @SubscribeEvent
    public static void reAddSummonableGoals(EntityJoinWorldEvent event) {
        if (ArtifactEvents.isEntitySummonable(event.getEntity())) {
            ISummonable summonableCap = CapabilityHelper.getSummonableCapability(event.getEntity());
            if (summonableCap == null) {
                return;
            }
            if (event.getEntity() instanceof LlamaEntity) {
                LlamaEntity llamaEntity = (LlamaEntity)event.getEntity();
                if (summonableCap.getSummoner() != null) {
                    llamaEntity.field_70715_bh.func_75776_a(1, (Goal)new LlamaOwnerHurtByTargetGoal(llamaEntity));
                    llamaEntity.field_70715_bh.func_75776_a(2, (Goal)new LlamaOwnerHurtTargetGoal(llamaEntity));
                    llamaEntity.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)llamaEntity, LivingEntity.class, 5, false, false, entityIterator -> entityIterator instanceof IMob && !(entityIterator instanceof CreeperEntity)));
                    llamaEntity.field_70714_bg.func_75776_a(2, (Goal)new LlamaFollowOwnerGoal(llamaEntity, 2.1, 10.0f, 2.0f, false));
                }
            }
            if (event.getEntity() instanceof WolfEntity) {
                WolfEntity wolfEntity = (WolfEntity)event.getEntity();
                if (summonableCap.getSummoner() != null) {
                    wolfEntity.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)wolfEntity, LivingEntity.class, 5, false, false, entityIterator -> entityIterator instanceof IMob && !(entityIterator instanceof CreeperEntity)));
                }
            }
            if (event.getEntity() instanceof IronGolemEntity) {
                IronGolemEntity ironGolemEntity = (IronGolemEntity)event.getEntity();
                if (summonableCap.getSummoner() != null) {
                    ironGolemEntity.field_70714_bg.func_75776_a(2, (Goal)new IronGolemFollowOwnerGoal(ironGolemEntity, 2.1, 10.0f, 2.0f, false));
                    ironGolemEntity.field_70715_bh.func_75776_a(1, (Goal)new GolemOwnerHurtByTargetGoal(ironGolemEntity));
                    ironGolemEntity.field_70715_bh.func_75776_a(2, (Goal)new GolemOwnerHurtTargetGoal(ironGolemEntity));
                }
            }
            if (event.getEntity() instanceof BatEntity) {
                BatEntity batEntity = (BatEntity)event.getEntity();
                if (summonableCap.getSummoner() != null) {
                    batEntity.field_70714_bg.func_75776_a(1, (Goal)new BatMeleeAttackGoal(batEntity, 1.0, true));
                    batEntity.field_70714_bg.func_75776_a(2, (Goal)new BatFollowOwnerGoal(batEntity, 2.1, 10.0f, 2.0f, false));
                    batEntity.field_70715_bh.func_75776_a(1, (Goal)new BatOwnerHurtByTargetGoal(batEntity));
                    batEntity.field_70715_bh.func_75776_a(2, (Goal)new BatOwnerHurtTargetGoal(batEntity));
                    batEntity.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)batEntity, LivingEntity.class, 5, false, false, entityIterator -> entityIterator instanceof IMob && !(entityIterator instanceof CreeperEntity)));
                }
            }
            if (event.getEntity() instanceof BeeEntity) {
                BeeEntity beeEntity = (BeeEntity)event.getEntity();
                if (summonableCap.getSummoner() != null) {
                    beeEntity.field_70714_bg.func_75776_a(2, (Goal)new BeeFollowOwnerGoal(beeEntity, 2.1, 10.0f, 2.0f, false));
                    beeEntity.field_70715_bh.func_75776_a(1, (Goal)new BeeOwnerHurtByTargetGoal(beeEntity));
                    beeEntity.field_70715_bh.func_75776_a(2, (Goal)new BeeOwnerHurtTargetGoal(beeEntity));
                    beeEntity.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)beeEntity, LivingEntity.class, 5, false, false, entityIterator -> entityIterator instanceof IMob && !(entityIterator instanceof CreeperEntity)));
                }
            }
            if (event.getEntity() instanceof SheepEntity) {
                SheepEntity sheepEntity = (SheepEntity)event.getEntity();
                if (summonableCap.getSummoner() != null) {
                    if (sheepEntity.func_184216_O().contains("Fire") || sheepEntity.func_184216_O().contains("Poison")) {
                        sheepEntity.field_70714_bg.func_75776_a(1, (Goal)new SheepMeleeAttackGoal(sheepEntity, 1.0, true));
                        sheepEntity.field_70715_bh.func_75776_a(1, (Goal)new SheepOwnerHurtByTargetGoal(sheepEntity));
                        sheepEntity.field_70715_bh.func_75776_a(2, (Goal)new SheepOwnerHurtTargetGoal(sheepEntity));
                        sheepEntity.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)sheepEntity, LivingEntity.class, 5, false, false, entityIterator -> entityIterator instanceof IMob && !(entityIterator instanceof CreeperEntity)));
                    }
                    sheepEntity.field_70714_bg.func_75776_a(2, (Goal)new SheepFollowOwnerGoal(sheepEntity, 2.1, 10.0f, 2.0f, false));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onEnchantedSheepAttack(LivingDamageEvent event) {
        if (event.getSource().func_76346_g() instanceof SheepEntity) {
            SheepEntity sheepEntity = (SheepEntity)event.getSource().func_76346_g();
            ISummonable summonableCap = CapabilityHelper.getSummonableCapability((Entity)sheepEntity);
            if (summonableCap == null) {
                return;
            }
            if (summonableCap.getSummoner() != null) {
                if (sheepEntity.func_184216_O().contains("Fire")) {
                    event.getEntityLiving().func_70015_d(100);
                } else if (sheepEntity.func_184216_O().contains("Poison")) {
                    EffectInstance poison = new EffectInstance(Effects.field_76436_u, 100);
                    event.getEntityLiving().func_195064_c(poison);
                }
            }
        }
    }

    @SubscribeEvent
    public static void updateBlueEnchantedSheep(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() instanceof SheepEntity) {
            PlayerEntity playerEntity;
            Entity summoner;
            SheepEntity sheepEntity = (SheepEntity)event.getEntityLiving();
            ISummonable summonableCap = CapabilityHelper.getSummonableCapability((Entity)sheepEntity);
            if (summonableCap == null) {
                return;
            }
            if (summonableCap.getSummoner() != null && sheepEntity.field_70170_p instanceof ServerWorld && (summoner = ((ServerWorld)sheepEntity.field_70170_p).func_217461_a(summonableCap.getSummoner())) instanceof PlayerEntity && !(playerEntity = (PlayerEntity)summoner).func_70644_a(Effects.field_76424_c) && sheepEntity.func_184216_O().contains("Speed")) {
                EffectInstance speed = new EffectInstance(Effects.field_76424_c, 100);
                playerEntity.func_195064_c(speed);
            }
        }
    }

    @SubscribeEvent
    public static void onSummonedMobAttemptsToAttack(LivingSetAttackTargetEvent event) {
        ISummonable attackerSummonableCap;
        LivingEntity summonableAttacker;
        if (ArtifactEvents.isEntitySummonable((Entity)event.getEntityLiving())) {
            summonableAttacker = event.getEntityLiving();
            attackerSummonableCap = CapabilityHelper.getSummonableCapability((Entity)summonableAttacker);
            if (attackerSummonableCap == null) {
                return;
            }
            if (attackerSummonableCap.getSummoner() != null) {
                UUID attackersOwner = attackerSummonableCap.getSummoner();
                if (ArtifactEvents.isEntitySummonable((Entity)event.getTarget())) {
                    UUID targetsOwner;
                    LivingEntity summonableTarget = event.getTarget();
                    ISummonable targetSummonableCap = CapabilityHelper.getSummonableCapability((Entity)summonableTarget);
                    if (targetSummonableCap == null) {
                        return;
                    }
                    if (targetSummonableCap.getSummoner() != null && (targetsOwner = targetSummonableCap.getSummoner()).equals(attackersOwner)) {
                        ArtifactEvents.preventAttackForSummonableMob(summonableAttacker);
                    }
                }
            }
        }
        if (event.getTarget() instanceof PlayerEntity && ArtifactEvents.isEntitySummonable((Entity)event.getEntityLiving())) {
            summonableAttacker = event.getEntityLiving();
            attackerSummonableCap = CapabilityHelper.getSummonableCapability((Entity)summonableAttacker);
            if (attackerSummonableCap == null) {
                return;
            }
            if (attackerSummonableCap.getSummoner() == event.getTarget().func_110124_au()) {
                ArtifactEvents.preventAttackForSummonableMob(summonableAttacker);
            }
        }
    }

    private static void preventAttackForSummonableMob(LivingEntity summonableAttacker) {
        LlamaEntity llamaEntity;
        if (summonableAttacker instanceof IronGolemEntity) {
            IronGolemEntity ironGolemEntity = (IronGolemEntity)summonableAttacker;
            ironGolemEntity.func_241356_K__();
        }
        if (summonableAttacker instanceof WolfEntity) {
            WolfEntity wolfEntity = (WolfEntity)summonableAttacker;
            wolfEntity.func_241356_K__();
        }
        if (summonableAttacker instanceof LlamaEntity) {
            llamaEntity = (LlamaEntity)summonableAttacker;
            llamaEntity.func_70624_b(null);
            llamaEntity.func_70604_c(null);
        }
        if (summonableAttacker instanceof BatEntity) {
            BatEntity batEntity = (BatEntity)summonableAttacker;
            batEntity.func_70624_b(null);
            batEntity.func_70604_c(null);
        }
        if (summonableAttacker instanceof BeeEntity) {
            BeeEntity beeEntity = (BeeEntity)summonableAttacker;
            beeEntity.func_241356_K__();
        }
        if (summonableAttacker instanceof SheepEntity) {
            llamaEntity = (SheepEntity)summonableAttacker;
            llamaEntity.func_70624_b(null);
            llamaEntity.func_70604_c(null);
        }
    }

    private static boolean isEntitySummonable(Entity target) {
        return target instanceof IronGolemEntity || target instanceof WolfEntity || target instanceof LlamaEntity || target instanceof BatEntity || target instanceof BeeEntity || target instanceof SheepEntity;
    }

    @SubscribeEvent
    public static void onShielding(ProjectileImpactEvent event) {
        Effect shielding;
        LivingEntity livingEntity;
        EntityRayTraceResult entityRayTraceResult;
        Entity entity;
        if (event.getRayTraceResult() instanceof EntityRayTraceResult && (entity = (entityRayTraceResult = (EntityRayTraceResult)event.getRayTraceResult()).func_216348_a()) instanceof LivingEntity && (livingEntity = (LivingEntity)entity).func_70660_b(shielding = CustomEffects.SHIELDING) != null && event.isCancelable()) {
            event.setCanceled(true);
            if (event.getEntity() instanceof AbstractArrowEntity) {
                AbstractArrowEntity arrowEntity = (AbstractArrowEntity)event.getEntity();
                ProjectileEffectHelper.ricochetArrowLikeShield(arrowEntity, livingEntity);
            }
        }
    }

    @SubscribeEvent
    public static void onSouLProtection(LivingDeathEvent event) {
        if (event.getEntityLiving().func_70660_b(CustomEffects.SOUL_PROTECTION) != null) {
            event.setCanceled(true);
            event.getEntityLiving().func_70606_j(1.0f);
            event.getEntityLiving().func_195061_cb();
            event.getEntityLiving().func_195064_c(new EffectInstance(Effects.field_76428_l, 900, 1));
            event.getEntityLiving().func_195064_c(new EffectInstance(Effects.field_76426_n, 900, 1));
            event.getEntityLiving().func_195064_c(new EffectInstance(Effects.field_76444_x, 100, 1));
        }
    }

    @SubscribeEvent
    public static void onArrowJoinWorld(EntityJoinWorldEvent event) {
        AbstractArrowEntity arrowEntity;
        Entity shooter;
        if (event.getEntity() instanceof AbstractArrowEntity && (shooter = (arrowEntity = (AbstractArrowEntity)event.getEntity()).func_234616_v_()) instanceof PlayerEntity) {
            int count;
            PlayerEntity playerEntity = (PlayerEntity)shooter;
            ICombo comboCap = CapabilityHelper.getComboCapability((Entity)playerEntity);
            if (comboCap == null) {
                return;
            }
            if (comboCap.getFlamingArrowsCount() > 0) {
                count = comboCap.getFlamingArrowsCount();
                arrowEntity.func_70015_d(100);
                comboCap.setFlamingArrowsCount(--count);
            }
            if (comboCap.getTormentArrowCount() > 0) {
                arrowEntity.func_184211_a("TormentArrow");
                count = comboCap.getTormentArrowCount();
                arrowEntity.func_189654_d(true);
                arrowEntity.func_213317_d(arrowEntity.func_213322_ci().func_186678_a(0.5));
                comboCap.setTormentArrowCount(--count);
            }
        }
    }

    @SubscribeEvent
    public static void onTormentArrowImpact(ProjectileImpactEvent.Arrow event) {
        AbstractArrowEntity arrowEntity = event.getArrow();
        Entity shooter = arrowEntity.func_234616_v_();
        if (!(shooter instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)shooter;
        if (arrowEntity.func_184216_O().contains("TormentArrow")) {
            if (arrowEntity.field_70173_aa > 1200) {
                arrowEntity.func_70106_y();
                event.setCanceled(true);
            }
            if (event.getRayTraceResult() instanceof EntityRayTraceResult) {
                EntityRayTraceResult entityRayTraceResult = (EntityRayTraceResult)event.getRayTraceResult();
                Entity targetEntity = entityRayTraceResult.func_216348_a();
                if (!(targetEntity instanceof LivingEntity)) {
                    event.setCanceled(true);
                }
                int currentKnockbackStrength = (Integer)ObfuscationReflectionHelper.getPrivateValue(AbstractArrowEntity.class, (Object)arrowEntity, (String)"field_70256_ap");
                arrowEntity.func_70240_a(currentKnockbackStrength + 1);
            }
            if (event.getRayTraceResult() instanceof BlockRayTraceResult) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void checkSummonedMobIsDead(TickEvent.PlayerTickEvent event) {
        UUID summonedSheep;
        UUID summonedBat;
        UUID summonedLlama;
        UUID summonedWolf;
        UUID summonedGolem;
        Entity entity;
        PlayerEntity summoner = event.player;
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        if (!summoner.func_70089_S()) {
            return;
        }
        ISummoner summonerCap = CapabilityHelper.getSummonerCapability((Entity)event.player);
        if (summonerCap == null) {
            return;
        }
        if (summonerCap.getSummonedGolem() != null && event.player.field_70170_p instanceof ServerWorld && !((entity = ((ServerWorld)event.player.field_70170_p).func_217461_a(summonedGolem = summonerCap.getSummonedGolem())) instanceof IronGolemEntity)) {
            summonerCap.setSummonedGolem(null);
            ArtifactItem.setArtifactCooldown(summoner, (Item)DeferredItemInit.GOLEM_KIT.get(), 600);
        }
        if (summonerCap.getSummonedWolf() != null && event.player.field_70170_p instanceof ServerWorld && !((entity = ((ServerWorld)event.player.field_70170_p).func_217461_a(summonedWolf = summonerCap.getSummonedWolf())) instanceof WolfEntity)) {
            summonerCap.setSummonedWolf(null);
            ArtifactItem.setArtifactCooldown(summoner, (Item)DeferredItemInit.TASTY_BONE.get(), 600);
        }
        if (summonerCap.getSummonedLlama() != null && event.player.field_70170_p instanceof ServerWorld && !((entity = ((ServerWorld)event.player.field_70170_p).func_217461_a(summonedLlama = summonerCap.getSummonedLlama())) instanceof LlamaEntity)) {
            summonerCap.setSummonedLlama(null);
            ArtifactItem.setArtifactCooldown(summoner, (Item)DeferredItemInit.WONDERFUL_WHEAT.get(), 600);
        }
        if (summonerCap.getSummonedBat() != null && event.player.field_70170_p instanceof ServerWorld && !((entity = ((ServerWorld)event.player.field_70170_p).func_217461_a(summonedBat = summonerCap.getSummonedBat())) instanceof BatEntity)) {
            summonerCap.setSummonedBat(null);
        }
        if (summonerCap.getSummonedSheep() != null && event.player.field_70170_p instanceof ServerWorld && !((entity = ((ServerWorld)event.player.field_70170_p).func_217461_a(summonedSheep = summonerCap.getSummonedSheep())) instanceof SheepEntity)) {
            summonerCap.setSummonedSheep(null);
            ArtifactItem.setArtifactCooldown(summoner, (Item)DeferredItemInit.ENCHANTED_GRASS.get(), 600);
        }
        ArtifactEvents.handleSummonableBeesAlreadyDead(event, summonerCap);
    }

    private static void handleSummonableBeesAlreadyDead(TickEvent.PlayerTickEvent event, ISummoner summonerCap) {
        for (int i = 0; i < 3; ++i) {
            Entity entity;
            UUID summonedBuzzyNestBee = summonerCap.getBuzzyNestBees()[i];
            UUID summonedTumblebeeBee = summonerCap.getTumblebeeBees()[i];
            UUID summonedBusyBeeBee = summonerCap.getBusyBeeBees()[i];
            if (summonedBuzzyNestBee != null && event.player.field_70170_p instanceof ServerWorld && !((entity = ((ServerWorld)event.player.field_70170_p).func_217461_a(summonedBuzzyNestBee)) instanceof BeeEntity)) {
                summonerCap.getBuzzyNestBees()[i] = null;
                if (summonerCap.hasNoBuzzyNestBees()) {
                    ArtifactItem.setArtifactCooldown(event.player, (Item)DeferredItemInit.BUZZY_NEST.get(), 460);
                }
            }
            if (summonedTumblebeeBee != null && event.player.field_70170_p instanceof ServerWorld && !((entity = ((ServerWorld)event.player.field_70170_p).func_217461_a(summonedTumblebeeBee)) instanceof BeeEntity)) {
                summonerCap.getTumblebeeBees()[i] = null;
            }
            if (summonedBusyBeeBee == null || !(event.player.field_70170_p instanceof ServerWorld) || (entity = ((ServerWorld)event.player.field_70170_p).func_217461_a(summonedBusyBeeBee)) instanceof BeeEntity) continue;
            summonerCap.getBusyBeeBees()[i] = null;
        }
    }

    @SubscribeEvent
    public static void onSummonableDeath(LivingDeathEvent event) {
        if (ArtifactEvents.isEntitySummonable((Entity)event.getEntityLiving())) {
            PlayerEntity summoner;
            LivingEntity livingEntity = event.getEntityLiving();
            World world = livingEntity.func_130014_f_();
            ISummonable summonableCap = CapabilityHelper.getSummonableCapability((Entity)livingEntity);
            if (summonableCap == null) {
                return;
            }
            if (summonableCap.getSummoner() != null && (summoner = world.func_217371_b(summonableCap.getSummoner())) != null) {
                ISummoner summonerCap = CapabilityHelper.getSummonerCapability((Entity)summoner);
                if (summonerCap == null) {
                    return;
                }
                UUID summonableUUID = livingEntity.func_110124_au();
                if (summonerCap.getSummonedGolem() == summonableUUID) {
                    summonerCap.setSummonedGolem(null);
                    ArtifactItem.setArtifactCooldown(summoner, (Item)DeferredItemInit.GOLEM_KIT.get(), 600);
                }
                if (summonerCap.getSummonedWolf() == summonableUUID) {
                    summonerCap.setSummonedWolf(null);
                    ArtifactItem.setArtifactCooldown(summoner, (Item)DeferredItemInit.TASTY_BONE.get(), 600);
                }
                if (summonerCap.getSummonedLlama() == summonableUUID) {
                    summonerCap.setSummonedLlama(null);
                    ArtifactItem.setArtifactCooldown(summoner, (Item)DeferredItemInit.WONDERFUL_WHEAT.get(), 600);
                }
                if (summonerCap.getSummonedBat() == summonableUUID) {
                    summonerCap.setSummonedBat(null);
                }
                if (summonerCap.getSummonedSheep() == summonableUUID) {
                    ArtifactItem.setArtifactCooldown(summoner, (Item)DeferredItemInit.ENCHANTED_GRASS.get(), 600);
                    summonerCap.setSummonedSheep(null);
                }
                for (int i = 0; i < 3; ++i) {
                    UUID buzzyNestBee = summonerCap.getBuzzyNestBees()[i];
                    UUID tumblebeeBee = summonerCap.getTumblebeeBees()[i];
                    UUID busyBeeBee = summonerCap.getBusyBeeBees()[i];
                    if (buzzyNestBee == summonableUUID) {
                        summonerCap.getBuzzyNestBees()[i] = null;
                        if (!summoner.func_184811_cZ().func_185141_a((Item)DeferredItemInit.BUZZY_NEST.get())) {
                            ArtifactItem.setArtifactCooldown(summoner, (Item)DeferredItemInit.BUZZY_NEST.get(), 460);
                        }
                    }
                    if (tumblebeeBee == summonableUUID) {
                        summonerCap.getTumblebeeBees()[i] = null;
                    }
                    if (busyBeeBee != summonableUUID) continue;
                    summonerCap.getBusyBeeBees()[i] = null;
                }
            }
        }
    }
}

