/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_gear.artifacts;

import com.infamous.dungeons_gear.artifacts.ArtifactItem;
import com.infamous.dungeons_gear.capabilities.summoning.ISummonable;
import com.infamous.dungeons_gear.capabilities.summoning.ISummoner;
import com.infamous.dungeons_gear.goals.BeeFollowOwnerGoal;
import com.infamous.dungeons_gear.goals.BeeOwnerHurtByTargetGoal;
import com.infamous.dungeons_gear.goals.BeeOwnerHurtTargetGoal;
import com.infamous.dungeons_gear.utilties.CapabilityHelper;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class BuzzyNestItem
extends ArtifactItem {
    public BuzzyNestItem(Item.Properties properties) {
        super(properties);
    }

    public ActionResultType func_195939_a(ItemUseContext itemUseContext) {
        block3: {
            ISummoner summonerCap;
            BlockPos blockPos;
            World world;
            block4: {
                world = itemUseContext.func_195991_k();
                if (world.field_72995_K) {
                    return ActionResultType.SUCCESS;
                }
                ItemStack itemUseContextItem = itemUseContext.func_195996_i();
                PlayerEntity itemUseContextPlayer = itemUseContext.func_195999_j();
                Hand itemUseContextHand = itemUseContext.func_221531_n();
                BlockPos itemUseContextPos = itemUseContext.func_195995_a();
                Direction itemUseContextFace = itemUseContext.func_196000_l();
                BlockState blockState = world.func_180495_p(itemUseContextPos);
                blockPos = blockState.func_196952_d((IBlockReader)world, itemUseContextPos).func_197766_b() ? itemUseContextPos : itemUseContextPos.func_177972_a(itemUseContextFace);
                if (itemUseContextPlayer == null || (summonerCap = CapabilityHelper.getSummonerCapability((Entity)itemUseContextPlayer)) == null) break block3;
                if (!summonerCap.hasNoBuzzyNestBees()) break block4;
                for (int i = 0; i < 3; ++i) {
                    ISummonable summonable;
                    BeeEntity beeEntity = (BeeEntity)EntityType.field_226289_e_.func_200721_a(world);
                    if (beeEntity == null || (summonable = CapabilityHelper.getSummonableCapability((Entity)beeEntity)) == null) continue;
                    summonable.setSummoner(itemUseContextPlayer.func_110124_au());
                    summonerCap.addBuzzyNestBee(beeEntity.func_110124_au());
                    this.createBuzzyNestBee(world, itemUseContextPlayer, blockPos, beeEntity);
                    if (itemUseContextPlayer.func_184812_l_()) continue;
                    itemUseContextItem.func_222118_a(1, (LivingEntity)itemUseContextPlayer, entity -> entity.func_213334_d(itemUseContextHand));
                }
                break block3;
            }
            if (!(world instanceof ServerWorld)) break block3;
            for (int i = 0; i < 3; ++i) {
                Entity entity2;
                UUID beeUUID = summonerCap.getBuzzyNestBees()[i];
                if (beeUUID == null || !((entity2 = ((ServerWorld)world).func_217461_a(beeUUID)) instanceof BeeEntity)) continue;
                BeeEntity summonedBeeEntity = (BeeEntity)entity2;
                summonedBeeEntity.func_223102_j((double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o() + 0.05, (double)blockPos.func_177952_p() + 0.5);
            }
        }
        return ActionResultType.CONSUME;
    }

    private void createBuzzyNestBee(World world, PlayerEntity itemUseContextPlayer, BlockPos blockPos, BeeEntity beeEntity) {
        beeEntity.func_70012_b((double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o() + 0.05, (double)blockPos.func_177952_p() + 0.5, 0.0f, 0.0f);
        beeEntity.field_70714_bg.func_75776_a(2, (Goal)new BeeFollowOwnerGoal(beeEntity, 2.1, 10.0f, 2.0f, false));
        beeEntity.field_70715_bh.func_75776_a(1, (Goal)new BeeOwnerHurtByTargetGoal(beeEntity));
        beeEntity.field_70715_bh.func_75776_a(2, (Goal)new BeeOwnerHurtTargetGoal(beeEntity));
        beeEntity.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)beeEntity, LivingEntity.class, 5, false, false, entityIterator -> entityIterator instanceof IMob && !(entityIterator instanceof CreeperEntity)));
        world.func_184148_a((PlayerEntity)null, itemUseContextPlayer.func_226277_ct_(), itemUseContextPlayer.func_226278_cu_(), itemUseContextPlayer.func_226281_cx_(), SoundEvents.field_226127_ab_, SoundCategory.AMBIENT, 64.0f, 1.0f);
        world.func_217376_c((Entity)beeEntity);
    }

    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> list, ITooltipFlag flag) {
        super.func_77624_a(stack, world, list, flag);
        list.add((ITextComponent)new StringTextComponent(TextFormatting.WHITE + "" + TextFormatting.ITALIC + "Bee lovers and the bee-loved alike are fans of the Buzzy Nest, but don't be fooled by the cute bees within - they pack a powerful sting!"));
        list.add((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "When the Buzzy Nest is placed on the ground, bees who will fight beside you begin to spawn."));
        list.add((ITextComponent)new StringTextComponent(TextFormatting.BLUE + "23 Seconds Cooldown"));
    }
}

