/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_gear.artifacts;

import com.infamous.dungeons_gear.artifacts.ArtifactItem;
import com.infamous.dungeons_gear.capabilities.summoning.ISummonable;
import com.infamous.dungeons_gear.capabilities.summoning.ISummoner;
import com.infamous.dungeons_gear.goals.SheepFollowOwnerGoal;
import com.infamous.dungeons_gear.goals.SheepMeleeAttackGoal;
import com.infamous.dungeons_gear.goals.SheepOwnerHurtByTargetGoal;
import com.infamous.dungeons_gear.goals.SheepOwnerHurtTargetGoal;
import com.infamous.dungeons_gear.utilties.CapabilityHelper;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class EnchantedGrassItem
extends ArtifactItem {
    public EnchantedGrassItem(Item.Properties properties) {
        super(properties);
    }

    public ActionResultType func_195939_a(ItemUseContext itemUseContext) {
        ISummoner summonerCap;
        World world = itemUseContext.func_195991_k();
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        ItemStack itemUseContextItem = itemUseContext.func_195996_i();
        PlayerEntity itemUseContextPlayer = itemUseContext.func_195999_j();
        Hand itemUseContextHand = itemUseContext.func_221531_n();
        BlockPos itemUseContextPos = itemUseContext.func_195995_a();
        Direction itemUseContextFace = itemUseContext.func_196000_l();
        BlockState blockState = world.func_180495_p(itemUseContextPos);
        BlockPos blockPos = blockState.func_196952_d((IBlockReader)world, itemUseContextPos).func_197766_b() ? itemUseContextPos : itemUseContextPos.func_177972_a(itemUseContextFace);
        if (itemUseContextPlayer != null && (summonerCap = CapabilityHelper.getSummonerCapability((Entity)itemUseContextPlayer)) != null) {
            Entity entity2;
            if (summonerCap.getSummonedSheep() == null) {
                ISummonable summon;
                SheepEntity sheepEntity = (SheepEntity)EntityType.field_200737_ac.func_200721_a(world);
                if (sheepEntity != null && (summon = CapabilityHelper.getSummonableCapability((Entity)sheepEntity)) != null) {
                    summon.setSummoner(itemUseContextPlayer.func_110124_au());
                    summonerCap.setSummonedSheep(sheepEntity.func_110124_au());
                    this.createEnchantedSheep(world, itemUseContextPlayer, blockPos, sheepEntity);
                    if (!itemUseContextPlayer.func_184812_l_()) {
                        itemUseContextItem.func_222118_a(1, (LivingEntity)itemUseContextPlayer, entity -> entity.func_213334_d(itemUseContextHand));
                    }
                }
            } else if (world instanceof ServerWorld && (entity2 = ((ServerWorld)world).func_217461_a(summonerCap.getSummonedSheep())) instanceof SheepEntity) {
                SheepEntity sheepEntity = (SheepEntity)entity2;
                sheepEntity.func_223102_j((double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o() + 0.05, (double)blockPos.func_177952_p() + 0.5);
            }
        }
        return ActionResultType.CONSUME;
    }

    private void createEnchantedSheep(World world, PlayerEntity itemUseContextPlayer, BlockPos blockPos, SheepEntity sheepEntity) {
        this.setSheepEnchantmentAndAI(sheepEntity);
        sheepEntity.func_70012_b((double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o() + 0.05, (double)blockPos.func_177952_p() + 0.5, 0.0f, 0.0f);
        world.func_184148_a((PlayerEntity)null, itemUseContextPlayer.func_226277_ct_(), itemUseContextPlayer.func_226278_cu_(), itemUseContextPlayer.func_226281_cx_(), SoundEvents.field_187757_eG, SoundCategory.AMBIENT, 64.0f, 1.0f);
        world.func_217376_c((Entity)sheepEntity);
    }

    private void setSheepEnchantmentAndAI(SheepEntity sheepEntity) {
        int sheepEnchantment = sheepEntity.func_70681_au().nextInt(3);
        sheepEntity.field_70714_bg.func_75776_a(2, (Goal)new SheepFollowOwnerGoal(sheepEntity, 2.1, 10.0f, 2.0f, false));
        if (sheepEnchantment == 0) {
            sheepEntity.func_175512_b(DyeColor.RED);
            sheepEntity.func_184211_a("Fire");
            sheepEntity.field_70714_bg.func_75776_a(1, (Goal)new SheepMeleeAttackGoal(sheepEntity, 1.0, true));
            sheepEntity.field_70715_bh.func_75776_a(1, (Goal)new SheepOwnerHurtByTargetGoal(sheepEntity));
            sheepEntity.field_70715_bh.func_75776_a(2, (Goal)new SheepOwnerHurtTargetGoal(sheepEntity));
            sheepEntity.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)sheepEntity, LivingEntity.class, 5, false, false, entityIterator -> entityIterator instanceof IMob && !(entityIterator instanceof CreeperEntity)));
        } else if (sheepEnchantment == 1) {
            sheepEntity.func_175512_b(DyeColor.GREEN);
            sheepEntity.func_184211_a("Poison");
            sheepEntity.field_70714_bg.func_75776_a(1, (Goal)new SheepMeleeAttackGoal(sheepEntity, 1.0, true));
            sheepEntity.field_70715_bh.func_75776_a(1, (Goal)new SheepOwnerHurtByTargetGoal(sheepEntity));
            sheepEntity.field_70715_bh.func_75776_a(2, (Goal)new SheepOwnerHurtTargetGoal(sheepEntity));
            sheepEntity.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)sheepEntity, LivingEntity.class, 5, false, false, entityIterator -> entityIterator instanceof IMob && !(entityIterator instanceof CreeperEntity)));
        } else {
            sheepEntity.func_175512_b(DyeColor.BLUE);
            sheepEntity.func_184211_a("Speed");
        }
    }

    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> list, ITooltipFlag flag) {
        super.func_77624_a(stack, world, list, flag);
        list.add((ITextComponent)new StringTextComponent(TextFormatting.WHITE + "" + TextFormatting.ITALIC + "Just as there are powerful heroes who answer the call to fight, there are powerful enchanted sheep who will join the fight when summoned."));
        list.add((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Randomly summons one of three sheep allies that can grant either speed, poison, or fire effects."));
        list.add((ITextComponent)new StringTextComponent(TextFormatting.BLUE + "30 Seconds Cooldown"));
    }
}

