/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_gear.artifacts.beacon;

import com.infamous.dungeons_gear.DungeonsGear;
import com.infamous.dungeons_gear.artifacts.ArtifactItem;
import com.infamous.dungeons_gear.artifacts.beacon.BeaconBeamColor;
import com.infamous.dungeons_gear.interfaces.ISoulGatherer;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public abstract class AbstractBeaconItem
extends ArtifactItem
implements ISoulGatherer {
    public static final double RAYTRACE_DISTANCE = 256.0;
    public static final float BEAM_DAMAGE_PER_TICK = 0.5f;
    public static final int EXPERIENCE_COST_PER_TICK = -1;

    public AbstractBeaconItem(Item.Properties properties) {
        super(properties);
    }

    public abstract BeaconBeamColor getBeamColor();

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        if (worldIn.field_72995_K) {
            if (AbstractBeaconItem.canFire(playerIn)) {
                worldIn.func_184133_a(playerIn, playerIn.func_233580_cy_(), SoundEvents.field_206938_K, SoundCategory.PLAYERS, 1.0f, 1.0f);
            }
            return new ActionResult(ActionResultType.PASS, (Object)itemstack);
        }
        if (!AbstractBeaconItem.canFire(playerIn)) {
            return new ActionResult(ActionResultType.FAIL, (Object)itemstack);
        }
        playerIn.func_184598_c(handIn);
        return new ActionResult(ActionResultType.PASS, (Object)itemstack);
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.NONE;
    }

    public void func_77615_a(ItemStack stack, World worldIn, LivingEntity entityLiving, int timeLeft) {
        if (entityLiving instanceof PlayerEntity) {
            worldIn.func_184133_a((PlayerEntity)entityLiving, entityLiving.func_233580_cy_(), SoundEvents.field_206940_M, SoundCategory.PLAYERS, 1.0f, 1.0f);
            entityLiving.func_184602_cy();
        }
    }

    public void onUsingTick(ItemStack stack, LivingEntity livingEntity, int count) {
        if (livingEntity instanceof PlayerEntity) {
            World world = livingEntity.func_130014_f_();
            PlayerEntity playerEntity = (PlayerEntity)livingEntity;
            if (AbstractBeaconItem.canFire(playerEntity)) {
                AxisAlignedBB axisalignedbb;
                if (!playerEntity.func_184812_l_()) {
                    playerEntity.func_195068_e(-1);
                }
                RayTraceResult result = playerEntity.func_213324_a(256.0, 1.0f, false);
                Vector3d eyeVector = playerEntity.func_174824_e(1.0f);
                Vector3d lookVector = playerEntity.func_70676_i(1.0f);
                Vector3d targetVector = eyeVector.func_72441_c(lookVector.field_72450_a * 256.0, lookVector.field_72448_b * 256.0, lookVector.field_72449_c * 256.0);
                EntityRayTraceResult entityraytraceresult = ProjectileHelper.func_221269_a((World)world, (Entity)playerEntity, (Vector3d)eyeVector, (Vector3d)targetVector, (AxisAlignedBB)(axisalignedbb = playerEntity.func_174813_aQ().func_216361_a(lookVector.func_186678_a(256.0)).func_72314_b(1.0, 1.0, 1.0)), entity -> entity instanceof LivingEntity && !entity.func_175149_v() && entity.func_70067_L());
                if (entityraytraceresult != null && result.func_216347_e().func_72436_e(eyeVector) > entityraytraceresult.func_216347_e().func_72436_e(eyeVector)) {
                    stack.func_222118_a(1, (LivingEntity)playerEntity, entity -> entity.func_213334_d(playerEntity.func_184600_cs()));
                    if (!world.func_201670_d()) {
                        Entity entity2 = entityraytraceresult.func_216348_a();
                        if (!this.resetHurtResistantTime(entity2)) {
                            return;
                        }
                        entity2.func_70097_a(DamageSource.func_76354_b((Entity)playerEntity, (Entity)playerEntity), 0.5f);
                    }
                }
            }
        }
    }

    private boolean resetHurtResistantTime(Entity entity) {
        String hurtResistantTime = "field_70172_ad";
        Integer hurtResistanceTimer = (Integer)ObfuscationReflectionHelper.getPrivateValue(Entity.class, (Object)entity, (String)hurtResistantTime);
        if (hurtResistanceTimer == null) {
            DungeonsGear.LOGGER.error("Reflection error for hurtResistantTime!");
            return false;
        }
        if (hurtResistanceTimer > 0) {
            ObfuscationReflectionHelper.setPrivateValue(Entity.class, (Object)entity, (Object)0, (String)hurtResistantTime);
            return true;
        }
        return true;
    }

    @Nullable
    public static BeaconBeamColor getBeaconBeamColor(ItemStack stack) {
        Item stackItem = stack.func_77973_b();
        return stackItem instanceof AbstractBeaconItem ? ((AbstractBeaconItem)stackItem).getBeamColor() : null;
    }

    public static boolean canFire(PlayerEntity playerEntity) {
        return playerEntity.field_71067_cb >= 1 || playerEntity.func_184812_l_();
    }

    public static ItemStack getBeacon(PlayerEntity player) {
        ItemStack heldItem = player.func_184614_ca();
        if (!(heldItem.func_77973_b() instanceof AbstractBeaconItem) && !((heldItem = player.func_184592_cb()).func_77973_b() instanceof AbstractBeaconItem)) {
            return ItemStack.field_190927_a;
        }
        return heldItem;
    }

    @Override
    public int getGatherAmount(ItemStack stack) {
        return 1;
    }
}

