/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_gear.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;

public class DungeonsGearConfig {
    private static CommentedFileConfig cfg;
    private static final ForgeConfigSpec.Builder builder;
    public static ForgeConfigSpec.ConfigValue<Integer> VEST_ARMOR_DURABILITY;
    public static ForgeConfigSpec.ConfigValue<Integer> ROBE_ARMOR_DURABILITY;
    public static ForgeConfigSpec.ConfigValue<Integer> PELT_ARMOR_DURABILITY;
    public static ForgeConfigSpec.ConfigValue<Integer> BONE_ARMOR_DURABILITY;
    public static ForgeConfigSpec.ConfigValue<Integer> LIGHT_PLATE_ARMOR_DURABILITY;
    public static ForgeConfigSpec.ConfigValue<Integer> MEDIUM_PLATE_ARMOR_DURABILITY;
    public static ForgeConfigSpec.ConfigValue<Integer> HEAVY_PLATE_ARMOR_DURABILITY;
    public static ForgeConfigSpec.ConfigValue<Integer> METAL_MELEE_WEAPON_DURABILITY;
    public static ForgeConfigSpec.ConfigValue<Integer> BOW_DURABILITY;
    public static ForgeConfigSpec.ConfigValue<Integer> CROSSBOW_DURABILITY;
    public static ForgeConfigSpec.ConfigValue<Integer> ARTIFACT_DURABILITY;
    public static ForgeConfigSpec.ConfigValue<Boolean> ENABLE_DUNGEONS_GEAR_LOOT;
    public static ForgeConfigSpec.ConfigValue<Boolean> ENABLE_SALVAGING;
    public static ForgeConfigSpec.ConfigValue<Boolean> ENABLE_VILLAGER_TRADES;
    public static ForgeConfigSpec.ConfigValue<Boolean> ENABLE_ENCHANTS_ON_NON_DUNGEONS_GEAR;
    public static ForgeConfigSpec.ConfigValue<Boolean> ENABLE_OVERPOWERED_ENCHANTMENT_COMBOS;
    public static ForgeConfigSpec.ConfigValue<Integer> COMMON_ITEM_VALUE;
    public static ForgeConfigSpec.ConfigValue<Integer> UNIQUE_ITEM_VALUE;
    public static ForgeConfigSpec.ConfigValue<Integer> ARTIFACT_VALUE;
    public static ForgeConfigSpec.ConfigValue<Double> UNIQUE_ITEM_COMMON_LOOT;
    public static ForgeConfigSpec.ConfigValue<Double> ARTIFACT_COMMON_LOOT;
    public static ForgeConfigSpec.ConfigValue<Double> UNIQUE_ITEM_UNCOMMON_LOOT;
    public static ForgeConfigSpec.ConfigValue<Double> ARTIFACT_UNCOMMON_LOOT;
    public static ForgeConfigSpec.ConfigValue<Double> UNIQUE_ITEM_RARE_LOOT;
    public static ForgeConfigSpec.ConfigValue<Double> ARTIFACT_RARE_LOOT;
    public static ForgeConfigSpec.ConfigValue<Double> UNIQUE_ITEM_SUPER_RARE_LOOT;
    public static ForgeConfigSpec.ConfigValue<Double> ARTIFACT_SUPER_RARE_LOOT;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> COMMON_LOOT_TABLES;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> COMMON_LOOT_TABLES_BLACKLIST;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> UNCOMMON_LOOT_TABLES;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> UNCOMMON_LOOT_TABLES_BLACKLIST;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> RARE_LOOT_TABLES;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> RARE_LOOT_TABLES_BLACKLIST;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> SUPER_RARE_LOOT_TABLES;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> SUPER_RARE_LOOT_TABLES_BLACKLIST;
    public static ForgeConfigSpec.ConfigValue<Boolean> ENABLE_AREA_OF_EFFECT_ON_PLAYERS;

    public DungeonsGearConfig() {
        cfg = (CommentedFileConfig)CommentedFileConfig.builder((File)new File(FMLPaths.CONFIGDIR.get().toString(), "dungeons_gear-common.toml")).sync().autosave().build();
        cfg.load();
        this.initConfig();
        ForgeConfigSpec spec = builder.build();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, spec, cfg.getFile().getName());
        spec.setConfig((CommentedConfig)cfg);
    }

    private void initConfig() {
        builder.comment("General Mod Configuration").push("general_mod_configuration");
        ENABLE_DUNGEONS_GEAR_LOOT = builder.comment("Enable the mass addition of Dungeons Gear items to various vanilla loot tables by the mod itself. \nIf you prefer to write your own loot pools via datapack or simply don't want it, disable this feature. [true / false]").define("enableDungeonsGearLoot", true);
        ENABLE_SALVAGING = builder.comment("Enable the salvaging of Dungeons Gear items by shift-right clicking villagers with the item in your hand. \nIf you have other mods messing with shift-right clicking villagers or simply don't want it, disable this feature. [true / false]").define("enableSalvaging", true);
        ENABLE_VILLAGER_TRADES = builder.comment("Enable Weaponsmith, Fletcher, Armorer and Leatherworker Villagers trading Dungeons Gear items. \nIf you have other mods messing with the trades of those professions or simply don't want it, disable this feature. [true / false]").define("enableVillagerTrades", true);
        ENABLE_ENCHANTS_ON_NON_DUNGEONS_GEAR = builder.comment("Enable applying enchantments from this mod on non-Dungeons gear using the Enchanting Table. \nIf you don't want your enchantments to become too cluttered for non-Dungeons gear, or simply don't like it, disable this feature. \nYou can still use the anvil to put the enchantments onto them and have them work correctly. [true / false]").define("enableEnchantsOnNonDungeonsGear", true);
        ENABLE_OVERPOWERED_ENCHANTMENT_COMBOS = builder.comment("Enable applying enchantments together to create combinations would  be considered too overpowered. \nIf you don't want overpowered enchantment combinations, like Sharpness and Committed on a sword, disable this feature. [true / false]").define("enableOverpoweredEnchantmentCombos", false);
        COMMON_ITEM_VALUE = builder.comment("The emerald value for a common weapon or armor [0-64, default: 12]").defineInRange("commonItemValue", 12, 0, 64);
        UNIQUE_ITEM_VALUE = builder.comment("The emerald value for a unique weapon or armor [0-64, default: 24]").defineInRange("uniqueItemValue", 24, 0, 64);
        ARTIFACT_VALUE = builder.comment("The emerald value for an artifact [0-64, default: 24]").defineInRange("artifactValue", 24, 0, 64);
        builder.pop();
        builder.comment("Item Configuration").push("item_configuration");
        builder.comment("For armor durability configuration reference, here are the vanilla armor durability multiplier values: \nLeather - 5\nGold = 7\nIron = 14\nTurtle = 25\nDiamond = 33\nNetherite = 37").push("armor_durability_multiplier_reference");
        builder.comment("For tool durability configuration reference, here are the vanilla tool durability values: \nGold - 32\nWood = 59\nStone = 131\nIron = 250\nCrossbow - 326\nBow - 384\nDiamond = 1561\nNetherite = 2031").push("tool_durability_reference");
        VEST_ARMOR_DURABILITY = builder.comment("Set the durability multiplier for armors that can be classified as a vest, such as Hunter's Armor. [0-1024, default: 14").defineInRange("vestArmorDurabilityMultiplier", 14, 0, 1024);
        ROBE_ARMOR_DURABILITY = builder.comment("Set the durability multiplier for armors that can be classified as a robe, such as the Evocation Robe. [0-1024, default: 14").defineInRange("robeArmorDurabilityMultiplier", 14, 0, 1024);
        PELT_ARMOR_DURABILITY = builder.comment("Set the durability multiplier for armors that are made out of pelts, such as Wolf Armor. [0-1024, default: 14").defineInRange("peltArmorDurabilityMultiplier", 14, 0, 1024);
        BONE_ARMOR_DURABILITY = builder.comment("Set the durability multiplier for armors that are made out of bones, such as Grim Armor. [0-1024, default: 14").defineInRange("boneArmorDurabilityMultiplier", 14, 0, 1024);
        LIGHT_PLATE_ARMOR_DURABILITY = builder.comment("Set the durability multiplier for armors that can be classified as light plate, such as Guard's Armor. [0-1024, default: 14").defineInRange("lightArmorDurabilityMultiplier", 14, 0, 1024);
        MEDIUM_PLATE_ARMOR_DURABILITY = builder.comment("Set the durability multiplier for armors that can be classified as medium plate, such as Reinforced Mail. [0-1024, default: 14").defineInRange("mediumArmorDurabilityMultiplier", 14, 0, 1024);
        HEAVY_PLATE_ARMOR_DURABILITY = builder.comment("Set the durability multiplier for armors that can be classified as heavy plate, such as Mercenary Armor. [0-1024, default: 14").defineInRange("heavyArmorDurabilityMultiplier", 14, 0, 1024);
        METAL_MELEE_WEAPON_DURABILITY = builder.comment("Set the durability for melee weapons. [0-1024, default: 250").defineInRange("meleeWeaponDurability", 250, 0, 1024);
        BOW_DURABILITY = builder.comment("Set the durability for bows. [0-1024, default: 384").defineInRange("bowDurability", 384, 0, 1024);
        CROSSBOW_DURABILITY = builder.comment("Set the durability for crossbows. [0-1024, default: 326").defineInRange("crossbowDurability", 326, 0, 1024);
        ARTIFACT_DURABILITY = builder.comment("Set the durability for artifacts. [0-1024, default: 64").defineInRange("artifactDurability", 64, 0, 1024);
        builder.pop();
        builder.comment("Combat Configuration").push("combat_configuration");
        ENABLE_AREA_OF_EFFECT_ON_PLAYERS = builder.comment("Enable area of effects also being applied to players. \nIf you do not want area of effects being applied to other players, disable this feature. [true / false]").define("enableAreaOfEffectOnPlayers", true);
        builder.pop();
        builder.comment("Common Loot Table Configuration").push("common_loot_table_configuration");
        COMMON_LOOT_TABLES = builder.comment("Add gear from this mod to loot tables considered common. \nTo do so, enter the full path of the specific loot table, or the path of the folder containing the loot tables.\nYou can also write an incomplete path, and the mod will add to loot tables containing that incomplete path.").defineList("commonLootTables", (List)Lists.newArrayList((Object[])new String[]{"minecraft:chests/abandoned_mineshaft", "minecraft:chests/shipwreck", "minecraft:chests/desert_pyramid"}), itemRaw -> itemRaw instanceof String);
        COMMON_LOOT_TABLES_BLACKLIST = builder.comment("Use this list to prevent specific loot tables from getting common loot. \nTo do so, enter the full path of the specific loot table.").defineList("commonLootTablesBlacklist", (List)Lists.newArrayList(), itemRaw -> itemRaw instanceof String);
        UNIQUE_ITEM_COMMON_LOOT = builder.comment("The decimal chance for a unique item to appear in common loot tables instead of a common one [0.0-1.0, default: 0.15]").defineInRange("uniqueItemCommonLoot", 0.25, 0.0, 1.0);
        ARTIFACT_COMMON_LOOT = builder.comment("The decimal chance for an artifact to appear in common loot tables [0.0-1.0, default: 0.25]").defineInRange("artifactCommonLoot", 0.25, 0.0, 1.0);
        builder.pop();
        builder.comment("Uncommon Loot Table Configuration").push("uncommon_loot_table_configuration");
        UNCOMMON_LOOT_TABLES = builder.comment("Add gear from this mod to loot tables considered uncommon. \nTo do so, enter the full path of the specific loot table, or the path of the folder containing the loot tables.\nYou can also write an incomplete path, and the mod will add to loot tables containing that incomplete path.").defineList("uncommonLootTables", (List)Lists.newArrayList((Object[])new String[]{"minecraft:chests/jungle_temple", "minecraft:chests/nether_bridge", "minecraft:chests/bastion"}), itemRaw -> itemRaw instanceof String);
        UNCOMMON_LOOT_TABLES_BLACKLIST = builder.comment("Use this list to prevent specific loot tables from getting uncommon loot. \nTo do so, enter the full path of the specific loot table.").defineList("uncommonLootTablesBlacklist", (List)Lists.newArrayList((Object[])new String[]{"minecraft:chests/jungle_temple_dispenser"}), itemRaw -> itemRaw instanceof String);
        UNIQUE_ITEM_UNCOMMON_LOOT = builder.comment("The decimal chance for a unique item to appear in uncommon loot tables instead of a common one [0.0-1.0, default: 0.3]").defineInRange("uniqueItemUncommonLoot", 0.5, 0.0, 1.0);
        ARTIFACT_UNCOMMON_LOOT = builder.comment("The decimal chance for an artifact to appear in uncommon loot tables [0.0-1.0, default: 0.5]").defineInRange("artifactUncommonLoot", 0.5, 0.0, 1.0);
        builder.pop();
        builder.comment("Rare Loot Table Configuration").push("rare_loot_table_configuration");
        RARE_LOOT_TABLES = builder.comment("Add gear from this mod to loot tables considered rare. \nTo do so, enter the full path of the specific loot table, or the path of the folder containing the loot tables.\nYou can also write an incomplete path, and the mod will add to loot tables containing that incomplete path.").defineList("rareLootTables", (List)Lists.newArrayList((Object[])new String[]{"minecraft:chests/stronghold", "minecraft:chests/underwater_ruin", "minecraft:chests/ruined_portal", "minecraft:chests/pillager_outpost", "minecraft:chests/simple_dungeon", "minecraft:chests/end_city_treasure", "minecraft:chests/igloo_chest"}), itemRaw -> itemRaw instanceof String);
        RARE_LOOT_TABLES_BLACKLIST = builder.comment("Use this list to prevent specific loot tables from getting rare loot. \nTo do so, enter the full path of the specific loot table.").defineList("rareLootTableBlacklist", (List)Lists.newArrayList(), itemRaw -> itemRaw instanceof String);
        UNIQUE_ITEM_RARE_LOOT = builder.comment("The decimal chance for a unique weapon to appear in rare loot table instead of a common ones [0.0-1.0, default: 0.45]").defineInRange("uniqueItemRareLoot", 0.75, 0.0, 1.0);
        ARTIFACT_RARE_LOOT = builder.comment("The decimal chance for an artifact to appear in rare loot tables [0.0-1.0, default: 0.75]").defineInRange("artifactRareLoot", 0.75, 0.0, 1.0);
        builder.pop();
        builder.comment("Super Rare Loot Table Configuration").push("super_rare_loot_table_configuration");
        SUPER_RARE_LOOT_TABLES = builder.comment("Add gear from this mod to loot tables considered super rare. \nTo do so, enter the full path of the specific loot table, or the path of the folder containing the loot tables.\nYou can also write an incomplete path, and the mod will add to loot tables containing that incomplete path.").defineList("superRareLootTables", (List)Lists.newArrayList((Object[])new String[]{"minecraft:chests/woodland_mansion", "minecraft:chests/buried_treasure"}), itemRaw -> itemRaw instanceof String);
        SUPER_RARE_LOOT_TABLES_BLACKLIST = builder.comment("Use this list to prevent specific loot tables from getting super rare loot. \nTo do so, enter the full path of the specific loot table.").defineList("superRareLootTablesBlacklist", (List)Lists.newArrayList(), itemRaw -> itemRaw instanceof String);
        UNIQUE_ITEM_SUPER_RARE_LOOT = builder.comment("The decimal chance for a unique item to appear in super rare loot tables instead of a common one [0.0-1.0, default: 0.6]").defineInRange("uniqueItemSuperRareLoot", 1.0, 0.0, 1.0);
        ARTIFACT_SUPER_RARE_LOOT = builder.comment("The decimal chance for an artifact to appear in super rare loot tables [0.0-1.0, default: 1.0]").defineInRange("artifactSuperRareLoot", 1.0, 0.0, 1.0);
        builder.pop();
    }

    static {
        builder = new ForgeConfigSpec.Builder();
    }
}

