/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_gear.enchantments.armor;

import com.infamous.dungeons_gear.capabilities.combo.ICombo;
import com.infamous.dungeons_gear.config.DungeonsGearConfig;
import com.infamous.dungeons_gear.enchantments.ModEnchantmentTypes;
import com.infamous.dungeons_gear.enchantments.lists.ArmorEnchantmentList;
import com.infamous.dungeons_gear.enchantments.types.PulseEnchantment;
import com.infamous.dungeons_gear.init.DeferredItemInit;
import com.infamous.dungeons_gear.utilties.AreaOfEffectHelper;
import com.infamous.dungeons_gear.utilties.CapabilityHelper;
import com.infamous.dungeons_gear.utilties.ModEnchantmentHelper;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="dungeons_gear")
public class ChillingEnchantment
extends PulseEnchantment {
    public ChillingEnchantment() {
        super(Enchantment.Rarity.RARE, ModEnchantmentTypes.ARMOR, new EquipmentSlotType[]{EquipmentSlotType.HEAD, EquipmentSlotType.CHEST, EquipmentSlotType.LEGS, EquipmentSlotType.FEET});
    }

    public int func_77325_b() {
        return 3;
    }

    public boolean func_77326_a(Enchantment enchantment) {
        return (Boolean)DungeonsGearConfig.ENABLE_OVERPOWERED_ENCHANTMENT_COMBOS.get() != false || !(enchantment instanceof PulseEnchantment);
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        PlayerEntity player = event.player;
        if (player == null) {
            return;
        }
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        if (player.func_70089_S()) {
            boolean uniqueArmorFlag;
            ICombo comboCap = CapabilityHelper.getComboCapability((Entity)player);
            if (comboCap == null) {
                return;
            }
            int freezeNearbyTimer = comboCap.getFreezeNearbyTimer();
            boolean bl = uniqueArmorFlag = player.func_184582_a(EquipmentSlotType.CHEST).func_77973_b() == DeferredItemInit.FROST_ARMOR.get() || player.func_184582_a(EquipmentSlotType.HEAD).func_77973_b() == DeferredItemInit.FROST_ARMOR_HELMET.get();
            if (ModEnchantmentHelper.hasEnchantment((LivingEntity)player, ArmorEnchantmentList.CHILLING) || uniqueArmorFlag) {
                if (freezeNearbyTimer <= 0) {
                    int chillingLevel = EnchantmentHelper.func_185284_a((Enchantment)ArmorEnchantmentList.CHILLING, (LivingEntity)player);
                    if (uniqueArmorFlag) {
                        ++chillingLevel;
                    }
                    AreaOfEffectHelper.freezeNearbyEnemies((LivingEntity)player, chillingLevel - 1, 1.5f);
                    comboCap.setFreezeNearbyTimer(40);
                } else {
                    comboCap.setFreezeNearbyTimer(freezeNearbyTimer - 1);
                }
            } else if (freezeNearbyTimer != 40) {
                comboCap.setFreezeNearbyTimer(40);
            }
        }
    }
}

