/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_gear.enchantments.melee;

import com.infamous.dungeons_gear.capabilities.summoning.ISummonable;
import com.infamous.dungeons_gear.capabilities.summoning.ISummoner;
import com.infamous.dungeons_gear.enchantments.ModEnchantmentTypes;
import com.infamous.dungeons_gear.enchantments.lists.MeleeEnchantmentList;
import com.infamous.dungeons_gear.goals.BeeFollowOwnerGoal;
import com.infamous.dungeons_gear.goals.BeeOwnerHurtByTargetGoal;
import com.infamous.dungeons_gear.goals.BeeOwnerHurtTargetGoal;
import com.infamous.dungeons_gear.init.DeferredItemInit;
import com.infamous.dungeons_gear.utilties.CapabilityHelper;
import com.infamous.dungeons_gear.utilties.ModEnchantmentHelper;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="dungeons_gear")
public class BusyBeeEnchantment
extends Enchantment {
    public BusyBeeEnchantment() {
        super(Enchantment.Rarity.RARE, ModEnchantmentTypes.MELEE, new EquipmentSlotType[]{EquipmentSlotType.MAINHAND});
    }

    public int func_77325_b() {
        return 3;
    }

    @SubscribeEvent
    public static void onBusyBeeKill(LivingDeathEvent event) {
        if (event.getSource().func_76364_f() instanceof AbstractArrowEntity) {
            return;
        }
        if (event.getSource().func_76346_g() instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)event.getSource().func_76346_g();
            LivingEntity victim = event.getEntityLiving();
            if (attacker instanceof PlayerEntity) {
                boolean uniqueWeaponFlag;
                PlayerEntity playerEntity = (PlayerEntity)attacker;
                ItemStack mainhand = playerEntity.func_184614_ca();
                boolean bl = uniqueWeaponFlag = mainhand.func_77973_b() == DeferredItemInit.BEE_STINGER.get();
                if (ModEnchantmentHelper.hasEnchantment(mainhand, MeleeEnchantmentList.BUSY_BEE)) {
                    float rampagingRand;
                    float busyBeeChance;
                    int busyBeeLevel = EnchantmentHelper.func_77506_a((Enchantment)MeleeEnchantmentList.RAMPAGING, (ItemStack)mainhand);
                    float busyBeeRand = playerEntity.func_70681_au().nextFloat();
                    if (busyBeeRand <= (busyBeeChance = 0.1f + (float)busyBeeLevel * 0.01f)) {
                        BusyBeeEnchantment.createBusyBee(victim, playerEntity);
                    }
                    if (uniqueWeaponFlag && (rampagingRand = playerEntity.func_70681_au().nextFloat()) <= 0.2f) {
                        BusyBeeEnchantment.createBusyBee(victim, playerEntity);
                    }
                }
            }
        }
    }

    private static void createBusyBee(LivingEntity victim, PlayerEntity playerEntity) {
        ISummoner summonerCap = CapabilityHelper.getSummonerCapability((Entity)playerEntity);
        BeeEntity beeEntity = (BeeEntity)EntityType.field_226289_e_.func_200721_a(playerEntity.field_70170_p);
        if (beeEntity != null && summonerCap != null) {
            ISummonable summonable = CapabilityHelper.getSummonableCapability((Entity)beeEntity);
            if (summonable != null && summonerCap.addBusyBeeBee(beeEntity.func_110124_au())) {
                summonable.setSummoner(playerEntity.func_110124_au());
                BusyBeeEnchantment.createBee(victim, playerEntity, beeEntity);
            } else {
                beeEntity.func_70106_y();
            }
        }
    }

    private static void createBee(LivingEntity victim, PlayerEntity playerEntity, BeeEntity beeEntity) {
        beeEntity.func_70012_b(victim.func_226277_ct_() + 0.5, victim.func_226278_cu_() + 0.05, victim.func_226281_cx_() + 0.5, 0.0f, 0.0f);
        beeEntity.field_70714_bg.func_75776_a(2, (Goal)new BeeFollowOwnerGoal(beeEntity, 2.1, 10.0f, 2.0f, false));
        beeEntity.field_70715_bh.func_75776_a(1, (Goal)new BeeOwnerHurtByTargetGoal(beeEntity));
        beeEntity.field_70715_bh.func_75776_a(2, (Goal)new BeeOwnerHurtTargetGoal(beeEntity));
        beeEntity.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)beeEntity, LivingEntity.class, 5, false, false, entityIterator -> entityIterator instanceof IMob && !(entityIterator instanceof CreeperEntity)));
        playerEntity.field_70170_p.func_184148_a((PlayerEntity)null, playerEntity.func_226277_ct_(), playerEntity.func_226278_cu_(), playerEntity.func_226281_cx_(), SoundEvents.field_226127_ab_, SoundCategory.AMBIENT, 64.0f, 1.0f);
        playerEntity.field_70170_p.func_217376_c((Entity)beeEntity);
    }
}

