/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_gear.enchantments.melee;

import com.infamous.dungeons_gear.config.DungeonsGearConfig;
import com.infamous.dungeons_gear.enchantments.ModEnchantmentTypes;
import com.infamous.dungeons_gear.enchantments.lists.MeleeEnchantmentList;
import com.infamous.dungeons_gear.enchantments.types.AOEDamageEnchantment;
import com.infamous.dungeons_gear.enchantments.types.DamageBoostEnchantment;
import com.infamous.dungeons_gear.init.DeferredItemInit;
import com.infamous.dungeons_gear.utilties.AOECloudHelper;
import com.infamous.dungeons_gear.utilties.AreaOfEffectHelper;
import com.infamous.dungeons_gear.utilties.ModEnchantmentHelper;
import net.minecraft.enchantment.DamageEnchantment;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="dungeons_gear")
public class ExplodingEnchantment
extends AOEDamageEnchantment {
    public ExplodingEnchantment() {
        super(Enchantment.Rarity.RARE, ModEnchantmentTypes.MELEE, new EquipmentSlotType[]{EquipmentSlotType.MAINHAND});
    }

    public int func_77325_b() {
        return 3;
    }

    public boolean func_77326_a(Enchantment enchantment) {
        return (Boolean)DungeonsGearConfig.ENABLE_OVERPOWERED_ENCHANTMENT_COMBOS.get() != false || !(enchantment instanceof DamageEnchantment) && !(enchantment instanceof DamageBoostEnchantment) && !(enchantment instanceof AOEDamageEnchantment);
    }

    @SubscribeEvent
    public static void onExplodingKill(LivingDeathEvent event) {
        if (event.getSource().func_76364_f() instanceof AbstractArrowEntity) {
            return;
        }
        if (event.getSource().func_76346_g() instanceof LivingEntity) {
            boolean uniqueWeaponFlag;
            LivingEntity attacker = (LivingEntity)event.getSource().func_76346_g();
            LivingEntity victim = event.getEntityLiving();
            ItemStack mainhand = attacker.func_184614_ca();
            boolean bl = uniqueWeaponFlag = mainhand.func_77973_b() == DeferredItemInit.CURSED_AXE.get() || mainhand.func_77973_b() == DeferredItemInit.BATTLESTAFF_OF_TERROR.get();
            if (ModEnchantmentHelper.hasEnchantment(mainhand, MeleeEnchantmentList.EXPLODING) || uniqueWeaponFlag) {
                int explodingLevel = EnchantmentHelper.func_77506_a((Enchantment)MeleeEnchantmentList.EXPLODING, (ItemStack)mainhand);
                float explosionDamage = victim.func_110138_aP() * 0.2f * (float)explodingLevel;
                if (uniqueWeaponFlag) {
                    explosionDamage += victim.func_110138_aP() * 0.2f;
                }
                victim.field_70170_p.func_184148_a((PlayerEntity)null, victim.func_226277_ct_(), victim.func_226278_cu_(), victim.func_226281_cx_(), SoundEvents.field_187539_bB, SoundCategory.PLAYERS, 64.0f, 1.0f);
                AOECloudHelper.spawnExplosionCloud(attacker, victim, 3.0f);
                AreaOfEffectHelper.causeExplosionAttack(attacker, victim, explosionDamage, 3.0f);
            }
        }
    }
}

