/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_gear.enchantments.melee;

import com.infamous.dungeons_gear.DungeonsGear;
import com.infamous.dungeons_gear.config.DungeonsGearConfig;
import com.infamous.dungeons_gear.damagesources.OffhandAttackDamageSource;
import com.infamous.dungeons_gear.enchantments.ModEnchantmentTypes;
import com.infamous.dungeons_gear.enchantments.lists.MeleeRangedEnchantmentList;
import com.infamous.dungeons_gear.init.DeferredItemInit;
import com.infamous.dungeons_gear.utilties.ModEnchantmentHelper;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="dungeons_gear")
public class FreezingEnchantment
extends Enchantment {
    public FreezingEnchantment() {
        super(Enchantment.Rarity.RARE, ModEnchantmentTypes.MELEE, new EquipmentSlotType[]{EquipmentSlotType.MAINHAND});
    }

    public int func_77325_b() {
        return 3;
    }

    public boolean func_77326_a(Enchantment enchantment) {
        return (Boolean)DungeonsGearConfig.ENABLE_OVERPOWERED_ENCHANTMENT_COMBOS.get() != false || enchantment != Enchantments.field_77334_n;
    }

    public void func_151368_a(LivingEntity user, Entity target, int level) {
        boolean uniqueWeaponFlag;
        if (!(target instanceof LivingEntity)) {
            return;
        }
        ItemStack mainhand = user.func_184614_ca();
        boolean bl = uniqueWeaponFlag = mainhand.func_77973_b() == DeferredItemInit.FANG_OF_FROST.get() || mainhand.func_77973_b() == DeferredItemInit.FROST_SCYTHE.get() || mainhand.func_77973_b() == DeferredItemInit.FREEZING_FOIL.get();
        if (uniqueWeaponFlag) {
            ++level;
        }
        EffectInstance freezing = new EffectInstance(Effects.field_76421_d, 60, level - 1);
        EffectInstance miningFatigue = new EffectInstance(Effects.field_76419_f, 60, level - 1);
        ((LivingEntity)target).func_195064_c(freezing);
        ((LivingEntity)target).func_195064_c(miningFatigue);
        DungeonsGear.PROXY.spawnParticles(target, ParticleTypes.field_197593_D);
    }

    @SubscribeEvent
    public static void onFreezingAttack(LivingAttackEvent event) {
        boolean uniqueWeaponFlag;
        if (event.getSource().func_76364_f() instanceof AbstractArrowEntity) {
            return;
        }
        if (event.getSource() instanceof OffhandAttackDamageSource) {
            return;
        }
        if (!(event.getSource().func_76346_g() instanceof LivingEntity)) {
            return;
        }
        LivingEntity attacker = (LivingEntity)event.getSource().func_76346_g();
        LivingEntity victim = event.getEntityLiving();
        ItemStack mainhand = attacker.func_184614_ca();
        boolean bl = uniqueWeaponFlag = mainhand.func_77973_b() == DeferredItemInit.FANG_OF_FROST.get() || mainhand.func_77973_b() == DeferredItemInit.FROST_SCYTHE.get() || mainhand.func_77973_b() == DeferredItemInit.FREEZING_FOIL.get();
        if (uniqueWeaponFlag && !ModEnchantmentHelper.hasEnchantment(mainhand, MeleeRangedEnchantmentList.FREEZING)) {
            EffectInstance freezing = new EffectInstance(Effects.field_76421_d, 60);
            EffectInstance miningFatigue = new EffectInstance(Effects.field_76419_f, 60);
            victim.func_195064_c(freezing);
            victim.func_195064_c(miningFatigue);
            DungeonsGear.PROXY.spawnParticles((Entity)victim, ParticleTypes.field_197593_D);
        }
    }
}

