/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_gear.enchantments.melee;

import com.infamous.dungeons_gear.config.DungeonsGearConfig;
import com.infamous.dungeons_gear.enchantments.ModEnchantmentTypes;
import com.infamous.dungeons_gear.enchantments.lists.MeleeEnchantmentList;
import com.infamous.dungeons_gear.enchantments.types.AOEDamageEnchantment;
import com.infamous.dungeons_gear.enchantments.types.DamageBoostEnchantment;
import com.infamous.dungeons_gear.init.DeferredItemInit;
import com.infamous.dungeons_gear.utilties.AOECloudHelper;
import com.infamous.dungeons_gear.utilties.AreaOfEffectHelper;
import com.infamous.dungeons_gear.utilties.ModEnchantmentHelper;
import net.minecraft.enchantment.DamageEnchantment;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="dungeons_gear")
public class ShockwaveEnchantment
extends AOEDamageEnchantment {
    public static final float SHOCKWAVE_DAMAGE_MULTIPLIER = 0.25f;

    public ShockwaveEnchantment() {
        super(Enchantment.Rarity.RARE, ModEnchantmentTypes.MELEE, new EquipmentSlotType[]{EquipmentSlotType.MAINHAND});
    }

    public int func_77325_b() {
        return 3;
    }

    public boolean func_77326_a(Enchantment enchantment) {
        return (Boolean)DungeonsGearConfig.ENABLE_OVERPOWERED_ENCHANTMENT_COMBOS.get() != false || !(enchantment instanceof DamageEnchantment) && !(enchantment instanceof DamageBoostEnchantment) && !(enchantment instanceof AOEDamageEnchantment);
    }

    @SubscribeEvent
    public static void onVanillaCriticalHit(CriticalHitEvent event) {
        if (event.getPlayer() != null && event.isVanillaCritical()) {
            boolean uniqueWeaponFlag;
            PlayerEntity attacker = event.getPlayer();
            LivingEntity victim = event.getEntityLiving();
            ItemStack mainhand = attacker.func_184614_ca();
            boolean bl = uniqueWeaponFlag = mainhand.func_77973_b() == DeferredItemInit.WHIRLWIND.get();
            if (ModEnchantmentHelper.hasEnchantment(mainhand, MeleeEnchantmentList.SHOCKWAVE) || uniqueWeaponFlag) {
                int shockwaveLevel = EnchantmentHelper.func_77506_a((Enchantment)MeleeEnchantmentList.SHOCKWAVE, (ItemStack)mainhand);
                if (uniqueWeaponFlag) {
                    ++shockwaveLevel;
                }
                float attackDamage = (float)attacker.func_233637_b_(Attributes.field_233823_f_);
                float cooledAttackStrength = attacker.func_184825_o(0.5f);
                float shockwaveDamage = (attackDamage *= 0.2f + cooledAttackStrength * cooledAttackStrength * 0.8f) * 0.25f;
                victim.field_70170_p.func_184148_a((PlayerEntity)null, victim.func_226277_ct_(), victim.func_226278_cu_(), victim.func_226281_cx_(), SoundEvents.field_187752_dd, SoundCategory.PLAYERS, 64.0f, 1.0f);
                AOECloudHelper.spawnCritCloud((LivingEntity)attacker, victim, 3.0f);
                AreaOfEffectHelper.causeShockwave((LivingEntity)attacker, victim, shockwaveDamage *= (float)(shockwaveLevel + 1) / 2.0f, 3.0f);
            }
        }
    }
}

