/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_gear.enchantments.melee;

import com.infamous.dungeons_gear.damagesources.OffhandAttackDamageSource;
import com.infamous.dungeons_gear.effects.CustomEffects;
import com.infamous.dungeons_gear.enchantments.ModEnchantmentTypes;
import com.infamous.dungeons_gear.init.DeferredItemInit;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="dungeons_gear")
public class StunningEnchantment
extends Enchantment {
    public StunningEnchantment() {
        super(Enchantment.Rarity.RARE, ModEnchantmentTypes.MELEE, new EquipmentSlotType[]{EquipmentSlotType.MAINHAND});
    }

    public int func_77325_b() {
        return 3;
    }

    public void func_151368_a(LivingEntity user, Entity target, int level) {
        if (!(target instanceof LivingEntity)) {
            return;
        }
        float chance = user.func_70681_au().nextFloat();
        if ((double)chance <= (double)level * 0.05) {
            EffectInstance stunned = new EffectInstance(CustomEffects.STUNNED, 60);
            EffectInstance nausea = new EffectInstance(Effects.field_76431_k, 60);
            EffectInstance slowness = new EffectInstance(Effects.field_76421_d, 60, 5);
            ((LivingEntity)target).func_195064_c(stunned);
            ((LivingEntity)target).func_195064_c(nausea);
            ((LivingEntity)target).func_195064_c(slowness);
        }
    }

    @SubscribeEvent
    public static void onHighlandAxeAttack(LivingAttackEvent event) {
        float chance;
        if (event.getSource().func_76364_f() instanceof AbstractArrowEntity) {
            return;
        }
        if (event.getSource() instanceof OffhandAttackDamageSource) {
            return;
        }
        if (!(event.getSource().func_76346_g() instanceof LivingEntity)) {
            return;
        }
        LivingEntity attacker = (LivingEntity)event.getSource().func_76346_g();
        LivingEntity victim = event.getEntityLiving();
        if (attacker.func_184614_ca().func_77973_b() == DeferredItemInit.HIGHLAND_AXE.get() && (double)(chance = attacker.func_70681_au().nextFloat()) <= 0.05) {
            EffectInstance stunned = new EffectInstance(CustomEffects.STUNNED, 60);
            EffectInstance nausea = new EffectInstance(Effects.field_76431_k, 60);
            EffectInstance slowness = new EffectInstance(Effects.field_76421_d, 60, 5);
            victim.func_195064_c(stunned);
            victim.func_195064_c(nausea);
            victim.func_195064_c(slowness);
        }
    }
}

