/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_gear.enchantments.melee;

import com.infamous.dungeons_gear.config.DungeonsGearConfig;
import com.infamous.dungeons_gear.enchantments.ModEnchantmentTypes;
import com.infamous.dungeons_gear.enchantments.lists.MeleeEnchantmentList;
import com.infamous.dungeons_gear.enchantments.types.AOEDamageEnchantment;
import com.infamous.dungeons_gear.enchantments.types.DamageBoostEnchantment;
import com.infamous.dungeons_gear.init.DeferredItemInit;
import com.infamous.dungeons_gear.utilties.AOECloudHelper;
import com.infamous.dungeons_gear.utilties.AreaOfEffectHelper;
import com.infamous.dungeons_gear.utilties.ModEnchantmentHelper;
import net.minecraft.enchantment.DamageEnchantment;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="dungeons_gear")
public class SwirlingEnchantment
extends AOEDamageEnchantment {
    public static final float SWIRLING_DAMAGE_MULTIPLIER = 0.5f;

    public SwirlingEnchantment() {
        super(Enchantment.Rarity.RARE, ModEnchantmentTypes.MELEE, new EquipmentSlotType[]{EquipmentSlotType.MAINHAND});
    }

    public int func_77325_b() {
        return 3;
    }

    public boolean func_77326_a(Enchantment enchantment) {
        return (Boolean)DungeonsGearConfig.ENABLE_OVERPOWERED_ENCHANTMENT_COMBOS.get() != false || !(enchantment instanceof DamageEnchantment) && !(enchantment instanceof DamageBoostEnchantment) && !(enchantment instanceof AOEDamageEnchantment);
    }

    @SubscribeEvent
    public static void onVanillaCriticalHit(CriticalHitEvent event) {
        if (event.getPlayer() != null && event.isVanillaCritical()) {
            boolean uniqueWeaponFlag;
            PlayerEntity attacker = event.getPlayer();
            LivingEntity victim = event.getEntityLiving();
            ItemStack mainhand = attacker.func_184614_ca();
            boolean bl = uniqueWeaponFlag = mainhand.func_77973_b() == DeferredItemInit.SHEAR_DAGGER.get();
            if (ModEnchantmentHelper.hasEnchantment(mainhand, MeleeEnchantmentList.SWIRLING) || uniqueWeaponFlag) {
                int swirlingLevel = EnchantmentHelper.func_77506_a((Enchantment)MeleeEnchantmentList.SWIRLING, (ItemStack)mainhand);
                if (uniqueWeaponFlag) {
                    ++swirlingLevel;
                }
                float attackDamage = (float)attacker.func_233637_b_(Attributes.field_233823_f_);
                float cooledAttackStrength = attacker.func_184825_o(0.5f);
                float swirlingDamage = (attackDamage *= 0.2f + cooledAttackStrength * cooledAttackStrength * 0.8f) * 0.5f;
                victim.field_70170_p.func_184148_a((PlayerEntity)null, victim.func_226277_ct_(), victim.func_226278_cu_(), victim.func_226281_cx_(), SoundEvents.field_187730_dW, SoundCategory.PLAYERS, 64.0f, 1.0f);
                AOECloudHelper.spawnCritCloud((LivingEntity)attacker, victim, 1.5f);
                AreaOfEffectHelper.causeSwirlingAttack(attacker, victim, swirlingDamage *= (float)(swirlingLevel + 1) / 2.0f, 1.5f);
            }
        }
    }
}

