/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_gear.enchantments.melee_ranged;

import com.infamous.dungeons_gear.DungeonsGear;
import com.infamous.dungeons_gear.config.DungeonsGearConfig;
import com.infamous.dungeons_gear.enchantments.ModEnchantmentTypes;
import com.infamous.dungeons_gear.enchantments.lists.MeleeRangedEnchantmentList;
import com.infamous.dungeons_gear.enchantments.types.AOEDamageEnchantment;
import com.infamous.dungeons_gear.enchantments.types.DamageBoostEnchantment;
import com.infamous.dungeons_gear.init.DeferredItemInit;
import com.infamous.dungeons_gear.utilties.ModEnchantmentHelper;
import net.minecraft.enchantment.DamageEnchantment;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.ParticleTypes;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="dungeons_gear")
public class EnigmaResonatorEnchantment
extends DamageBoostEnchantment {
    public EnigmaResonatorEnchantment() {
        super(Enchantment.Rarity.RARE, ModEnchantmentTypes.MELEE_RANGED, new EquipmentSlotType[]{EquipmentSlotType.MAINHAND});
    }

    public int func_77325_b() {
        return 3;
    }

    public boolean func_77326_a(Enchantment enchantment) {
        return (Boolean)DungeonsGearConfig.ENABLE_OVERPOWERED_ENCHANTMENT_COMBOS.get() != false || !(enchantment instanceof DamageEnchantment) && !(enchantment instanceof DamageBoostEnchantment) && !(enchantment instanceof AOEDamageEnchantment);
    }

    @SubscribeEvent
    public static void onVanillaNonCriticalHit(CriticalHitEvent event) {
        if (event.getPlayer() == null) {
            return;
        }
        PlayerEntity attacker = event.getPlayer();
        LivingEntity victim = event.getEntityLiving();
        ItemStack mainhand = attacker.func_184614_ca();
        boolean uniqueWeaponFlag = mainhand.func_77973_b() == DeferredItemInit.SOUL_FIST.get() || mainhand.func_77973_b() == DeferredItemInit.MOON_DAGGER.get();
        int numSouls = Math.min(attacker.field_71067_cb, 50);
        if (!event.isVanillaCritical()) {
            float soulsCriticalBoostRand;
            if (ModEnchantmentHelper.hasEnchantment(mainhand, MeleeRangedEnchantmentList.ENIGMA_RESONATOR)) {
                int enigmaResonatorLevel = EnchantmentHelper.func_77506_a((Enchantment)MeleeRangedEnchantmentList.ENIGMA_RESONATOR, (ItemStack)mainhand);
                float soulsCriticalBoostChanceCap = 0.1f + 0.05f * (float)enigmaResonatorLevel;
                float soulsCriticalBoostRand2 = attacker.func_70681_au().nextFloat();
                if ((double)soulsCriticalBoostRand2 <= Math.min((double)numSouls / 50.0, (double)soulsCriticalBoostChanceCap)) {
                    event.setResult(Event.Result.ALLOW);
                    float newDamageModifier = event.getDamageModifier() == event.getOldDamageModifier() ? event.getDamageModifier() + 1.5f : event.getDamageModifier() * 3.0f;
                    event.setDamageModifier(newDamageModifier);
                    DungeonsGear.PROXY.spawnParticles((Entity)attacker, ParticleTypes.field_239812_C_);
                }
            }
            if (uniqueWeaponFlag && (double)(soulsCriticalBoostRand = attacker.func_70681_au().nextFloat()) <= Math.min((double)numSouls / 50.0, (double)0.15f)) {
                event.setResult(Event.Result.ALLOW);
                float newDamageModifier = event.getDamageModifier() == event.getOldDamageModifier() ? event.getDamageModifier() + 1.5f : event.getDamageModifier() * 3.0f;
                event.setDamageModifier(newDamageModifier);
                DungeonsGear.PROXY.spawnParticles((Entity)attacker, ParticleTypes.field_239812_C_);
            }
        }
    }
}

