/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_gear.enchantments.melee_ranged;

import com.infamous.dungeons_gear.capabilities.combo.ICombo;
import com.infamous.dungeons_gear.damagesources.OffhandAttackDamageSource;
import com.infamous.dungeons_gear.enchantments.ModEnchantmentTypes;
import com.infamous.dungeons_gear.enchantments.lists.MeleeRangedEnchantmentList;
import com.infamous.dungeons_gear.init.DeferredItemInit;
import com.infamous.dungeons_gear.utilties.AOECloudHelper;
import com.infamous.dungeons_gear.utilties.CapabilityHelper;
import com.infamous.dungeons_gear.utilties.ModEnchantmentHelper;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="dungeons_gear")
public class PoisonCloudEnchantment
extends Enchantment {
    public PoisonCloudEnchantment() {
        super(Enchantment.Rarity.RARE, ModEnchantmentTypes.MELEE_RANGED, new EquipmentSlotType[]{EquipmentSlotType.MAINHAND});
    }

    public int func_77325_b() {
        return 3;
    }

    public void func_151368_a(LivingEntity user, Entity target, int level) {
        if (!(target instanceof LivingEntity)) {
            return;
        }
        float chance = user.func_70681_au().nextFloat();
        if (chance <= 0.3f) {
            PoisonCloudEnchantment.checkForPlayer(user);
            AOECloudHelper.spawnPoisonCloud(user, (LivingEntity)target, level - 1);
        }
    }

    @SubscribeEvent
    public static void onPoisonousWeaponAttack(LivingAttackEvent event) {
        float chance;
        if (event.getSource().func_76364_f() instanceof AbstractArrowEntity) {
            return;
        }
        if (event.getSource() instanceof OffhandAttackDamageSource) {
            return;
        }
        if (!(event.getSource().func_76346_g() instanceof LivingEntity)) {
            return;
        }
        LivingEntity attacker = (LivingEntity)event.getSource().func_76346_g();
        LivingEntity victim = event.getEntityLiving();
        ItemStack mainhand = attacker.func_184614_ca();
        if ((mainhand.func_77973_b() == DeferredItemInit.VENOM_GLAIVE.get() || mainhand.func_77973_b() == DeferredItemInit.NIGHTMARES_BITE.get() || mainhand.func_77973_b() == DeferredItemInit.VINE_WHIP.get()) && (chance = attacker.func_70681_au().nextFloat()) <= 0.3f) {
            PoisonCloudEnchantment.checkForPlayer(attacker);
            AOECloudHelper.spawnPoisonCloud(attacker, victim, 0);
        }
    }

    @SubscribeEvent
    public static void onPoisonBowImpact(ProjectileImpactEvent.Arrow event) {
        BlockPos blockPos;
        BlockRayTraceResult blockRayTraceResult;
        float poisonRand;
        LivingEntity victim;
        EntityRayTraceResult entityRayTraceResult;
        RayTraceResult rayTraceResult = event.getRayTraceResult();
        AbstractArrowEntity arrow = event.getArrow();
        if (!ModEnchantmentHelper.shooterIsLiving(arrow)) {
            return;
        }
        LivingEntity shooter = (LivingEntity)arrow.func_234616_v_();
        int poisonLevel = ModEnchantmentHelper.enchantmentTagToLevel(arrow, MeleeRangedEnchantmentList.POISON_CLOUD);
        boolean uniqueWeaponFlag = arrow.func_184216_O().contains("TheGreenMenace");
        if (poisonLevel > 0) {
            if (rayTraceResult instanceof EntityRayTraceResult && (entityRayTraceResult = (EntityRayTraceResult)rayTraceResult).func_216348_a() instanceof LivingEntity) {
                victim = (LivingEntity)((EntityRayTraceResult)rayTraceResult).func_216348_a();
                poisonRand = shooter.func_70681_au().nextFloat();
                if (poisonRand <= 0.3f) {
                    PoisonCloudEnchantment.checkForPlayer(shooter);
                    AOECloudHelper.spawnPoisonCloud(shooter, victim, poisonLevel - 1);
                }
            }
            if (rayTraceResult instanceof BlockRayTraceResult) {
                blockRayTraceResult = (BlockRayTraceResult)rayTraceResult;
                blockPos = blockRayTraceResult.func_216350_a();
                poisonRand = shooter.func_70681_au().nextFloat();
                if (poisonRand <= 0.3f) {
                    PoisonCloudEnchantment.checkForPlayer(shooter);
                    AOECloudHelper.spawnPoisonCloudAtPos(shooter, true, blockPos, poisonLevel - 1);
                }
            }
        }
        if (uniqueWeaponFlag) {
            if (rayTraceResult instanceof EntityRayTraceResult && (entityRayTraceResult = (EntityRayTraceResult)rayTraceResult).func_216348_a() instanceof LivingEntity) {
                victim = (LivingEntity)((EntityRayTraceResult)rayTraceResult).func_216348_a();
                poisonRand = shooter.func_70681_au().nextFloat();
                if (poisonRand <= 0.3f) {
                    PoisonCloudEnchantment.checkForPlayer(shooter);
                    AOECloudHelper.spawnPoisonCloud(shooter, victim, 0);
                }
            }
            if (rayTraceResult instanceof BlockRayTraceResult) {
                blockRayTraceResult = (BlockRayTraceResult)rayTraceResult;
                blockPos = blockRayTraceResult.func_216350_a();
                poisonRand = shooter.func_70681_au().nextFloat();
                if (poisonRand <= 0.3f) {
                    PoisonCloudEnchantment.checkForPlayer(shooter);
                    AOECloudHelper.spawnPoisonCloudAtPos(shooter, true, blockPos, 0);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        PlayerEntity player = event.player;
        if (player == null) {
            return;
        }
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        if (player.func_70089_S()) {
            ICombo comboCap = CapabilityHelper.getComboCapability((Entity)player);
            if (comboCap == null) {
                return;
            }
            int poisonImmunityTimer = comboCap.getPoisonImmunityTimer();
            if (poisonImmunityTimer <= 0) {
                comboCap.setPoisonImmunityTimer(poisonImmunityTimer - 1);
            }
        }
    }

    @SubscribeEvent
    public static void onPoisonEvent(PotionEvent.PotionApplicableEvent event) {
        if (event.getPotionEffect().func_188419_a() == Effects.field_76436_u && event.getEntityLiving() instanceof PlayerEntity) {
            PlayerEntity playerEntity = (PlayerEntity)event.getEntityLiving();
            ICombo comboCap = CapabilityHelper.getComboCapability((Entity)playerEntity);
            if (comboCap == null) {
                return;
            }
            int poisonImmunityTimer = comboCap.getPoisonImmunityTimer();
            if (poisonImmunityTimer > 0) {
                event.setResult(Event.Result.DENY);
            }
        }
    }

    private static void checkForPlayer(LivingEntity livingEntity) {
        if (livingEntity instanceof PlayerEntity) {
            PlayerEntity playerEntity = (PlayerEntity)livingEntity;
            ICombo comboCap = CapabilityHelper.getComboCapability((Entity)playerEntity);
            if (comboCap == null) {
                return;
            }
            int poisonImmunityTimer = comboCap.getPoisonImmunityTimer();
            if (poisonImmunityTimer <= 0) {
                comboCap.setPoisonImmunityTimer(60);
            }
        }
    }
}

