/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_gear.enchantments.ranged;

import com.infamous.dungeons_gear.enchantments.ModEnchantmentTypes;
import com.infamous.dungeons_gear.enchantments.lists.RangedEnchantmentList;
import com.infamous.dungeons_gear.init.DeferredItemInit;
import com.infamous.dungeons_gear.utilties.ModEnchantmentHelper;
import com.infamous.dungeons_gear.utilties.ProjectileEffectHelper;
import com.infamous.dungeons_gear.utilties.RangedAttackHelper;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="dungeons_gear")
public class BonusShotEnchantment
extends Enchantment {
    public BonusShotEnchantment() {
        super(Enchantment.Rarity.RARE, ModEnchantmentTypes.RANGED, new EquipmentSlotType[]{EquipmentSlotType.MAINHAND});
    }

    public int func_77325_b() {
        return 3;
    }

    @SubscribeEvent
    public static void onCrossbowFired(PlayerInteractEvent.RightClickItem event) {
        PlayerEntity player = event.getPlayer();
        ItemStack stack = event.getItemStack();
        if (stack.func_77973_b() instanceof CrossbowItem && CrossbowItem.func_220012_d((ItemStack)stack)) {
            boolean uniqueWeaponFlag;
            boolean bl = uniqueWeaponFlag = stack.func_77973_b() == DeferredItemInit.BUTTERFLY_CROSSBOW.get();
            if (ModEnchantmentHelper.hasEnchantment(stack, RangedEnchantmentList.BONUS_SHOT) || uniqueWeaponFlag) {
                int bonusShotLevel = EnchantmentHelper.func_77506_a((Enchantment)RangedEnchantmentList.BONUS_SHOT, (ItemStack)stack);
                float damageMultiplier = 0.1f + ((float)bonusShotLevel - 0.07f);
                if (uniqueWeaponFlag) {
                    damageMultiplier += 0.1f;
                }
                float arrowVelocity = RangedAttackHelper.getvVanillaOrModdedCrossbowArrowVelocity(stack);
                ProjectileEffectHelper.fireBonusShotTowardsOtherEntity((LivingEntity)player, 10, damageMultiplier, arrowVelocity);
            }
        }
    }

    @SubscribeEvent
    public static void onBowFired(ArrowLooseEvent event) {
        boolean uniqueWeaponFlag;
        LivingEntity livingEntity = event.getEntityLiving();
        ItemStack stack = event.getBow();
        int charge = event.getCharge();
        boolean bl = uniqueWeaponFlag = stack.func_77973_b() == DeferredItemInit.TWIN_BOW.get() || stack.func_77973_b() == DeferredItemInit.HAUNTED_BOW.get();
        if (ModEnchantmentHelper.hasEnchantment(stack, RangedEnchantmentList.BONUS_SHOT) || uniqueWeaponFlag) {
            float arrowVelocity;
            int bonusShotLevel = EnchantmentHelper.func_77506_a((Enchantment)RangedEnchantmentList.BONUS_SHOT, (ItemStack)stack);
            float damageMultiplier = 0.1f + ((float)bonusShotLevel - 0.07f);
            if (uniqueWeaponFlag) {
                damageMultiplier += 0.1f;
            }
            if ((arrowVelocity = RangedAttackHelper.getVanillaOrModdedBowArrowVelocity(stack, charge)) >= 0.1f) {
                ProjectileEffectHelper.fireBonusShotTowardsOtherEntity(livingEntity, 10, damageMultiplier, arrowVelocity);
            }
        }
    }
}

