/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_gear.enchantments.ranged;

import com.infamous.dungeons_gear.enchantments.ModEnchantmentTypes;
import com.infamous.dungeons_gear.enchantments.lists.RangedEnchantmentList;
import com.infamous.dungeons_gear.utilties.ModEnchantmentHelper;
import com.infamous.dungeons_gear.utilties.ProjectileEffectHelper;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="dungeons_gear")
public class ChainReactionEnchantment
extends Enchantment {
    public ChainReactionEnchantment() {
        super(Enchantment.Rarity.RARE, ModEnchantmentTypes.RANGED, new EquipmentSlotType[]{EquipmentSlotType.MAINHAND});
    }

    public int func_77325_b() {
        return 3;
    }

    @SubscribeEvent
    public static void onChainReactionDamage(LivingDamageEvent event) {
        IndirectEntityDamageSource indirectEntityDamageSource;
        if (event.getSource() instanceof IndirectEntityDamageSource && (indirectEntityDamageSource = (IndirectEntityDamageSource)event.getSource()).func_76364_f() instanceof AbstractArrowEntity) {
            AbstractArrowEntity arrowEntity = (AbstractArrowEntity)indirectEntityDamageSource.func_76364_f();
            LivingEntity victim = event.getEntityLiving();
            if (indirectEntityDamageSource.func_76346_g() instanceof LivingEntity) {
                float chainReactionRand;
                if (!(indirectEntityDamageSource.func_76346_g() instanceof LivingEntity)) {
                    return;
                }
                LivingEntity attacker = (LivingEntity)indirectEntityDamageSource.func_76346_g();
                int chainReactionLevel = ModEnchantmentHelper.enchantmentTagToLevel(arrowEntity, RangedEnchantmentList.CHAIN_REACTION);
                if (chainReactionLevel > 0) {
                    float chainReactionRand2;
                    float chainReactionChance = 0.0f;
                    if (chainReactionLevel == 1) {
                        chainReactionChance = 0.1f;
                    }
                    if (chainReactionLevel == 2) {
                        chainReactionChance = 0.2f;
                    }
                    if (chainReactionLevel == 3) {
                        chainReactionChance = 0.3f;
                    }
                    if ((chainReactionRand2 = attacker.func_70681_au().nextFloat()) <= chainReactionChance) {
                        ProjectileEffectHelper.fireChainReactionProjectiles(victim.func_130014_f_(), attacker, victim, 3.15f, 1.0f, arrowEntity);
                    }
                }
                if (arrowEntity.func_184216_O().contains("FireboltThrower") && (chainReactionRand = attacker.func_70681_au().nextFloat()) <= 0.1f) {
                    ProjectileEffectHelper.fireChainReactionProjectiles(victim.func_130014_f_(), attacker, victim, 3.15f, 1.0f, arrowEntity);
                }
            }
        }
    }
}

