/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_gear.enchantments.ranged;

import com.infamous.dungeons_gear.enchantments.ModEnchantmentTypes;
import com.infamous.dungeons_gear.utilties.AOECloudHelper;
import com.infamous.dungeons_gear.utilties.AreaOfEffectHelper;
import com.infamous.dungeons_gear.utilties.ModEnchantmentHelper;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="dungeons_gear")
public class FuseShotEnchantment
extends Enchantment {
    public FuseShotEnchantment() {
        super(Enchantment.Rarity.RARE, ModEnchantmentTypes.RANGED, new EquipmentSlotType[]{EquipmentSlotType.MAINHAND});
    }

    public int func_77325_b() {
        return 3;
    }

    @SubscribeEvent
    public static void onFuseShotImpact(ProjectileImpactEvent.Arrow event) {
        AbstractArrowEntity arrowEntity = event.getArrow();
        if (ModEnchantmentHelper.shooterIsLiving(arrowEntity)) {
            LivingEntity shooter = (LivingEntity)arrowEntity.func_234616_v_();
            if (arrowEntity.func_184216_O().contains("FuseShot") && event.getRayTraceResult() instanceof BlockRayTraceResult) {
                BlockRayTraceResult blockRayTraceResult = (BlockRayTraceResult)event.getRayTraceResult();
                BlockPos blockPos = blockRayTraceResult.func_216350_a();
                float f = (float)arrowEntity.func_213322_ci().func_72433_c();
                int damage = MathHelper.func_76143_f((double)MathHelper.func_151237_a((double)((double)f * arrowEntity.func_70242_d()), (double)0.0, (double)2.147483647E9));
                if (arrowEntity.func_70241_g()) {
                    long criticalDamageBonus = shooter.func_70681_au().nextInt(damage / 2 + 2);
                    damage = (int)Math.min(criticalDamageBonus + (long)damage, Integer.MAX_VALUE);
                }
                arrowEntity.field_70170_p.func_184148_a((PlayerEntity)null, (double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p(), SoundEvents.field_187539_bB, SoundCategory.PLAYERS, 64.0f, 1.0f);
                AOECloudHelper.spawnExplosionCloudAtPos(shooter, true, blockPos, 3.0f);
                AreaOfEffectHelper.causeExplosionAttackAtPos(shooter, true, blockPos, damage, 3.0f);
            }
        }
    }

    @SubscribeEvent
    public static void onFuseShotDamage(LivingDamageEvent event) {
        IndirectEntityDamageSource indirectEntityDamageSource;
        if (event.getSource() instanceof IndirectEntityDamageSource && (indirectEntityDamageSource = (IndirectEntityDamageSource)event.getSource()).func_76364_f() instanceof AbstractArrowEntity) {
            AbstractArrowEntity arrowEntity = (AbstractArrowEntity)indirectEntityDamageSource.func_76364_f();
            LivingEntity victim = event.getEntityLiving();
            if (indirectEntityDamageSource.func_76346_g() instanceof LivingEntity) {
                LivingEntity archer = (LivingEntity)indirectEntityDamageSource.func_76346_g();
                if (arrowEntity.func_184216_O().contains("FuseShot")) {
                    victim.field_70170_p.func_184148_a((PlayerEntity)null, victim.func_226277_ct_(), victim.func_226278_cu_(), victim.func_226281_cx_(), SoundEvents.field_187539_bB, SoundCategory.PLAYERS, 64.0f, 1.0f);
                    AOECloudHelper.spawnExplosionCloud(archer, victim, 3.0f);
                    AreaOfEffectHelper.causeExplosionAttack(archer, victim, event.getAmount(), 3.0f);
                }
            }
        }
    }
}

