/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_gear.enchantments.ranged;

import com.infamous.dungeons_gear.config.DungeonsGearConfig;
import com.infamous.dungeons_gear.enchantments.lists.RangedEnchantmentList;
import com.infamous.dungeons_gear.utilties.ModEnchantmentHelper;
import com.infamous.dungeons_gear.utilties.ProjectileEffectHelper;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="dungeons_gear")
public class RicochetEnchantment
extends Enchantment {
    public RicochetEnchantment() {
        super(Enchantment.Rarity.RARE, EnchantmentType.CROSSBOW, new EquipmentSlotType[]{EquipmentSlotType.MAINHAND});
    }

    public int func_77325_b() {
        return 3;
    }

    public boolean func_77326_a(Enchantment enchantment) {
        return (Boolean)DungeonsGearConfig.ENABLE_OVERPOWERED_ENCHANTMENT_COMBOS.get() != false || enchantment != Enchantments.field_222194_I;
    }

    @SubscribeEvent
    public static void onRicochetImpact(ProjectileImpactEvent.Arrow event) {
        float chainReactionRand;
        boolean uniqueWeaponFlag;
        RayTraceResult rayTraceResult = event.getRayTraceResult();
        AbstractArrowEntity arrowEntity = event.getArrow();
        if (!ModEnchantmentHelper.shooterIsLiving(arrowEntity)) {
            return;
        }
        LivingEntity shooter = (LivingEntity)arrowEntity.func_234616_v_();
        if (!ModEnchantmentHelper.arrowHitLivingEntity(rayTraceResult)) {
            return;
        }
        EntityRayTraceResult entityRayTraceResult = (EntityRayTraceResult)rayTraceResult;
        LivingEntity victim = (LivingEntity)entityRayTraceResult.func_216348_a();
        int ricochetLevel = ModEnchantmentHelper.enchantmentTagToLevel(arrowEntity, RangedEnchantmentList.RICOCHET);
        boolean bl = uniqueWeaponFlag = arrowEntity.func_184216_O().contains("LightningHarpCrossbow") || arrowEntity.func_184216_O().contains("SlayerCrossbow");
        if (ricochetLevel > 0 && (chainReactionRand = shooter.func_70681_au().nextFloat()) <= 0.2f * (float)ricochetLevel) {
            ProjectileEffectHelper.ricochetArrowTowardsOtherEntity(shooter, victim, arrowEntity, 10);
        }
        if (uniqueWeaponFlag && (chainReactionRand = shooter.func_70681_au().nextFloat()) <= 0.2f) {
            ProjectileEffectHelper.ricochetArrowTowardsOtherEntity(shooter, victim, arrowEntity, 10);
        }
    }
}

