/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_gear.enchantments.ranged;

import com.infamous.dungeons_gear.enchantments.ModEnchantmentTypes;
import com.infamous.dungeons_gear.enchantments.lists.RangedEnchantmentList;
import com.infamous.dungeons_gear.utilties.AbilityHelper;
import com.infamous.dungeons_gear.utilties.ModEnchantmentHelper;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="dungeons_gear")
public class WildRageEnchantment
extends Enchantment {
    public WildRageEnchantment() {
        super(Enchantment.Rarity.RARE, ModEnchantmentTypes.ARMOR_RANGED, new EquipmentSlotType[]{EquipmentSlotType.MAINHAND, EquipmentSlotType.HEAD, EquipmentSlotType.CHEST, EquipmentSlotType.LEGS, EquipmentSlotType.FEET});
    }

    public int func_77325_b() {
        return 3;
    }

    @SubscribeEvent
    public static void onPinkScoundrelImpact(ProjectileImpactEvent.Arrow event) {
        float chance;
        RayTraceResult rayTraceResult = event.getRayTraceResult();
        if (!ModEnchantmentHelper.arrowHitMob(rayTraceResult)) {
            return;
        }
        AbstractArrowEntity arrow = event.getArrow();
        if (!ModEnchantmentHelper.shooterIsLiving(arrow)) {
            return;
        }
        LivingEntity shooter = (LivingEntity)arrow.func_234616_v_();
        int wildRageLevel = ModEnchantmentHelper.enchantmentTagToLevel(arrow, RangedEnchantmentList.WILD_RAGE);
        boolean uniqueWeaponFlag = arrow.func_184216_O().contains("ThePinkScoundrel");
        MobEntity victim = (MobEntity)((EntityRayTraceResult)rayTraceResult).func_216348_a();
        if (!(victim instanceof IMob) || !victim.func_184222_aU()) {
            return;
        }
        if (wildRageLevel > 0) {
            float wildRageChance = 0.1f;
            wildRageChance += (float)wildRageLevel * 0.1f;
            float chance2 = shooter.func_70681_au().nextFloat();
            if (chance2 <= wildRageChance) {
                AbilityHelper.sendIntoWildRage(victim);
            }
        }
        if (uniqueWeaponFlag && (chance = shooter.func_70681_au().nextFloat()) <= 0.2f) {
            AbilityHelper.sendIntoWildRage(victim);
        }
    }

    @SubscribeEvent
    public static void onWildRageAttack(LivingAttackEvent event) {
        if (!(event.getSource().func_76346_g() instanceof LivingEntity)) {
            return;
        }
        LivingEntity attacker = (LivingEntity)event.getSource().func_76346_g();
        LivingEntity victim = event.getEntityLiving();
        if (!(victim instanceof IMob) || !victim.func_184222_aU()) {
            return;
        }
        MobEntity enemy = (MobEntity)victim;
        if (ModEnchantmentHelper.hasEnchantment(attacker, RangedEnchantmentList.WILD_RAGE)) {
            int wildRageLevel = EnchantmentHelper.func_185284_a((Enchantment)RangedEnchantmentList.WILD_RAGE, (LivingEntity)attacker);
            float wildRageChance = 0.1f;
            wildRageChance += (float)wildRageLevel * 0.1f;
            float chance = attacker.func_70681_au().nextFloat();
            if (chance <= wildRageChance) {
                AbilityHelper.sendIntoWildRage(enemy);
            }
        }
    }
}

