/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_gear.goals;

import com.infamous.dungeons_gear.goals.GoalUtils;
import java.util.EnumSet;
import net.minecraft.block.BlockState;
import net.minecraft.block.LeavesBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.WalkNodeProcessor;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;

public class BeeFollowOwnerGoal
extends Goal {
    private final BeeEntity beeEntity;
    private LivingEntity owner;
    private final IWorldReader world;
    private final double followSpeed;
    private final PathNavigator navigator;
    private int timeToRecalcPath;
    private final float maxDist;
    private final float minDist;
    private float oldWaterCost;
    private final boolean passesThroughLeaves;

    public BeeFollowOwnerGoal(BeeEntity beeEntity, double followSpeed, float minDist, float maxDist, boolean passesThroughLeaves) {
        this.beeEntity = beeEntity;
        this.world = beeEntity.field_70170_p;
        this.followSpeed = followSpeed;
        this.navigator = beeEntity.func_70661_as();
        this.minDist = minDist;
        this.maxDist = maxDist;
        this.passesThroughLeaves = passesThroughLeaves;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        if (!(beeEntity.func_70661_as() instanceof GroundPathNavigator) && !(beeEntity.func_70661_as() instanceof FlyingPathNavigator)) {
            throw new IllegalArgumentException("Unsupported mob type for FollowOwnerGoal");
        }
    }

    public boolean func_75250_a() {
        LivingEntity livingentity = GoalUtils.getOwner(this.beeEntity);
        if (livingentity == null) {
            return false;
        }
        if (livingentity.func_175149_v()) {
            return false;
        }
        if (this.beeEntity.func_110167_bD()) {
            return false;
        }
        if (this.beeEntity.func_70068_e((Entity)livingentity) < (double)(this.minDist * this.minDist)) {
            return false;
        }
        this.owner = livingentity;
        return true;
    }

    public boolean func_75253_b() {
        if (this.navigator.func_75500_f()) {
            return false;
        }
        if (this.beeEntity.func_110167_bD()) {
            return false;
        }
        return !(this.beeEntity.func_70068_e((Entity)this.owner) <= (double)(this.maxDist * this.maxDist));
    }

    public void func_75249_e() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.beeEntity.func_184643_a(PathNodeType.WATER);
        this.beeEntity.func_184644_a(PathNodeType.WATER, 0.0f);
    }

    public void func_75251_c() {
        this.owner = null;
        this.navigator.func_75499_g();
        this.beeEntity.func_184644_a(PathNodeType.WATER, this.oldWaterCost);
    }

    public void func_75246_d() {
        this.beeEntity.func_70671_ap().func_75651_a((Entity)this.owner, 10.0f, (float)this.beeEntity.func_70646_bf());
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = 10;
            if (!this.beeEntity.func_110167_bD() && !this.beeEntity.func_184218_aH()) {
                if (this.beeEntity.func_70068_e((Entity)this.owner) >= 144.0) {
                    this.func_226330_g_();
                } else {
                    this.navigator.func_75497_a((Entity)this.owner, this.followSpeed);
                }
            }
        }
    }

    private void func_226330_g_() {
        BlockPos blockpos = this.owner.func_233580_cy_();
        for (int i = 0; i < 10; ++i) {
            int j = this.func_226327_a_(-3, 3);
            int k = this.func_226327_a_(-1, 1);
            int l = this.func_226327_a_(-3, 3);
            boolean flag = this.func_226328_a_(blockpos.func_177958_n() + j, blockpos.func_177956_o() + k, blockpos.func_177952_p() + l);
            if (!flag) continue;
            return;
        }
    }

    private boolean func_226328_a_(int p_226328_1_, int p_226328_2_, int p_226328_3_) {
        if (Math.abs((double)p_226328_1_ - this.owner.func_226277_ct_()) < 2.0 && Math.abs((double)p_226328_3_ - this.owner.func_226281_cx_()) < 2.0) {
            return false;
        }
        if (!this.func_226329_a_(new BlockPos(p_226328_1_, p_226328_2_, p_226328_3_))) {
            return false;
        }
        this.beeEntity.func_70012_b((double)p_226328_1_ + 0.5, (double)p_226328_2_, (double)p_226328_3_ + 0.5, this.beeEntity.field_70177_z, this.beeEntity.field_70125_A);
        this.navigator.func_75499_g();
        return true;
    }

    private boolean func_226329_a_(BlockPos p_226329_1_) {
        PathNodeType pathnodetype = WalkNodeProcessor.func_237231_a_((IBlockReader)this.world, (BlockPos.Mutable)p_226329_1_.func_239590_i_());
        if (pathnodetype != PathNodeType.WALKABLE) {
            return false;
        }
        BlockState blockstate = this.world.func_180495_p(p_226329_1_.func_177977_b());
        if (!this.passesThroughLeaves && blockstate.func_177230_c() instanceof LeavesBlock) {
            return false;
        }
        BlockPos blockpos = p_226329_1_.func_177973_b((Vector3i)this.beeEntity.func_233580_cy_());
        return this.world.func_226665_a__((Entity)this.beeEntity, this.beeEntity.func_174813_aQ().func_186670_a(blockpos));
    }

    private int func_226327_a_(int p_226327_1_, int p_226327_2_) {
        return this.beeEntity.func_70681_au().nextInt(p_226327_2_ - p_226327_1_ + 1) + p_226327_1_;
    }
}

