/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_gear.goals;

import com.infamous.dungeons_gear.capabilities.summoning.ISummonable;
import com.infamous.dungeons_gear.utilties.CapabilityHelper;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.GhastEntity;
import net.minecraft.entity.passive.BatEntity;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.entity.passive.CatEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.passive.horse.LlamaEntity;
import net.minecraft.entity.player.PlayerEntity;

public class GoalUtils {
    @Nullable
    public static LivingEntity getOwner(AbstractHorseEntity abstractHorseEntity) {
        try {
            UUID ownerUniqueId = abstractHorseEntity.func_184780_dh();
            return ownerUniqueId == null ? null : abstractHorseEntity.field_70170_p.func_217371_b(ownerUniqueId);
        }
        catch (IllegalArgumentException var2) {
            return null;
        }
    }

    @Nullable
    public static LivingEntity getOwner(IronGolemEntity ironGolemEntity) {
        try {
            ISummonable summonable = CapabilityHelper.getSummonableCapability((Entity)ironGolemEntity);
            if (summonable == null) {
                return null;
            }
            if (summonable.getSummoner() != null) {
                UUID ownerUniqueId = summonable.getSummoner();
                return ownerUniqueId == null ? null : ironGolemEntity.field_70170_p.func_217371_b(ownerUniqueId);
            }
            return null;
        }
        catch (IllegalArgumentException var2) {
            return null;
        }
    }

    @Nullable
    public static LivingEntity getOwner(BatEntity batEntity) {
        try {
            ISummonable summonable = CapabilityHelper.getSummonableCapability((Entity)batEntity);
            if (summonable == null) {
                return null;
            }
            if (summonable.getSummoner() != null) {
                UUID ownerUniqueId = summonable.getSummoner();
                return ownerUniqueId == null ? null : batEntity.field_70170_p.func_217371_b(ownerUniqueId);
            }
            return null;
        }
        catch (IllegalArgumentException var2) {
            return null;
        }
    }

    @Nullable
    public static LivingEntity getOwner(BeeEntity beeEntity) {
        try {
            ISummonable summonable = CapabilityHelper.getSummonableCapability((Entity)beeEntity);
            if (summonable == null) {
                return null;
            }
            if (summonable.getSummoner() != null) {
                UUID ownerUniqueId = summonable.getSummoner();
                return ownerUniqueId == null ? null : beeEntity.field_70170_p.func_217371_b(ownerUniqueId);
            }
            return null;
        }
        catch (IllegalArgumentException var2) {
            return null;
        }
    }

    @Nullable
    public static LivingEntity getOwner(SheepEntity sheepEntity) {
        try {
            ISummonable summonable = CapabilityHelper.getSummonableCapability((Entity)sheepEntity);
            if (summonable == null) {
                return null;
            }
            if (summonable.getSummoner() != null) {
                UUID ownerUniqueId = summonable.getSummoner();
                return ownerUniqueId == null ? null : sheepEntity.field_70170_p.func_217371_b(ownerUniqueId);
            }
            return null;
        }
        catch (IllegalArgumentException var2) {
            return null;
        }
    }

    public static boolean shouldAttackEntity(LivingEntity target, LivingEntity owner) {
        if (!(target instanceof CreeperEntity) && !(target instanceof GhastEntity)) {
            LlamaEntity llamaEntity;
            IronGolemEntity ironGolemEntity;
            WolfEntity wolfentity;
            if (target instanceof WolfEntity && (wolfentity = (WolfEntity)target).func_70909_n() && wolfentity.func_70902_q() == owner) {
                return false;
            }
            if (target instanceof IronGolemEntity && (ironGolemEntity = (IronGolemEntity)target).func_70850_q() && GoalUtils.getOwner(ironGolemEntity) == owner) {
                return false;
            }
            if (target instanceof LlamaEntity && (llamaEntity = (LlamaEntity)target).func_110248_bS() && GoalUtils.getOwner((AbstractHorseEntity)llamaEntity) == owner) {
                return false;
            }
            if (target instanceof BatEntity && GoalUtils.getOwner((BatEntity)(llamaEntity = (BatEntity)target)) == owner) {
                return false;
            }
            if (target instanceof BeeEntity && GoalUtils.getOwner((BeeEntity)(llamaEntity = (BeeEntity)target)) == owner) {
                return false;
            }
            if (target instanceof PlayerEntity && owner instanceof PlayerEntity && !((PlayerEntity)owner).func_96122_a((PlayerEntity)target)) {
                return false;
            }
            if (target instanceof AbstractHorseEntity && ((AbstractHorseEntity)target).func_110248_bS()) {
                return false;
            }
            return !(target instanceof CatEntity) || !((CatEntity)target).func_70909_n();
        }
        return false;
    }
}

