/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_gear.goals;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;

public class ModdedEntityPredicate
extends EntityPredicate {
    public static final EntityPredicate DEFAULT = new EntityPredicate();
    private double distance = -1.0;
    private boolean allowInvulnerable;
    private boolean friendlyFire;
    private boolean requireLineOfSight;
    private boolean skipAttackChecks;
    private boolean useVisibilityModifier = true;
    private Predicate<LivingEntity> customPredicate;

    public EntityPredicate func_221013_a(double p_221013_1_) {
        this.distance = p_221013_1_;
        return this;
    }

    public EntityPredicate func_221008_a() {
        this.allowInvulnerable = true;
        return this;
    }

    public EntityPredicate func_221011_b() {
        this.friendlyFire = true;
        return this;
    }

    public EntityPredicate func_221014_c() {
        this.requireLineOfSight = true;
        return this;
    }

    public EntityPredicate func_221009_d() {
        this.skipAttackChecks = true;
        return this;
    }

    public EntityPredicate func_221010_e() {
        this.useVisibilityModifier = false;
        return this;
    }

    public EntityPredicate func_221012_a(@Nullable Predicate<LivingEntity> p_221012_1_) {
        this.customPredicate = p_221012_1_;
        return this;
    }

    public boolean func_221015_a(@Nullable LivingEntity goalOwner, LivingEntity targetEntity) {
        if (goalOwner == targetEntity) {
            return false;
        }
        if (targetEntity.func_175149_v()) {
            return false;
        }
        if (!targetEntity.func_70089_S()) {
            return false;
        }
        if (!this.allowInvulnerable && targetEntity.func_190530_aW()) {
            return false;
        }
        if (this.customPredicate != null && !this.customPredicate.test(targetEntity)) {
            return false;
        }
        if (goalOwner != null) {
            if (!this.skipAttackChecks) {
                if (!goalOwner.func_213336_c(targetEntity)) {
                    return false;
                }
                if (!goalOwner.func_213358_a(targetEntity.func_200600_R())) {
                    return false;
                }
            }
            if (!this.friendlyFire && goalOwner.func_184191_r((Entity)targetEntity)) {
                return false;
            }
            if (this.distance > 0.0) {
                double visibilityModifier = this.useVisibilityModifier ? targetEntity.func_213340_A((Entity)goalOwner) : 1.0;
                double distanceModified = this.distance * visibilityModifier;
                double squareDistanceTo = goalOwner.func_70092_e(targetEntity.func_226277_ct_(), targetEntity.func_226278_cu_(), targetEntity.func_226281_cx_());
                if (squareDistanceTo > distanceModified * distanceModified) {
                    return false;
                }
            }
            if (!this.requireLineOfSight && goalOwner instanceof MobEntity && !((MobEntity)goalOwner).func_70635_at().func_75522_a((Entity)targetEntity)) {
                return false;
            }
        }
        return true;
    }
}

