/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_gear.items;

import com.infamous.dungeons_gear.config.DungeonsGearConfig;
import com.infamous.dungeons_gear.items.ItemTagWrappers;
import java.util.function.Supplier;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.LazyValue;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;

public enum ArmorMaterialList implements IArmorMaterial
{
    VEST("vest", (Integer)DungeonsGearConfig.VEST_ARMOR_DURABILITY.get(), new int[]{2, 5, 6, 2}, 9, () -> Ingredient.func_199805_a(ItemTagWrappers.NON_METAL_ARMOR_REPAIR_ITEMS), SoundEvents.field_187728_s, 0.0f, 0.0f),
    ROBE("robe", (Integer)DungeonsGearConfig.ROBE_ARMOR_DURABILITY.get(), new int[]{2, 5, 6, 2}, 9, () -> Ingredient.func_199805_a(ItemTagWrappers.NON_METAL_ARMOR_REPAIR_ITEMS), SoundEvents.field_187728_s, 0.0f, 0.0f),
    PELT("pelt", (Integer)DungeonsGearConfig.PELT_ARMOR_DURABILITY.get(), new int[]{2, 5, 6, 2}, 9, () -> Ingredient.func_199805_a(ItemTagWrappers.NON_METAL_ARMOR_REPAIR_ITEMS), SoundEvents.field_187728_s, 0.0f, 0.0f),
    BONE("bone", (Integer)DungeonsGearConfig.BONE_ARMOR_DURABILITY.get(), new int[]{2, 5, 6, 2}, 9, () -> Ingredient.func_199805_a(ItemTagWrappers.NON_METAL_ARMOR_REPAIR_ITEMS), SoundEvents.field_203254_u, 0.0f, 0.0f),
    LIGHT_PLATE("light_plate", (Integer)DungeonsGearConfig.LIGHT_PLATE_ARMOR_DURABILITY.get(), new int[]{2, 5, 6, 2}, 9, () -> Ingredient.func_199805_a(ItemTagWrappers.METAL_ARMOR_REPAIR_ITEMS), SoundEvents.field_187725_r, 0.0f, 0.0f),
    MEDIUM_PLATE("medium_plate", (Integer)DungeonsGearConfig.MEDIUM_PLATE_ARMOR_DURABILITY.get(), new int[]{2, 5, 6, 2}, 9, () -> Ingredient.func_199805_a(ItemTagWrappers.METAL_ARMOR_REPAIR_ITEMS), SoundEvents.field_187725_r, 2.0f, 0.0f),
    HEAVY_PLATE("heavy_plate", (Integer)DungeonsGearConfig.HEAVY_PLATE_ARMOR_DURABILITY.get(), new int[]{2, 5, 6, 2}, 9, () -> Ingredient.func_199805_a(ItemTagWrappers.METAL_ARMOR_REPAIR_ITEMS), SoundEvents.field_187725_r, 2.0f, 0.0f);

    private static final int[] MAX_DAMAGE_ARRAY;
    private String name;
    private SoundEvent equipSound;
    private int durability;
    private int enchantability;
    private final LazyValue<Ingredient> repairItem;
    private int[] damageReductionAmounts;
    private float toughness;
    private float knockbackResistance;

    private ArmorMaterialList(String name, int durability, int[] damageReductionAmounts, int enchantability, Supplier<Ingredient> repairItem, SoundEvent equipSound, float toughness, float knockbackResistance) {
        this.name = name;
        this.equipSound = equipSound;
        this.durability = durability;
        this.enchantability = enchantability;
        this.repairItem = new LazyValue(repairItem);
        this.damageReductionAmounts = damageReductionAmounts;
        this.toughness = toughness;
        this.knockbackResistance = knockbackResistance;
    }

    public int func_200902_b(EquipmentSlotType slot) {
        return this.damageReductionAmounts[slot.func_188454_b()];
    }

    public int func_200896_a(EquipmentSlotType slot) {
        return MAX_DAMAGE_ARRAY[slot.func_188454_b()] * this.durability;
    }

    public int func_200900_a() {
        return this.enchantability;
    }

    public String func_200897_d() {
        return "dungeons_gear:" + this.name;
    }

    public Ingredient func_200898_c() {
        return (Ingredient)this.repairItem.func_179281_c();
    }

    public SoundEvent func_200899_b() {
        return this.equipSound;
    }

    public float func_200901_e() {
        return this.toughness;
    }

    public float func_230304_f_() {
        return this.knockbackResistance;
    }

    static {
        MAX_DAMAGE_ARRAY = new int[]{13, 15, 16, 11};
    }

    private static class Constants {
        public static final String VEST_NAME = "vest";
        public static final String ROBE_NAME = "robe";
        public static final String PELT_NAME = "pelt";
        public static final String BONE_NAME = "bone";
        public static final String LIGHT_PLATE_NAME = "light_plate";
        public static final String MEDIUM_PLATE_NAME = "medium_plate";
        public static final String HEAVY_PLATE_NAME = "heavy_plate";

        private Constants() {
        }
    }
}

