/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_gear.loot;

import com.infamous.dungeons_gear.init.DeferredItemInit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;

public class ChestLootHelper {
    private static Random myRNG = new Random();

    public static List<ItemStack> generateLootFromValues(double uniqueItemChance, double artifactChance) {
        Item commonMeleeWeapon = ChestLootHelper.getRandomSetElement(DeferredItemInit.commonWeaponMap.keySet());
        Item uniqueMeleeWeapon = ChestLootHelper.getRandomSetElement(DeferredItemInit.uniqueWeaponMap.keySet());
        Item commonRangedWeapon = ChestLootHelper.getRandomSetElement(DeferredItemInit.commonRangedWeaponMap.keySet());
        Item uniqueRangedWeapon = ChestLootHelper.getRandomSetElement(DeferredItemInit.uniqueRangedWeaponMap.keySet());
        Item commonLeatherArmor = ChestLootHelper.getRandomSetElement(DeferredItemInit.commonLeatherArmorMap.keySet());
        Item uniqueLeatherArmor = ChestLootHelper.getRandomSetElement(DeferredItemInit.uniqueLeatherArmorMap.keySet());
        Item commonMetalArmor = ChestLootHelper.getRandomSetElement(DeferredItemInit.commonMetalArmorMap.keySet());
        Item uniqueMetalArmor = ChestLootHelper.getRandomSetElement(DeferredItemInit.uniqueMetalArmorMap.keySet());
        Item artifact = ChestLootHelper.getRandomSetElement(DeferredItemInit.artifactMap.keySet());
        ArrayList<ItemStack> generatedLoot = new ArrayList<ItemStack>(Collections.emptyList());
        ChestLootHelper.pickFromTwoTypes(uniqueItemChance, commonMeleeWeapon, uniqueMeleeWeapon, commonRangedWeapon, uniqueRangedWeapon, generatedLoot);
        ChestLootHelper.pickFromTwoTypes(uniqueItemChance, commonLeatherArmor, uniqueLeatherArmor, commonMetalArmor, uniqueMetalArmor, generatedLoot);
        ChestLootHelper.addArtifact(artifactChance, artifact, generatedLoot);
        return generatedLoot;
    }

    private static void addArtifact(double artifactChance, Item artifact, List<ItemStack> generatedLoot) {
        if (myRNG.nextDouble() < artifactChance) {
            generatedLoot.add(new ItemStack((IItemProvider)artifact));
        }
    }

    private static void pickFromTwoTypes(double uniqueItemChance, Item commonItem1, Item uniqueItem1, Item commonItem2, Item uniqueItem2, List<ItemStack> generatedLoot) {
        if (myRNG.nextBoolean()) {
            ChestLootHelper.addCommonOrUnique(uniqueItemChance, commonItem1, uniqueItem1, generatedLoot);
        } else {
            ChestLootHelper.addCommonOrUnique(uniqueItemChance, commonItem2, uniqueItem2, generatedLoot);
        }
    }

    private static void addCommonOrUnique(double uniqueItemChance, Item commonItem, Item uniqueItem, List<ItemStack> generatedLoot) {
        if (myRNG.nextDouble() < uniqueItemChance) {
            generatedLoot.add(new ItemStack((IItemProvider)uniqueItem));
        } else {
            generatedLoot.add(new ItemStack((IItemProvider)commonItem));
        }
    }

    public static Item getRandomSetElement(Set<Item> set) {
        int index = myRNG.nextInt(set.size());
        Iterator<Item> iter = set.iterator();
        for (int i = 0; i < index; ++i) {
            iter.next();
        }
        return iter.next();
    }
}

