/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_gear.loot;

import com.google.gson.JsonObject;
import com.infamous.dungeons_gear.config.DungeonsGearConfig;
import com.infamous.dungeons_gear.loot.ChestLootHelper;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.minecart.ContainerMinecartEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class GlobalLootModifier {
    private static final String LOCKABLE_LOOT_TILE_ENTITY_LOOT_TABLE = "field_184284_m";
    private static final String CONTAINER_MINECART_ENTITY_LOOT_TABLE = "field_184290_c";

    private static ResourceLocation getLootTable(LockableLootTileEntity lockableLootTileEntity) {
        return (ResourceLocation)ObfuscationReflectionHelper.getPrivateValue(LockableLootTileEntity.class, (Object)lockableLootTileEntity, (String)LOCKABLE_LOOT_TILE_ENTITY_LOOT_TABLE);
    }

    private static ResourceLocation getLootTable(ContainerMinecartEntity containerMinecartEntity) {
        return (ResourceLocation)ObfuscationReflectionHelper.getPrivateValue(ContainerMinecartEntity.class, (Object)containerMinecartEntity, (String)CONTAINER_MINECART_ENTITY_LOOT_TABLE);
    }

    public static class SuperRareLootAdditions
    extends LootModifier {
        public SuperRareLootAdditions(ILootCondition[] conditionsIn) {
            super(conditionsIn);
        }

        @Nonnull
        public List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
            if (!((Boolean)DungeonsGearConfig.ENABLE_DUNGEONS_GEAR_LOOT.get()).booleanValue()) {
                return generatedLoot;
            }
            Vector3d vector3d = (Vector3d)context.func_216031_c(LootParameters.field_237457_g_);
            Entity contextEntity = (Entity)context.func_216031_c(LootParameters.field_216284_d);
            ResourceLocation lootTable = null;
            if (vector3d != null) {
                ContainerMinecartEntity containerMinecartEntity;
                BlockPos pos = new BlockPos(vector3d);
                TileEntity contextTileEntity = context.func_202879_g().func_175625_s(pos);
                if (contextTileEntity instanceof LockableLootTileEntity) {
                    LockableLootTileEntity lockableLootTileEntity = (LockableLootTileEntity)contextTileEntity;
                    lootTable = GlobalLootModifier.getLootTable(lockableLootTileEntity);
                    if (lootTable != null) {
                        String lootTablePath = lootTable.toString();
                        ((List)DungeonsGearConfig.SUPER_RARE_LOOT_TABLES.get()).forEach(path -> {
                            if (lootTablePath.contains((CharSequence)path) && !((List)DungeonsGearConfig.SUPER_RARE_LOOT_TABLES_BLACKLIST.get()).contains(lootTablePath)) {
                                generatedLoot.addAll(ChestLootHelper.generateLootFromValues((Double)DungeonsGearConfig.UNIQUE_ITEM_SUPER_RARE_LOOT.get(), (Double)DungeonsGearConfig.ARTIFACT_SUPER_RARE_LOOT.get()));
                            }
                        });
                    }
                } else if (contextEntity instanceof ContainerMinecartEntity && (lootTable = GlobalLootModifier.getLootTable(containerMinecartEntity = (ContainerMinecartEntity)contextEntity)) != null) {
                    String lootTablePath = lootTable.toString();
                    ((List)DungeonsGearConfig.SUPER_RARE_LOOT_TABLES.get()).forEach(path -> {
                        if (lootTablePath.contains((CharSequence)path) && !((List)DungeonsGearConfig.SUPER_RARE_LOOT_TABLES_BLACKLIST.get()).contains(lootTablePath)) {
                            generatedLoot.addAll(ChestLootHelper.generateLootFromValues((Double)DungeonsGearConfig.UNIQUE_ITEM_COMMON_LOOT.get(), (Double)DungeonsGearConfig.ARTIFACT_COMMON_LOOT.get()));
                        }
                    });
                }
            }
            return generatedLoot;
        }

        public static class Serializer
        extends GlobalLootModifierSerializer<SuperRareLootAdditions> {
            public SuperRareLootAdditions read(ResourceLocation name, JsonObject object, ILootCondition[] conditionsIn) {
                return new SuperRareLootAdditions(conditionsIn);
            }

            public JsonObject write(SuperRareLootAdditions instance) {
                return null;
            }
        }
    }

    public static class RareLootAdditions
    extends LootModifier {
        public RareLootAdditions(ILootCondition[] conditionsIn) {
            super(conditionsIn);
        }

        @Nonnull
        public List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
            if (!((Boolean)DungeonsGearConfig.ENABLE_DUNGEONS_GEAR_LOOT.get()).booleanValue()) {
                return generatedLoot;
            }
            Vector3d vector3d = (Vector3d)context.func_216031_c(LootParameters.field_237457_g_);
            Entity contextEntity = (Entity)context.func_216031_c(LootParameters.field_216284_d);
            ResourceLocation lootTable = null;
            if (vector3d != null) {
                ContainerMinecartEntity containerMinecartEntity;
                BlockPos pos = new BlockPos(vector3d);
                TileEntity contextTileEntity = context.func_202879_g().func_175625_s(pos);
                if (contextTileEntity instanceof LockableLootTileEntity) {
                    LockableLootTileEntity lockableLootTileEntity = (LockableLootTileEntity)contextTileEntity;
                    lootTable = GlobalLootModifier.getLootTable(lockableLootTileEntity);
                    if (lootTable != null) {
                        String lootTablePath = lootTable.toString();
                        ((List)DungeonsGearConfig.RARE_LOOT_TABLES.get()).forEach(path -> {
                            if (lootTablePath.contains((CharSequence)path) && !((List)DungeonsGearConfig.RARE_LOOT_TABLES_BLACKLIST.get()).contains(lootTablePath)) {
                                generatedLoot.addAll(ChestLootHelper.generateLootFromValues((Double)DungeonsGearConfig.UNIQUE_ITEM_RARE_LOOT.get(), (Double)DungeonsGearConfig.ARTIFACT_RARE_LOOT.get()));
                            }
                        });
                    }
                } else if (contextEntity instanceof ContainerMinecartEntity && (lootTable = GlobalLootModifier.getLootTable(containerMinecartEntity = (ContainerMinecartEntity)contextEntity)) != null) {
                    String lootTablePath = lootTable.toString();
                    ((List)DungeonsGearConfig.RARE_LOOT_TABLES.get()).forEach(path -> {
                        if (lootTablePath.contains((CharSequence)path) && !((List)DungeonsGearConfig.RARE_LOOT_TABLES_BLACKLIST.get()).contains(lootTablePath)) {
                            generatedLoot.addAll(ChestLootHelper.generateLootFromValues((Double)DungeonsGearConfig.UNIQUE_ITEM_COMMON_LOOT.get(), (Double)DungeonsGearConfig.ARTIFACT_COMMON_LOOT.get()));
                        }
                    });
                }
            }
            return generatedLoot;
        }

        public static class Serializer
        extends GlobalLootModifierSerializer<RareLootAdditions> {
            public RareLootAdditions read(ResourceLocation name, JsonObject object, ILootCondition[] conditionsIn) {
                return new RareLootAdditions(conditionsIn);
            }

            public JsonObject write(RareLootAdditions instance) {
                return null;
            }
        }
    }

    public static class UncommonLootAdditions
    extends LootModifier {
        public UncommonLootAdditions(ILootCondition[] conditionsIn) {
            super(conditionsIn);
        }

        @Nonnull
        public List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
            if (!((Boolean)DungeonsGearConfig.ENABLE_DUNGEONS_GEAR_LOOT.get()).booleanValue()) {
                return generatedLoot;
            }
            Vector3d vector3d = (Vector3d)context.func_216031_c(LootParameters.field_237457_g_);
            Entity contextEntity = (Entity)context.func_216031_c(LootParameters.field_216284_d);
            ResourceLocation lootTable = null;
            if (vector3d != null) {
                ContainerMinecartEntity containerMinecartEntity;
                BlockPos pos = new BlockPos(vector3d);
                TileEntity contextTileEntity = context.func_202879_g().func_175625_s(pos);
                if (contextTileEntity instanceof LockableLootTileEntity) {
                    LockableLootTileEntity lockableLootTileEntity = (LockableLootTileEntity)contextTileEntity;
                    lootTable = GlobalLootModifier.getLootTable(lockableLootTileEntity);
                    if (lootTable != null) {
                        String lootTablePath = lootTable.toString();
                        ((List)DungeonsGearConfig.UNCOMMON_LOOT_TABLES.get()).forEach(path -> {
                            if (lootTablePath.contains((CharSequence)path) && !((List)DungeonsGearConfig.UNCOMMON_LOOT_TABLES_BLACKLIST.get()).contains(lootTablePath)) {
                                generatedLoot.addAll(ChestLootHelper.generateLootFromValues((Double)DungeonsGearConfig.UNIQUE_ITEM_UNCOMMON_LOOT.get(), (Double)DungeonsGearConfig.ARTIFACT_UNCOMMON_LOOT.get()));
                            }
                        });
                    }
                } else if (contextEntity instanceof ContainerMinecartEntity && (lootTable = GlobalLootModifier.getLootTable(containerMinecartEntity = (ContainerMinecartEntity)contextEntity)) != null) {
                    String lootTablePath = lootTable.toString();
                    ((List)DungeonsGearConfig.UNCOMMON_LOOT_TABLES.get()).forEach(path -> {
                        if (lootTablePath.contains((CharSequence)path) && !((List)DungeonsGearConfig.UNCOMMON_LOOT_TABLES_BLACKLIST.get()).contains(lootTablePath)) {
                            generatedLoot.addAll(ChestLootHelper.generateLootFromValues((Double)DungeonsGearConfig.UNIQUE_ITEM_COMMON_LOOT.get(), (Double)DungeonsGearConfig.ARTIFACT_COMMON_LOOT.get()));
                        }
                    });
                }
            }
            return generatedLoot;
        }

        public static class Serializer
        extends GlobalLootModifierSerializer<UncommonLootAdditions> {
            public UncommonLootAdditions read(ResourceLocation name, JsonObject object, ILootCondition[] conditionsIn) {
                return new UncommonLootAdditions(conditionsIn);
            }

            public JsonObject write(UncommonLootAdditions instance) {
                return null;
            }
        }
    }

    public static class CommonLootAdditions
    extends LootModifier {
        public CommonLootAdditions(ILootCondition[] conditionsIn) {
            super(conditionsIn);
        }

        @Nonnull
        public List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
            if (!((Boolean)DungeonsGearConfig.ENABLE_DUNGEONS_GEAR_LOOT.get()).booleanValue()) {
                return generatedLoot;
            }
            Vector3d vector3d = (Vector3d)context.func_216031_c(LootParameters.field_237457_g_);
            Entity contextEntity = (Entity)context.func_216031_c(LootParameters.field_216284_d);
            ResourceLocation lootTable = null;
            if (vector3d != null) {
                ContainerMinecartEntity containerMinecartEntity;
                BlockPos pos = new BlockPos(vector3d);
                TileEntity contextTileEntity = context.func_202879_g().func_175625_s(pos);
                if (contextTileEntity instanceof LockableLootTileEntity) {
                    LockableLootTileEntity lockableLootTileEntity = (LockableLootTileEntity)contextTileEntity;
                    lootTable = GlobalLootModifier.getLootTable(lockableLootTileEntity);
                    if (lootTable != null) {
                        String lootTablePath = lootTable.toString();
                        ((List)DungeonsGearConfig.COMMON_LOOT_TABLES.get()).forEach(path -> {
                            if (lootTablePath.contains((CharSequence)path) && !((List)DungeonsGearConfig.COMMON_LOOT_TABLES_BLACKLIST.get()).contains(lootTablePath)) {
                                generatedLoot.addAll(ChestLootHelper.generateLootFromValues((Double)DungeonsGearConfig.UNIQUE_ITEM_COMMON_LOOT.get(), (Double)DungeonsGearConfig.ARTIFACT_COMMON_LOOT.get()));
                            }
                        });
                    }
                } else if (contextEntity instanceof ContainerMinecartEntity && (lootTable = GlobalLootModifier.getLootTable(containerMinecartEntity = (ContainerMinecartEntity)contextEntity)) != null) {
                    String lootTablePath = lootTable.toString();
                    ((List)DungeonsGearConfig.COMMON_LOOT_TABLES.get()).forEach(path -> {
                        if (lootTablePath.contains((CharSequence)path) && !((List)DungeonsGearConfig.COMMON_LOOT_TABLES_BLACKLIST.get()).contains(lootTablePath)) {
                            generatedLoot.addAll(ChestLootHelper.generateLootFromValues((Double)DungeonsGearConfig.UNIQUE_ITEM_COMMON_LOOT.get(), (Double)DungeonsGearConfig.ARTIFACT_COMMON_LOOT.get()));
                        }
                    });
                }
            }
            return generatedLoot;
        }

        public static class Serializer
        extends GlobalLootModifierSerializer<CommonLootAdditions> {
            public CommonLootAdditions read(ResourceLocation name, JsonObject object, ILootCondition[] conditionsIn) {
                return new CommonLootAdditions(conditionsIn);
            }

            public JsonObject write(CommonLootAdditions instance) {
                return null;
            }
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class GlobalLootModifierRegistry {
        @SubscribeEvent
        public static void registerModifierSerializers(@Nonnull RegistryEvent.Register<GlobalLootModifierSerializer<?>> event) {
            event.getRegistry().register((IForgeRegistryEntry)new CommonLootAdditions.Serializer().setRegistryName(new ResourceLocation("dungeons_gear", "common_loot_additions")));
            event.getRegistry().register((IForgeRegistryEntry)new UncommonLootAdditions.Serializer().setRegistryName(new ResourceLocation("dungeons_gear", "uncommon_loot_additions")));
            event.getRegistry().register((IForgeRegistryEntry)new RareLootAdditions.Serializer().setRegistryName(new ResourceLocation("dungeons_gear", "rare_loot_additions")));
            event.getRegistry().register((IForgeRegistryEntry)new SuperRareLootAdditions.Serializer().setRegistryName(new ResourceLocation("dungeons_gear", "super_rare_loot_additions")));
        }
    }
}

