/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_gear.loot;

import com.infamous.dungeons_gear.DungeonsGear;
import com.infamous.dungeons_gear.config.DungeonsGearConfig;
import com.infamous.dungeons_gear.init.DeferredItemInit;
import com.infamous.dungeons_gear.loot.TradeUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.merchant.IReputationType;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.entity.merchant.villager.WanderingTraderEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;
import net.minecraftforge.common.BasicTrade;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="dungeons_gear")
public class TradeEvents {
    @SubscribeEvent
    public static void onWandererTrades(WandererTradesEvent event) {
        if (!((Boolean)DungeonsGearConfig.ENABLE_VILLAGER_TRADES.get()).booleanValue()) {
            return;
        }
        List genericTrades = event.getGenericTrades();
        List rareTrades = event.getRareTrades();
        TradeEvents.moveTradesToDifferentGroup(rareTrades, genericTrades);
        for (Item item : DeferredItemInit.artifactMap.keySet()) {
            ResourceLocation resourceLocation = DeferredItemInit.artifactMap.get(item);
            Item artifact = (Item)ForgeRegistries.ITEMS.getValue(resourceLocation);
            ItemStack artifactStack = new ItemStack((IItemProvider)artifact);
            BasicTrade trade = new BasicTrade(((Integer)DungeonsGearConfig.ARTIFACT_VALUE.get()).intValue(), artifactStack, 3, 30);
            rareTrades.add(trade);
        }
    }

    @SubscribeEvent
    public static void onVillagerTrades(VillagerTradesEvent event) {
        if (!((Boolean)DungeonsGearConfig.ENABLE_VILLAGER_TRADES.get()).booleanValue()) {
            return;
        }
        if (event.getType() == VillagerProfession.field_221165_o) {
            Int2ObjectMap weaponsmithTrades = event.getTrades();
            VillagerTrades.ITrade diamondForEmeraldTrade = (VillagerTrades.ITrade)((List)weaponsmithTrades.get(4)).get(0);
            ((List)weaponsmithTrades.get(3)).add(diamondForEmeraldTrade);
            ((List)weaponsmithTrades.get(4)).remove(0);
            TradeEvents.addCommonAndUniqueTrades((Int2ObjectMap<List<VillagerTrades.ITrade>>)weaponsmithTrades, DeferredItemInit.commonWeaponMap, DeferredItemInit.uniqueWeaponMap);
        }
        if (event.getType() == VillagerProfession.field_221158_h) {
            Int2ObjectMap fletcherTrades = event.getTrades();
            VillagerTrades.ITrade emeraldForFeatherTrade = (VillagerTrades.ITrade)((List)fletcherTrades.get(4)).get(0);
            VillagerTrades.ITrade emeraldForTripwireHookTrade = (VillagerTrades.ITrade)((List)fletcherTrades.get(5)).get(0);
            VillagerTrades.ITrade emeraldAndArrowForTippedArrowTrade = (VillagerTrades.ITrade)((List)fletcherTrades.get(5)).get(2);
            ((List)fletcherTrades.get(2)).add(emeraldForFeatherTrade);
            ((List)fletcherTrades.get(3)).add(emeraldForTripwireHookTrade);
            ((List)fletcherTrades.get(3)).add(emeraldAndArrowForTippedArrowTrade);
            ((List)fletcherTrades.get(4)).remove(0);
            ((List)fletcherTrades.get(5)).remove(0);
            ((List)fletcherTrades.get(5)).remove(1);
            TradeEvents.addCommonAndUniqueTrades((Int2ObjectMap<List<VillagerTrades.ITrade>>)fletcherTrades, DeferredItemInit.commonRangedWeaponMap, DeferredItemInit.uniqueRangedWeaponMap);
        }
        if (event.getType() == VillagerProfession.field_221152_b) {
            Int2ObjectMap armorerTrades = event.getTrades();
            TradeEvents.addCommonAndUniqueTrades((Int2ObjectMap<List<VillagerTrades.ITrade>>)armorerTrades, DeferredItemInit.commonMetalArmorMap, DeferredItemInit.uniqueMetalArmorMap);
        }
        if (event.getType() == VillagerProfession.field_221159_i) {
            Int2ObjectMap leatherworkerTrades = event.getTrades();
            TradeEvents.moveTradesToDifferentGroup((List)leatherworkerTrades.get(4), (List)leatherworkerTrades.get(2));
            TradeEvents.moveTradesToDifferentGroup((List)leatherworkerTrades.get(5), (List)leatherworkerTrades.get(3));
            TradeEvents.addCommonAndUniqueTrades((Int2ObjectMap<List<VillagerTrades.ITrade>>)leatherworkerTrades, DeferredItemInit.commonLeatherArmorMap, DeferredItemInit.uniqueLeatherArmorMap);
        }
    }

    private static void addCommonAndUniqueTrades(Int2ObjectMap<List<VillagerTrades.ITrade>> villagerTrades, Map<Item, ResourceLocation> commonMap, Map<Item, ResourceLocation> uniqueMap) {
        TradeUtils.EnchantedItemForEmeraldsTrade trade;
        ItemStack weaponStack;
        Item weapon;
        ResourceLocation resourceLocation;
        for (Item item : commonMap.keySet()) {
            resourceLocation = commonMap.get(item);
            weapon = (Item)ForgeRegistries.ITEMS.getValue(resourceLocation);
            weaponStack = new ItemStack((IItemProvider)weapon);
            trade = new TradeUtils.EnchantedItemForEmeraldsTrade(weapon, (Integer)DungeonsGearConfig.COMMON_ITEM_VALUE.get(), 3, 15, 0.2f);
            ((List)villagerTrades.get(4)).add(trade);
        }
        for (Item item : uniqueMap.keySet()) {
            resourceLocation = uniqueMap.get(item);
            weapon = (Item)ForgeRegistries.ITEMS.getValue(resourceLocation);
            weaponStack = new ItemStack((IItemProvider)weapon);
            trade = new TradeUtils.EnchantedItemForEmeraldsTrade(weapon, (Integer)DungeonsGearConfig.UNIQUE_ITEM_VALUE.get(), 3, 30, 0.2f);
            ((List)villagerTrades.get(5)).add(trade);
        }
    }

    private static void moveTradesToDifferentGroup(List<VillagerTrades.ITrade> oldTradesGroup, List<VillagerTrades.ITrade> newTradesGroup) {
        Iterator<VillagerTrades.ITrade> it = oldTradesGroup.iterator();
        while (it.hasNext()) {
            VillagerTrades.ITrade currentTrade = it.next();
            if (currentTrade == null) continue;
            newTradesGroup.add(currentTrade);
            it.remove();
        }
    }

    @SubscribeEvent
    public static void onSalvageItem(PlayerInteractEvent.EntityInteract event) {
        ItemStack interactStack;
        if (!((Boolean)DungeonsGearConfig.ENABLE_SALVAGING.get()).booleanValue()) {
            return;
        }
        Entity entity = event.getTarget();
        PlayerEntity playerEntity = event.getPlayer();
        if (entity instanceof VillagerEntity) {
            VillagerEntity villagerEntity = (VillagerEntity)entity;
            if (villagerEntity.func_213700_eh().func_221130_b() == VillagerProfession.field_221165_o && playerEntity.func_225608_bj_()) {
                interactStack = playerEntity.func_184586_b(event.getHand());
                if (DeferredItemInit.commonWeaponMap.containsKey(interactStack.func_77973_b())) {
                    TradeEvents.handleSalvageTrade(playerEntity, (AbstractVillagerEntity)villagerEntity, interactStack, "COMMON");
                } else if (DeferredItemInit.uniqueWeaponMap.containsKey(interactStack.func_77973_b())) {
                    TradeEvents.handleSalvageTrade(playerEntity, (AbstractVillagerEntity)villagerEntity, interactStack, "UNIQUE");
                }
            }
            if (villagerEntity.func_213700_eh().func_221130_b() == VillagerProfession.field_221158_h && playerEntity.func_225608_bj_()) {
                interactStack = playerEntity.func_184586_b(event.getHand());
                if (DeferredItemInit.commonRangedWeaponMap.containsKey(interactStack.func_77973_b())) {
                    TradeEvents.handleSalvageTrade(playerEntity, (AbstractVillagerEntity)villagerEntity, interactStack, "COMMON");
                } else if (DeferredItemInit.uniqueRangedWeaponMap.containsKey(interactStack.func_77973_b())) {
                    TradeEvents.handleSalvageTrade(playerEntity, (AbstractVillagerEntity)villagerEntity, interactStack, "UNIQUE");
                }
            }
            if (villagerEntity.func_213700_eh().func_221130_b() == VillagerProfession.field_221152_b && playerEntity.func_225608_bj_()) {
                interactStack = playerEntity.func_184586_b(event.getHand());
                if (DeferredItemInit.commonMetalArmorMap.containsKey(interactStack.func_77973_b())) {
                    TradeEvents.handleSalvageTrade(playerEntity, (AbstractVillagerEntity)villagerEntity, interactStack, "COMMON");
                } else if (DeferredItemInit.uniqueMetalArmorMap.containsKey(interactStack.func_77973_b())) {
                    TradeEvents.handleSalvageTrade(playerEntity, (AbstractVillagerEntity)villagerEntity, interactStack, "UNIQUE");
                }
            }
            if (villagerEntity.func_213700_eh().func_221130_b() == VillagerProfession.field_221159_i && playerEntity.func_225608_bj_()) {
                interactStack = playerEntity.func_184586_b(event.getHand());
                if (DeferredItemInit.commonLeatherArmorMap.containsKey(interactStack.func_77973_b())) {
                    TradeEvents.handleSalvageTrade(playerEntity, (AbstractVillagerEntity)villagerEntity, interactStack, "COMMON");
                } else if (DeferredItemInit.uniqueLeatherArmorMap.containsKey(interactStack.func_77973_b())) {
                    TradeEvents.handleSalvageTrade(playerEntity, (AbstractVillagerEntity)villagerEntity, interactStack, "UNIQUE");
                }
            }
        }
        if (entity instanceof WanderingTraderEntity) {
            WanderingTraderEntity wanderingTraderEntity = (WanderingTraderEntity)entity;
            if (playerEntity.func_225608_bj_() && DeferredItemInit.artifactMap.containsKey((interactStack = playerEntity.func_184586_b(event.getHand())).func_77973_b())) {
                TradeEvents.handleSalvageTrade(playerEntity, (AbstractVillagerEntity)wanderingTraderEntity, interactStack, "ARTIFACT");
            }
        }
    }

    private static void handleSalvageTrade(PlayerEntity playerEntity, AbstractVillagerEntity abstractVillagerEntity, ItemStack interactStack, String itemType) {
        int itemValue;
        float maxDamage = interactStack.func_77958_k();
        DungeonsGear.LOGGER.info("Max damage: " + maxDamage);
        float currentDamage = maxDamage - (float)interactStack.func_77952_i();
        DungeonsGear.LOGGER.info("Current damage: " + currentDamage);
        switch (itemType.toUpperCase()) {
            case "COMMON": {
                itemValue = (Integer)DungeonsGearConfig.COMMON_ITEM_VALUE.get();
                break;
            }
            case "UNIQUE": {
                itemValue = (Integer)DungeonsGearConfig.UNIQUE_ITEM_VALUE.get();
                break;
            }
            case "ARTIFACT": {
                itemValue = (Integer)DungeonsGearConfig.ARTIFACT_VALUE.get();
                break;
            }
            default: {
                itemValue = (Integer)DungeonsGearConfig.COMMON_ITEM_VALUE.get();
            }
        }
        int emeraldReward = Math.round((float)itemValue * 0.375f);
        float durabilityModifier = currentDamage / maxDamage;
        emeraldReward = Math.round((float)emeraldReward * durabilityModifier);
        if (emeraldReward > 0) {
            interactStack.func_190918_g(1);
            if (abstractVillagerEntity instanceof VillagerEntity) {
                VillagerEntity villagerEntity = (VillagerEntity)abstractVillagerEntity;
                villagerEntity.field_70170_p.func_184148_a((PlayerEntity)null, abstractVillagerEntity.func_226277_ct_(), abstractVillagerEntity.func_226278_cu_(), abstractVillagerEntity.func_226281_cx_(), SoundEvents.field_187915_go, SoundCategory.PLAYERS, 64.0f, 1.0f);
                villagerEntity.func_213739_a(IReputationType.field_221033_e, (Entity)playerEntity);
            } else if (abstractVillagerEntity instanceof WanderingTraderEntity) {
                WanderingTraderEntity wanderingTraderEntity = (WanderingTraderEntity)abstractVillagerEntity;
                wanderingTraderEntity.field_70170_p.func_184148_a((PlayerEntity)null, wanderingTraderEntity.func_226277_ct_(), wanderingTraderEntity.func_226278_cu_(), wanderingTraderEntity.func_226281_cx_(), SoundEvents.field_219724_nc, SoundCategory.PLAYERS, 64.0f, 1.0f);
            }
            ItemStack emeraldStack = new ItemStack((IItemProvider)Items.field_151166_bC, emeraldReward);
            if (!playerEntity.func_191521_c(emeraldStack)) {
                World world = playerEntity.func_130014_f_();
                ItemEntity emeraldStackEntity = new ItemEntity(world, playerEntity.func_226277_ct_(), playerEntity.func_226278_cu_(), playerEntity.func_226281_cx_(), emeraldStack);
                world.func_217376_c((Entity)emeraldStackEntity);
            }
            playerEntity.func_195068_e(emeraldReward);
        }
    }
}

